/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.HTTPListenerMonitor;
import com.sun.appserv.management.monitor.HTTPServiceMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.HTTPListenerStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Map;
import java.util.Timer;

public class HttpListenerMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-4s %2$-4s %3$-4s %4$-4s %5$-4s %6$-4s %7$-4s %8$-4s %9$-4s %10$-4s %11$-4s %12$-4s %13$-4s %14$-4s %15$-4s %16$-4s %17$-4s %18$-4s %19$-4s %20$-4s %21$-4s %22$-4s %23$-4s %24$-4s %25$-4s %26$-4s";

    public HttpListenerMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        HTTPServiceMonitor httpserviceMonitor = srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.unable_to_monitor_httplistener"));
        }
        Map httpListenerMap = httpserviceMonitor.getHTTPListenerMonitorMap();
        if (httpListenerMap == null) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.unable_to_monitor_httplistener"));
        }
        String[] keys = MapUtil.getKeyStrings((Map)httpListenerMap);
        if (this.filter == null) {
            this.checkForNumberOfElements(keys);
            this.filter = keys[0];
        } else if (!httpListenerMap.containsKey(this.filter)) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.filter}));
        }
        String httpListenerTitle = localStrings.getString("commands.monitor.httplistener_monitoring_title", new Object[]{this.filter});
        String title = String.format("%1$60s", httpListenerTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        HTTPServiceMonitor httpserviceMonitor = this.srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        Map httpListenerMap = httpserviceMonitor.getHTTPListenerMonitorMap();
        if (httpListenerMap == null || httpListenerMap.size() < 1) {
            this.cancelMonitorTask();
            return;
        }
        HTTPListenerMonitor httpListenerMonitor = (HTTPListenerMonitor)httpListenerMap.get(this.filter);
        if (httpListenerMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        HTTPListenerStats httpListenerStats = httpListenerMonitor.getHTTPListenerStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(httpListenerStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void displayHeader() {
        String br = localStrings.getString("commands.monitor.br");
        String bs = localStrings.getString("commands.monitor.bs");
        String c200 = localStrings.getString("commands.monitor.c200");
        String c2xx = localStrings.getString("commands.monitor.c2xx");
        String c302 = localStrings.getString("commands.monitor.c302");
        String c304 = localStrings.getString("commands.monitor.c304");
        String c3xx = localStrings.getString("commands.monitor.c3xx");
        String c400 = localStrings.getString("commands.monitor.c400");
        String c401 = localStrings.getString("commands.monitor.c401");
        String c403 = localStrings.getString("commands.monitor.c403");
        String c404 = localStrings.getString("commands.monitor.c404");
        String c4xx = localStrings.getString("commands.monitor.c4xx");
        String c503 = localStrings.getString("commands.monitor.c503");
        String c5xx = localStrings.getString("commands.monitor.c5xx");
        String coc = localStrings.getString("commands.monitor.coc");
        String co = localStrings.getString("commands.monitor.co");
        String ctc = localStrings.getString("commands.monitor.ctc");
        String ctb = localStrings.getString("commands.monitor.ctb");
        String ec = localStrings.getString("commands.monitor.ec");
        String moc = localStrings.getString("commands.monitor.moc");
        String mst = localStrings.getString("commands.monitor.mst");
        String mt = localStrings.getString("commands.monitor.mt");
        String mtm = localStrings.getString("commands.monitor.mtm");
        String pt = localStrings.getString("commands.monitor.pt");
        String rc = localStrings.getString("commands.monitor.rc");
        String header = String.format("%1$-4s %2$-4s %3$-4s %4$-4s %5$-4s %6$-4s %7$-4s %8$-4s %9$-4s %10$-4s %11$-4s %12$-4s %13$-4s %14$-4s %15$-4s %16$-4s %17$-4s %18$-4s %19$-4s %20$-4s %21$-4s %22$-4s %23$-4s %24$-4s %25$-4s %26$-4s", br, bs, c200, c2xx, c302, c304, c3xx, c400, c401, c403, c404, c4xx, c503, c5xx, coc, co, ctc, ctb, ec, moc, mst, mt, mtm, mst, pt, rc);
        CLILogger.getInstance().printMessage(header);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.httplistener_write_to_file"));
        }
    }

    private void displayData(HTTPListenerStats hls) {
        String data = String.format("%1$-4s %2$-4s %3$-4s %4$-4s %5$-4s %6$-4s %7$-4s %8$-4s %9$-4s %10$-4s %11$-4s %12$-4s %13$-4s %14$-4s %15$-4s %16$-4s %17$-4s %18$-4s %19$-4s %20$-4s %21$-4s %22$-4s %23$-4s %24$-4s %25$-4s %26$-4s", hls.getBytesReceived().getCount(), hls.getBytesSent().getCount(), hls.getCount200().getCount(), hls.getCount2xx().getCount(), hls.getCount302().getCount(), hls.getCount304().getCount(), hls.getCount3xx().getCount(), hls.getCount400().getCount(), hls.getCount401().getCount(), hls.getCount403().getCount(), hls.getCount404().getCount(), hls.getCount4xx().getCount(), hls.getCount503().getCount(), hls.getCount5xx().getCount(), hls.getCountOpenConnections().getCount(), hls.getCountOther().getCount(), hls.getCurrentThreadCount().getCount(), hls.getCurrentThreadsBusy().getCount(), hls.getErrorCount().getCount(), hls.getMaxOpenConnections().getCount(), hls.getMaxSpareThreads().getCount(), hls.getMaxThreads().getCount(), hls.getMaxTime().getCount(), hls.getMinSpareThreads().getCount(), hls.getProcessingTime().getCount(), hls.getRequestCount().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s,%10$s,%11$s,%12$s,%13$s,%14$s,%15$s,%16$s,%17$s,%18$s,%19$s,%20$s,%21$s,%22$s,%23$s,%24$s,%25$s,%26$s", hls.getBytesReceived().getCount(), hls.getBytesSent().getCount(), hls.getCount200().getCount(), hls.getCount2xx().getCount(), hls.getCount302().getCount(), hls.getCount304().getCount(), hls.getCount3xx().getCount(), hls.getCount400().getCount(), hls.getCount401().getCount(), hls.getCount403().getCount(), hls.getCount404().getCount(), hls.getCount4xx().getCount(), hls.getCount503().getCount(), hls.getCount5xx().getCount(), hls.getCountOpenConnections().getCount(), hls.getCountOther().getCount(), hls.getCurrentThreadCount().getCount(), hls.getCurrentThreadsBusy().getCount(), hls.getErrorCount().getCount(), hls.getMaxOpenConnections().getCount(), hls.getMaxSpareThreads().getCount(), hls.getMaxThreads().getCount(), hls.getMaxTime().getCount(), hls.getMinSpareThreads().getCount(), hls.getProcessingTime().getCount(), hls.getRequestCount().getCount());
            this.writeToFile(fileData);
        }
    }

    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.httplistener_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

