/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.JDBCConnectionPoolMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.AltJDBCConnectionPoolStats;
import com.sun.appserv.management.monitor.statistics.ConnectionPoolStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.ConnectionPoolTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Map;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPoolMonitorTask
extends ConnectionPoolTask {
    public JDBCPoolMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        Map jdbcMap = srm.getJDBCConnectionPoolMonitorMap();
        if (jdbcMap == null) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.unable_to_monitor_jdbc_pool"));
        }
        String[] keys = MapUtil.getKeyStrings((Map)jdbcMap);
        if (this.filter == null) {
            this.checkForNumberOfElements(keys);
            this.filter = keys[0];
        } else if (!jdbcMap.containsKey(this.filter)) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.filter}));
        }
        String jdbcPoolMonitoring = localStrings.getString("commands.monitor.jdbc_pool_monitoring", new Object[]{this.filter});
        String title = String.format("%1$60s", jdbcPoolMonitoring);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    @Override
    public void run() {
        Map jdbcMap;
        if (this.srm == null) {
            super.cancelMonitorTask();
        }
        if ((jdbcMap = this.srm.getJDBCConnectionPoolMonitorMap()) == null) {
            this.cancelMonitorTask();
        } else {
            if (this.verbose && this.counter == 25) {
                this.displayHeader();
                this.counter = 0;
            }
            this.monitorConnectionPool(this.filter, jdbcMap);
            if (this.verbose) {
                ++this.counter;
            }
        }
    }

    private void monitorConnectionPool(String element, Map<String, JDBCConnectionPoolMonitor> jdbcMap) {
        JDBCConnectionPoolMonitor jdbcPoolMonitor = jdbcMap.get(element);
        AltJDBCConnectionPoolStats stats = jdbcPoolMonitor.getAltJDBCConnectionPoolStats();
        this.displayData((ConnectionPoolStats)stats);
    }
}

