/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public abstract class MonitorTask
extends TimerTask {
    final int NUM_ROWS = 25;
    int counter = 0;
    ServerRootMonitor srm = null;
    String monitorType = null;
    String filter = null;
    Timer timer = null;
    File fileName = null;
    boolean verbose = false;
    static final StringManager localStrings = StringManager.getManager(MonitorTask.class);

    public MonitorTask() {
    }

    public abstract void displayDetails();

    public MonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) {
        this.srm = srm;
        this.timer = timer;
        if (filter != null) {
            this.filter = filter;
        }
        this.verbose = verbose;
        this.fileName = fileName;
    }

    void cancelMonitorTask() {
        this.timer.cancel();
        String msg = localStrings.getString("commands.monitor.press_to_quit");
        CLILogger.getInstance().printMessage(msg);
    }

    void checkForNumberOfElements(String[] keys) throws MonitorTaskException {
        if (keys.length < 1) {
            throw new MonitorTaskException(localStrings.getString("command.monitor.no_value_to_monitor"));
        }
        if (keys.length > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append(localStrings.getString("commands.monitor.more_than_one_monitoring_elements"));
            sb.append(localStrings.getString("commands.monitor.available_elements"));
            for (String key : keys) {
                sb.append("    ");
                sb.append(key);
                sb.append("\n");
            }
            throw new MonitorTaskException(sb.toString());
        }
    }

    synchronized void writeToFile(String text) {
        block2: {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.fileName, true));
                out.append(text);
                out.newLine();
                out.close();
            }
            catch (IOException ioe) {
                String unableToWriteFile = localStrings.getString("commands.monitor.unable_to_write_to_file", new Object[]{this.fileName.getName()});
                CLILogger.getInstance().printMessage(unableToWriteFile);
                if (!this.verbose) break block2;
                ioe.printStackTrace();
            }
        }
    }
}

