/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.ThreadPoolMonitor;
import com.sun.appserv.management.monitor.statistics.ThreadPoolStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Map;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-20s %9$-5s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s";

    public ThreadPoolMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        Map threadpoolMap = srm.getThreadPoolMonitorMap();
        if (threadpoolMap == null) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.unable_to_monitor_threadpool"));
        }
        String[] keys = MapUtil.getKeyStrings((Map)threadpoolMap);
        if (this.filter == null) {
            this.checkForNumberOfElements(keys);
            this.filter = keys[0];
        } else if (!threadpoolMap.containsKey(this.filter)) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.filter}));
        }
        String threadPoolMonitoringTitle = localStrings.getString("commands.monitor.thread_pool_monitoring_title", new Object[]{this.filter});
        String title = String.format("%1$70s", threadPoolMonitoringTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    @Override
    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        Map threadpoolMap = this.srm.getThreadPoolMonitorMap();
        if (threadpoolMap == null || threadpoolMap.size() < 1) {
            this.cancelMonitorTask();
            return;
        }
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.monitorThreadPool(this.filter, threadpoolMap);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void monitorThreadPool(String element, Map<String, ThreadPoolMonitor> threadpoolMap) {
        ThreadPoolMonitor threadpoolMonitor = threadpoolMap.get(element);
        ThreadPoolStats threadpoolStats = threadpoolMonitor.getThreadPoolStats();
        this.displayData(threadpoolStats);
    }

    private void displayHeader() {
        String avgTimeInQueue = localStrings.getString("commands.monitor.AvgTimeInQueue");
        String avgWorkCompTime = localStrings.getString("commands.monitor.AvgWorkCompTime");
        String currNumOfThreads = localStrings.getString("commands.monitor.CurrNumOfThreads");
        String low = localStrings.getString("commands.monitor.low");
        String hi = localStrings.getString("commands.monitor.hi");
        String cur = localStrings.getString("commands.monitor.cur");
        String min = localStrings.getString("commands.monitor.min");
        String max = localStrings.getString("commands.monitor.max");
        String avl = localStrings.getString("commands.monitor.avl");
        String busy = localStrings.getString("commands.monitor.busy");
        String add = localStrings.getString("commands.monitor.add");
        String header = String.format("%1$2s %2$18s %3$30s", avgTimeInQueue, avgWorkCompTime, currNumOfThreads);
        String subHeader = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-20s %9$-5s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s", low, hi, cur, low, hi, cur, min, max, low, hi, cur, avl, busy, add);
        CLILogger.getInstance().printMessage(header);
        CLILogger.getInstance().printMessage(subHeader);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.thread_pool_write_to_file"));
        }
    }

    private void displayData(ThreadPoolStats tps) {
        String data = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-20s %9$-5s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s", tps.getAverageTimeInQueue().getLowWaterMark(), tps.getAverageTimeInQueue().getHighWaterMark(), tps.getAverageTimeInQueue().getCurrent(), tps.getAverageWorkCompletionTime().getLowWaterMark(), tps.getAverageWorkCompletionTime().getHighWaterMark(), tps.getAverageWorkCompletionTime().getCurrent(), tps.getCurrentNumberOfThreads().getLowerBound(), tps.getCurrentNumberOfThreads().getUpperBound(), tps.getCurrentNumberOfThreads().getLowWaterMark(), tps.getCurrentNumberOfThreads().getHighWaterMark(), tps.getCurrentNumberOfThreads().getCurrent(), tps.getNumberOfAvailableThreads().getCount(), tps.getNumberOfBusyThreads().getCount(), tps.getTotalWorkItemsAdded().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s,%10$s,%11$s,%12$s,%13$s,%14$s", tps.getAverageTimeInQueue().getLowWaterMark(), tps.getAverageTimeInQueue().getHighWaterMark(), tps.getAverageTimeInQueue().getCurrent(), tps.getAverageWorkCompletionTime().getLowWaterMark(), tps.getAverageWorkCompletionTime().getHighWaterMark(), tps.getAverageWorkCompletionTime().getCurrent(), tps.getCurrentNumberOfThreads().getLowerBound(), tps.getCurrentNumberOfThreads().getUpperBound(), tps.getCurrentNumberOfThreads().getLowWaterMark(), tps.getCurrentNumberOfThreads().getHighWaterMark(), tps.getCurrentNumberOfThreads().getCurrent(), tps.getNumberOfAvailableThreads().getCount(), tps.getNumberOfBusyThreads().getCount(), tps.getTotalWorkItemsAdded().getCount());
            this.writeToFile(fileData);
        }
    }

    @Override
    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.thread_pool_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

