/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import com.sun.corba.ee.impl.codegen.Node;
import com.sun.corba.ee.spi.orbutil.generic.NullaryFunction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute<T> {
    private static List<Attribute<?>> attributes = new ArrayList();
    private String name;
    private NullaryFunction<T> initializer;
    private T defaultValue;
    private Class<?> cls;
    private int attributeIndex;

    private static synchronized int next(Attribute<?> attr) {
        for (int ctr = 0; ctr < attributes.size(); ++ctr) {
            if (!attr.name().equals(attributes.get(ctr).name())) continue;
            return ctr;
        }
        int result = attributes.size();
        attributes.add(attr);
        return result;
    }

    public static int numberOfAttributes() {
        return attributes.size();
    }

    public static Attribute<?> get(int index) {
        if (index >= 0 && index < attributes.size()) {
            return attributes.get(index);
        }
        throw new IllegalArgumentException();
    }

    public static Set<Attribute<?>> getAttributes(Node node) {
        List<Object> attrs = node.attributes();
        HashSet result = new HashSet();
        if (attrs == null) {
            return result;
        }
        for (int ctr = 0; ctr < attrs.size(); ++ctr) {
            Object value = attrs.get(ctr);
            if (value == null) continue;
            result.add(attributes.get(ctr));
        }
        return result;
    }

    public String toString() {
        return "Attribute[" + this.name + ":" + this.cls.getName() + ":" + this.attributeIndex + "]";
    }

    public Attribute(Class<T> cls, String name, T defaultValue) {
        this.cls = cls;
        this.name = name;
        this.initializer = null;
        this.defaultValue = defaultValue;
        this.attributeIndex = Attribute.next(this);
    }

    public Attribute(Class<?> cls, String name, NullaryFunction<T> initializer) {
        this.cls = cls;
        this.name = name;
        this.initializer = initializer;
        this.defaultValue = null;
        this.attributeIndex = Attribute.next(this);
    }

    public T get(Node node) {
        Object result = node.get(this.attributeIndex);
        if (result == null) {
            result = this.initializer != null ? this.initializer.evaluate() : this.defaultValue;
            node.set(this.attributeIndex, result);
        }
        return (T)result;
    }

    public void set(Node node, T arg) {
        node.set(this.attributeIndex, arg);
    }

    public boolean isSet(Node node) {
        return node.get(this.attributeIndex) != null;
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.attributeIndex;
    }

    public Class<?> type() {
        return this.cls;
    }
}

