/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.newtimer.TimingPoints;
import com.sun.corba.ee.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.ContactInfoList;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListIterator;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import com.sun.corba.ee.spi.transport.TcpTimeouts;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class CorbaContactInfoListIteratorImpl
implements CorbaContactInfoListIterator {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected RuntimeException failureException;
    protected ORBUtilSystemException wrapper;
    private TimingPoints tp;
    protected TcpTimeouts tcpTimeouts;
    protected boolean debug;
    protected Iterator<CorbaContactInfo> effectiveTargetIORIterator;
    protected CorbaContactInfo previousContactInfo;
    protected boolean isAddrDispositionRetry;
    protected boolean retryWithPreviousContactInfo;
    protected IIOPPrimaryToContactInfo primaryToContactInfo;
    protected ContactInfo primaryContactInfo;
    protected List<CorbaContactInfo> listOfContactInfos;
    protected TcpTimeouts.Waiter waiter;
    protected Set<ContactInfo> failedEndpoints;

    public CorbaContactInfoListIteratorImpl(ORB orb, CorbaContactInfoList corbaContactInfoList, ContactInfo primaryContactInfo, List listOfContactInfos) {
        this.orb = orb;
        this.tp = orb.getTimerManager().points();
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
        this.tcpTimeouts = orb.getORBData().getTransportTcpConnectTimeouts();
        this.debug = orb.transportDebugFlag;
        this.contactInfoList = corbaContactInfoList;
        this.primaryContactInfo = primaryContactInfo;
        if (listOfContactInfos != null) {
            this.effectiveTargetIORIterator = listOfContactInfos.iterator();
        }
        this.listOfContactInfos = listOfContactInfos;
        this.previousContactInfo = null;
        this.isAddrDispositionRetry = false;
        this.retryWithPreviousContactInfo = false;
        this.failureException = null;
        this.waiter = this.tcpTimeouts.waiter();
        this.failedEndpoints = new HashSet<ContactInfo>();
        this.primaryToContactInfo = orb.getORBData().getIIOPPrimaryToContactInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        boolean result = false;
        try {
            this.tp.enter_contactInfoListIteratorHasNext();
            if (this.debug) {
                this.dprint(".hasNext->:");
            }
            if (this.retryWithPreviousContactInfo) {
                if (this.debug) {
                    this.dprint(".hasNext: backoff before retry previous");
                }
                if (this.waiter.isExpired()) {
                    if (this.debug) {
                        this.dprint(".hasNext: time to wait for connection exceeded " + this.tcpTimeouts.get_max_time_to_wait());
                    }
                    this.failureException = this.wrapper.communicationsRetryTimeout(this.failureException, (Object)Long.toString(this.tcpTimeouts.get_max_time_to_wait()));
                    boolean bl = false;
                    return bl;
                }
                this.waiter.sleepTime();
                this.waiter.advance();
                boolean bl = true;
                return bl;
            }
            if (this.isAddrDispositionRetry) {
                boolean bl = true;
                return bl;
            }
            result = this.primaryToContactInfo != null ? this.primaryToContactInfo.hasNext(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.hasNext();
            if (!result && !this.waiter.isExpired()) {
                if (this.debug) {
                    this.dprint("Reached end of ContactInfoList list. Starting at beginning");
                }
                this.previousContactInfo = null;
                if (this.primaryToContactInfo != null) {
                    this.primaryToContactInfo.reset(this.primaryContactInfo);
                } else {
                    this.effectiveTargetIORIterator = this.listOfContactInfos.iterator();
                }
                boolean bl = result = this.hasNext();
                return bl;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.tp.exit_contactInfoListIteratorHasNext();
            if (this.debug) {
                this.dprint(".hasNext<-: " + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorbaContactInfo next() {
        try {
            this.tp.enter_contactInfoListIteratorNext();
            if (this.retryWithPreviousContactInfo) {
                this.retryWithPreviousContactInfo = false;
                CorbaContactInfo corbaContactInfo = this.previousContactInfo;
                return corbaContactInfo;
            }
            if (this.isAddrDispositionRetry) {
                this.isAddrDispositionRetry = false;
                CorbaContactInfo corbaContactInfo = this.previousContactInfo;
                return corbaContactInfo;
            }
            this.previousContactInfo = this.primaryToContactInfo != null ? (CorbaContactInfo)this.primaryToContactInfo.next(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.next();
            if (this.failedEndpoints.contains(this.previousContactInfo)) {
                this.failedEndpoints.clear();
                this.waiter.sleepTime();
                this.waiter.advance();
            }
            CorbaContactInfo corbaContactInfo = this.previousContactInfo;
            return corbaContactInfo;
        }
        finally {
            this.tp.exit_contactInfoListIteratorNext();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public ContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    public void reportSuccess(ContactInfo contactInfo) {
        if (this.debug) {
            this.dprint(".reportSuccess: " + contactInfo);
        }
        this.failedEndpoints.clear();
        this.waiter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportException(ContactInfo contactInfo, RuntimeException ex) {
        boolean result = false;
        try {
            this.tp.enter_contactInfoListIteratorReportException();
            if (this.debug) {
                this.dprint(".reportException->: " + contactInfo + " " + ex);
            }
            this.failedEndpoints.add(contactInfo);
            this.failureException = ex;
            if (ex instanceof COMM_FAILURE) {
                SystemException se = (SystemException)((Object)ex);
                if (se.minor == 1398079697) {
                    if (this.debug) {
                        this.dprint(".reportException: " + contactInfo + " " + ex + ": COMM_FAILURE/CONNECTION_REBIND - retryWithPreviousContactInfo");
                    }
                    this.retryWithPreviousContactInfo = true;
                    boolean bl = result = true;
                    return bl;
                }
                if (se.completed == CompletionStatus.COMPLETED_NO) {
                    if (this.hasNext()) {
                        if (this.debug) {
                            this.dprint(".reportException: " + contactInfo + " " + ex + ": COMM_FAILURE/COMPLETED_NO and hasNext/true - try next ContactInfo");
                        }
                        boolean bl = result = true;
                        return bl;
                    }
                    if (this.contactInfoList.getEffectiveTargetIOR() != this.contactInfoList.getTargetIOR()) {
                        if (this.debug) {
                            this.dprint(".reportException: " + contactInfo + " " + ex + ": COMM_FAILURE/COMPLETED_NO and hasNext/false and effect != target - retry target");
                        }
                        this.updateEffectiveTargetIOR(this.contactInfoList.getTargetIOR());
                        boolean bl = result = true;
                        return bl;
                    }
                }
            } else if (ex instanceof TRANSIENT) {
                if (this.debug) {
                    this.dprint(".reportException: " + contactInfo + " " + ex + ": TRANSIENT - retryWithPreviousContactInfo");
                }
                this.retryWithPreviousContactInfo = true;
                boolean bl = result = true;
                return bl;
            }
            result = false;
            this.waiter.reset();
            boolean bl = result;
            return bl;
        }
        finally {
            this.tp.exit_contactInfoListIteratorReportException();
            if (this.debug) {
                this.dprint(".reportException<-: " + contactInfo + " " + ex + ": " + result);
            }
        }
    }

    public RuntimeException getFailureException() {
        if (this.failureException == null) {
            return this.orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil().invalidContactInfoListIteratorFailureException();
        }
        return this.failureException;
    }

    public void reportAddrDispositionRetry(CorbaContactInfo contactInfo, short disposition) {
        if (this.debug) {
            this.dprint(".reportAddrDispositionRetry: " + contactInfo + " " + disposition);
        }
        this.previousContactInfo.setAddressingDisposition(disposition);
        this.isAddrDispositionRetry = true;
        this.waiter.reset();
    }

    public void reportRedirect(CorbaContactInfo contactInfo, IOR forwardedIOR) {
        if (this.debug) {
            this.dprint(".reportRedirect: " + contactInfo + " " + forwardedIOR);
        }
        this.updateEffectiveTargetIOR(forwardedIOR);
        this.waiter.reset();
    }

    public void updateEffectiveTargetIOR(IOR newIOR) {
        this.contactInfoList.setEffectiveTargetIOR(newIOR);
        ((CorbaInvocationInfo)this.orb.getInvocationInfo()).setContactInfoListIterator(this.contactInfoList.iterator());
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaContactInfoListIteratorImpl", msg);
    }
}

