/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EntityContextImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

class ActiveTxCache {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private EntityContextImpl[] buckets;
    private int bucketMask;

    ActiveTxCache(int numBuckets) {
        this.bucketMask = numBuckets - 1;
        this.initialize();
    }

    EntityContextImpl get(BaseContainer container, Object pk) {
        int pkHashCode = pk.hashCode();
        int index = this.getIndex(pkHashCode);
        for (EntityContextImpl ctx = this.buckets[index]; ctx != null; ctx = ctx._getNext()) {
            if (!ctx.doesMatch(container, pkHashCode, pk)) continue;
            return ctx;
        }
        return null;
    }

    void add(EntityContextImpl ctx) {
        ctx.cachePrimaryKey();
        int index = this.getIndex(ctx._getPKHashCode());
        ctx._setNext(this.buckets[index]);
        this.buckets[index] = ctx;
    }

    EntityContextImpl remove(BaseContainer container, Object pk) {
        EntityContextImpl ctx;
        int pkHashCode = pk.hashCode();
        int index = this.getIndex(pkHashCode);
        EntityContextImpl prev = null;
        for (ctx = this.buckets[index]; ctx != null; ctx = ctx._getNext()) {
            if (ctx.doesMatch(container, pkHashCode, pk)) {
                if (prev == null) {
                    this.buckets[index] = ctx._getNext();
                } else {
                    prev._setNext(ctx._getNext());
                }
                ctx._setNext(null);
                break;
            }
            prev = ctx;
        }
        return ctx;
    }

    EntityContextImpl remove(Object pk, EntityContextImpl existingCtx) {
        EntityContextImpl ctx;
        int pkHashCode = pk.hashCode();
        int index = this.getIndex(pkHashCode);
        EntityContextImpl prev = null;
        for (ctx = this.buckets[index]; ctx != null; ctx = ctx._getNext()) {
            if (ctx == existingCtx) {
                if (prev == null) {
                    this.buckets[index] = ctx._getNext();
                } else {
                    prev._setNext(ctx._getNext());
                }
                ctx._setNext(null);
                break;
            }
            prev = ctx;
        }
        return ctx;
    }

    private void initialize() {
        this.buckets = new EntityContextImpl[this.bucketMask + 1];
    }

    private final int getIndex(int hashCode) {
        return hashCode & this.bucketMask;
    }
}

