/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.threadpool.Servicable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;

public class NonBlockingPool
extends AbstractPool {
    private String poolName;
    private TimerTask poolTimerTask;
    protected boolean addedResizeTask = false;
    protected boolean addedIdleBeanWork = false;
    protected boolean inResizing = false;
    private boolean maintainSteadySize = false;
    private int resizeTaskCount;
    private int timerTaskCount;

    protected NonBlockingPool() {
    }

    public NonBlockingPool(String poolName, ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this.poolName = poolName;
        this.initializePool(factory, steadyPoolSize, resizeQuantity, maxPoolSize, idleTimeoutInSeconds, loader);
    }

    protected void initializePool(ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this.list = new ArrayList();
        this.factory = factory;
        this.steadyPoolSize = steadyPoolSize <= 0 ? 0 : steadyPoolSize;
        this.resizeQuantity = resizeQuantity <= 0 ? 0 : resizeQuantity;
        this.maxPoolSize = maxPoolSize <= 0 ? Integer.MAX_VALUE : maxPoolSize;
        this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds <= 0 ? 0 : idleTimeoutInSeconds;
        this.containerClassLoader = loader;
        boolean bl = this.maintainSteadySize = this.steadyPoolSize > 0;
        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) {
            try {
                this.poolTimerTask = new PoolResizeTimerTask();
                ContainerFactoryImpl.getTimer().scheduleAtFixedRate(this.poolTimerTask, idleTimeoutInSeconds * 1000, (long)(idleTimeoutInSeconds * 1000));
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Could not add" + " PoolTimerTask. Continuing anyway...", th);
            }
        }
    }

    public void setContainerClassLoader(ClassLoader loader) {
        this.containerClassLoader = loader;
    }

    public Object getObject(boolean canWait, Object param) throws PoolException {
        return this.getObject(param);
    }

    public Object getObject(long maxWaitTime, Object param) throws PoolException {
        return this.getObject(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object getObject(Object param) {
        Object obj;
        boolean toAddResizeTask;
        block13: {
            toAddResizeTask = false;
            obj = null;
            ArrayList arrayList = this.list;
            // MONITORENTER : arrayList
            int size = this.list.size();
            if (size > this.steadyPoolSize) {
                ++this.poolSuccess;
                // MONITOREXIT : arrayList
                return this.list.remove(size - 1);
            }
            if (size > 0) {
                ++this.poolSuccess;
                if (this.maintainSteadySize && !this.addedResizeTask) {
                    this.addedResizeTask = true;
                    toAddResizeTask = true;
                    obj = this.list.remove(size - 1);
                    break block13;
                } else {
                    // MONITOREXIT : arrayList
                    return this.list.remove(size - 1);
                }
            }
            if (this.maintainSteadySize && !this.addedResizeTask) {
                this.addedResizeTask = true;
                toAddResizeTask = true;
            }
            ++this.createdCount;
        }
        // MONITOREXIT : arrayList
        if (toAddResizeTask) {
            this.addResizeTaskForImmediateExecution();
        }
        if (obj != null) {
            return obj;
        }
        try {
            return this.factory.create(param);
        }
        catch (RuntimeException th) {
            ArrayList arrayList = this.list;
            // MONITORENTER : arrayList
            --this.createdCount;
            // MONITOREXIT : arrayList
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResizeTaskForImmediateExecution() {
        block6: {
            try {
                ReSizeWork work = new ReSizeWork();
                ContainerWorkPool.addLast(work);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
                ++this.resizeTaskCount;
            }
            catch (Exception ex) {
                ArrayList arrayList = this.list;
                synchronized (arrayList) {
                    this.addedResizeTask = false;
                }
                if (!_logger.isLoggable(Level.WARNING)) break block6;
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Cannot perform " + " pool resize task", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.list.size() < this.maxPoolSize) {
                this.list.add(object);
                return;
            }
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in returnObj", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in destroyObject", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload(int count) {
        int sz;
        ArrayList<Object> instances = new ArrayList<Object>(count);
        try {
            for (int i = 0; i < count; ++i) {
                instances.add(this.factory.create(null));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if ((sz = instances.size()) == 0) {
            return;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            for (int i = 0; i < sz; ++i) {
                this.list.add(instances.get(i));
            }
            this.createdCount += sz;
        }
    }

    public void prepopulate(int count) {
        this.steadyPoolSize = count <= 0 ? 0 : count;
        int n = this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        if (this.steadyPoolSize > 0) {
            this.preload(this.steadyPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Cancelled pool timer task " + " at: " + new Date());
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Destroying " + this.list.size() + " beans from the pool...");
            }
            ClassLoader origLoader = Utility.setContextClassLoader(this.containerClassLoader);
            Object[] array = this.list.toArray();
            for (int i = 0; i < array.length; ++i) {
                try {
                    ++this.destroyedCount;
                    try {
                        this.factory.destroy(array[i]);
                    }
                    catch (Throwable th) {
                        _logger.log(Level.FINE, "exception in close", th);
                    }
                    continue;
                }
                catch (Throwable th) {
                    _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Error while destroying", th);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Pool-" + this.poolName + "]: Pool closed....");
            }
            this.list.clear();
            Utility.setContextClassLoader(origLoader);
        }
        this.list = null;
        this.factory = null;
        this.poolTimerTask = null;
        this.containerClassLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int count) {
        ArrayList removeList = new ArrayList();
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            for (int i = 0; i < count && size > 0; ++i) {
                removeList.add(this.list.remove(--size));
                ++this.destroyedCount;
            }
        }
        int sz = removeList.size();
        for (int i = 0; i < sz; ++i) {
            try {
                this.factory.destroy(removeList.get(i));
                continue;
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "exception in remove", th);
            }
        }
    }

    protected void removeIdleObjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doResize() {
        block65: {
            block64: {
                block62: {
                    block60: {
                        currentThread = Thread.currentThread();
                        previousClassLoader = currentThread.getContextClassLoader();
                        ctxClassLoader = this.containerClassLoader;
                        startTime = 0L;
                        enteredResizeBlock = false;
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(ctxClassLoader);
                        } else {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    currentThread.setContextClassLoader(ctxClassLoader);
                                    return null;
                                }
                            });
                        }
                        if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                            NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize started at: " + new Date() + " steadyPoolSize ::" + this.steadyPoolSize + " resizeQuantity ::" + this.resizeQuantity + " maxPoolSize ::" + this.maxPoolSize);
                        }
                        startTime = System.currentTimeMillis();
                        removeList = new ArrayList();
                        populateCount = 0;
                        var9_10 = this.list;
                        synchronized (var9_10) {
                            if (!this.inResizing) ** break block59
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 15] lbl21 : MonitorExitStatement: MONITOREXIT : var9_10
                            if (!enteredResizeBlock) break block60;
                            var10_12 = this.list;
                        }
                        synchronized (var10_12) {
                            this.inResizing = false;
                        }
                    }
                    if (System.getSecurityManager() == null) {
                        currentThread.setContextClassLoader(previousClassLoader);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction(currentThread, previousClassLoader){
                            final /* synthetic */ Thread val$currentThread;
                            final /* synthetic */ ClassLoader val$previousClassLoader;
                            {
                                this.val$currentThread = thread;
                                this.val$previousClassLoader = classLoader;
                            }

                            public Object run() {
                                this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                                return null;
                            }
                        });
                    }
                    return;
                    {
                        enteredResizeBlock = true;
                        this.inResizing = true;
                        curSize = this.list.size();
                        if (curSize <= this.steadyPoolSize) ** GOTO lbl72
                        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) ** break block61
                        // MONITOREXIT @DISABLED, blocks:[3, 15] lbl44 : MonitorExitStatement: MONITOREXIT : var9_10
                        if (!enteredResizeBlock) break block62;
                        var11_15 = this.list;
                    }
                    synchronized (var11_15) {
                        this.inResizing = false;
                    }
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                return;
                {
                    victimCount = curSize > this.steadyPoolSize + this.resizeQuantity ? this.resizeQuantity : curSize - this.steadyPoolSize;
                    allowedIdleTime = System.currentTimeMillis() - (long)(this.idleTimeoutInSeconds * 1000);
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize:: reducing " + " pool size by: " + victimCount);
                    }
                    for (i = 0; i < victimCount && (ctx = (EJBContextImpl)this.list.get(0)).getLastTimeUsed() <= allowedIdleTime; ++i) {
                        removeList.add(this.list.remove(0));
                        ++this.destroyedCount;
                    }
                    ** GOTO lbl101
lbl72:
                    // 1 sources

                    if (curSize >= this.steadyPoolSize) ** GOTO lbl101
                    if (this.maintainSteadySize) ** break block63
                    // MONITOREXIT @DISABLED, blocks:[5, 15] lbl74 : MonitorExitStatement: MONITOREXIT : var9_10
                    if (!enteredResizeBlock) break block64;
                    victimCount = this.list;
                }
                synchronized (victimCount) {
                    this.inResizing = false;
                }
            }
            if (System.getSecurityManager() == null) {
                currentThread.setContextClassLoader(previousClassLoader);
            } else {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            return;
            {
                if (this.resizeQuantity <= 0) {
                    populateCount = this.steadyPoolSize - curSize;
                } else {
                    while (curSize + populateCount < this.steadyPoolSize) {
                        populateCount += this.resizeQuantity;
                    }
                    if (curSize + populateCount > this.maxPoolSize) {
                        populateCount -= curSize + populateCount - this.maxPoolSize;
                    }
                }
lbl101:
                // 6 sources

                // MONITOREXIT @DISABLED, blocks:[7, 8, 15] lbl101 : MonitorExitStatement: MONITOREXIT : var9_10
                {
                    catch (Throwable var17_24) {
                        throw var17_24;
                    }
                }
                if (removeList.size() > 0) {
                    sz = removeList.size();
                    for (i = 0; i < sz; ++i) {
                        try {
                            this.factory.destroy(removeList.get(i));
                            continue;
                        }
                        catch (Throwable th) {
                            NonBlockingPool._logger.log(Level.FINE, "exception in doResize", th);
                        }
                    }
                }
                if (populateCount > 0) {
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Attempting to preload " + populateCount + " beans. CurSize/MaxPoolSize: " + this.list.size() + "/" + this.maxPoolSize);
                    }
                    this.preload(populateCount);
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: After preload " + "CurSize/MaxPoolSize: " + this.list.size() + "/" + this.maxPoolSize);
                    }
                }
                if (!enteredResizeBlock) break block65;
                removeList = this.list;
            }
            synchronized (removeList) {
                this.inResizing = false;
            }
        }
        if (System.getSecurityManager() == null) {
            currentThread.setContextClassLoader(previousClassLoader);
        } else {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        ** GOTO lbl168
        {
            catch (Throwable th) {
                block66: {
                    try {
                        NonBlockingPool._logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Exception during reSize", th);
                        if (!enteredResizeBlock) break block66;
                        th = this.list;
                    }
                    catch (Throwable var20_27) {
                        if (enteredResizeBlock) {
                            var21_28 = this.list;
                            synchronized (var21_28) {
                                this.inResizing = false;
                            }
                        }
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(previousClassLoader);
                        } else {
                            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                        }
                        throw var20_27;
                    }
                    synchronized (th) {
                        this.inResizing = false;
                    }
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
            }
            endTime = System.currentTimeMillis();
            if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize completed at: " + new Date() + "; after reSize: " + this.getAllAttrValues());
                NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize took: " + (double)(endTime - startTime) / 1000.0 + " seconds.");
            }
            return;
        }
    }

    public String getAllAttrValues() {
        StringBuffer sbuf = new StringBuffer("[Pool-" + this.poolName + "] ");
        sbuf.append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("CS=").append(this.list.size()).append("; ").append("SS=").append(this.steadyPoolSize).append("; ").append("MS=").append(this.maxPoolSize).append(";");
        return sbuf.toString();
    }

    private class PoolResizeTimerTask
    extends TimerTask {
        Object lock;

        PoolResizeTimerTask() {
        }

        PoolResizeTimerTask(Object lock) {
            this.lock = lock;
        }

        public void run() {
            try {
                if (NonBlockingPool.this.addedIdleBeanWork) {
                    return;
                }
                IdleBeanWork work = new IdleBeanWork();
                ContainerWorkPool.addLast(work);
                NonBlockingPool.this.addedIdleBeanWork = true;
            }
            catch (Exception ex) {
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Cannot perform " + " pool idle bean cleanup", ex);
            }
        }
    }

    private class IdleBeanWork
    implements Servicable {
        private IdleBeanWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception exception) {
            }
            finally {
                NonBlockingPool.this.addedIdleBeanWork = false;
            }
        }
    }

    private class ReSizeWork
    implements Servicable {
        private ReSizeWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception ex) {
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Exception during reSize", ex);
            }
            finally {
                ArrayList arrayList = NonBlockingPool.this.list;
                synchronized (arrayList) {
                    NonBlockingPool.this.addedResizeTask = false;
                }
            }
        }
    }
}

