/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addon;

import com.sun.enterprise.addon.Addon;
import com.sun.enterprise.addon.Registry;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddonInstaller {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installAllAddons(String installDir, String instanceRoot) {
        String addonJar = "";
        Registry registry = null;
        Object in = null;
        Object out = null;
        try {
            String addonDir = installDir + File.separator + "lib" + File.separator + "addons";
            String domainConfigRoot = instanceRoot + File.separator + "config";
            String domainRegistry = domainConfigRoot + File.separator + "domain-registry";
            File registryFile = new File(domainRegistry);
            registry = new Registry();
            registry.load(registryFile);
            File libAddonDirectory = new File(addonDir);
            File[] fileArray = libAddonDirectory.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                addonJar = fileArray[i].getName();
                String jarExtension = "";
                int dotLastIndex = addonJar.lastIndexOf(".");
                String jarNameWithoutExtension = addonJar;
                if (dotLastIndex != -1) {
                    jarExtension = addonJar.substring(dotLastIndex + 1);
                    jarNameWithoutExtension = addonJar.substring(0, dotLastIndex);
                }
                if (!jarExtension.equalsIgnoreCase("jar")) continue;
                String key = jarNameWithoutExtension + "." + "enabled";
                String installed = registry.getProperty(key);
                if (installed != null && installed.equals("true")) {
                    Logger.getAnonymousLogger().log(Level.FINE, "Addon " + addonJar + " is already installed");
                    continue;
                }
                Addon addon = new Addon(fileArray[i]);
                boolean install = addon.install(installDir, instanceRoot);
                if (!install) continue;
                registry.setProperty(key, "true");
            }
            registry.store();
        }
        catch (Exception ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error while installing the addon " + addonJar, ex);
        }
        finally {
            try {
                if (registry != null) {
                    registry.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void main(String[] args) {
        AddonInstaller installer = new AddonInstaller();
        installer.installAllAddons(args[0], args[1]);
    }
}

