/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common.domains.registry;

import com.sun.enterprise.admin.common.domains.registry.ContactDataSet;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public final class DomainEntry
implements Cloneable,
Serializable {
    private String name;
    private File root;
    private String path;
    private ContactDataSet contactData;

    public DomainEntry(String name, File root, ContactDataSet contactData) throws NullPointerException {
        if (name == null || root == null || contactData == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.root = root;
        try {
            this.path = root.getCanonicalPath();
        }
        catch (IOException ioe) {
            this.path = root.getAbsolutePath();
        }
        this.contactData = contactData;
    }

    public String getName() {
        return this.name;
    }

    public File getRoot() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public ContactDataSet getContactData() {
        return this.contactData;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException c) {
            return null;
        }
    }

    public int hashCode() {
        String s = this.name + this.root.toString();
        return s.hashCode();
    }

    public boolean equals(Object rhs) {
        return rhs != null && rhs instanceof DomainEntry && this.equals((DomainEntry)rhs);
    }

    private boolean equals(DomainEntry rhs) {
        return rhs != null && this == rhs || this.name.equals(rhs.name) && this.root.equals(rhs.root);
    }
}

