/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.util.i18n.StringManager;

public class ModuleDeployEvent
extends BaseDeployEvent {
    public static final String TYPE_WEBMODULE = "web";
    public static final String TYPE_EJBMODULE = "ejb";
    public static final String TYPE_CONNECTOR = "connector";
    public static final String TYPE_APPCLIENT = "appclient";
    public static final int TYPE_WEBMODULE_CODE = 1;
    public static final int TYPE_EJBMODULE_CODE = 2;
    public static final int TYPE_CONNECTOR_CODE = 3;
    public static final int TYPE_APPCLIENT_CODE = 4;
    static final String eventType = ModuleDeployEvent.class.getName();
    private String moduleType;
    private int moduleTypeCode;
    private boolean forceDeploy = false;
    private static StringManager localStrings = StringManager.getManager(ModuleDeployEvent.class);

    public ModuleDeployEvent(String instance, String moduleName, String moduleType, String actionCode) {
        super(eventType, instance, "module", moduleName, actionCode);
        this.setModuleType(moduleType);
    }

    public ModuleDeployEvent(String instance, String moduleName, String moduleType, String actionCode, boolean cascade) {
        super(eventType, instance, "module", moduleName, actionCode, cascade);
        this.setModuleType(moduleType);
    }

    public ModuleDeployEvent(String instance, String moduleName, String moduleType, String actionCode, boolean cascade, boolean forceDeploy) {
        super(eventType, instance, "module", moduleName, actionCode, cascade);
        this.setModuleType(moduleType);
        this.setForceDeploy(forceDeploy);
    }

    public void setForceDeploy(boolean forceDeploy) {
        this.forceDeploy = forceDeploy;
    }

    public boolean getForceDeploy() {
        return this.forceDeploy;
    }

    public String getModuleName() {
        return this.getJ2EEComponentName();
    }

    public String getModuleType() {
        return this.moduleType;
    }

    public int getModuleTypeCode() {
        return this.moduleTypeCode;
    }

    private void setModuleType(String modType) {
        boolean valid = true;
        int modTypeCode = 0;
        if (TYPE_WEBMODULE.equals(modType)) {
            modTypeCode = 1;
        } else if (TYPE_EJBMODULE.equals(modType)) {
            modTypeCode = 2;
        } else if (TYPE_CONNECTOR.equals(modType)) {
            modTypeCode = 3;
        } else if (TYPE_APPCLIENT.equals(modType)) {
            modTypeCode = 4;
        } else {
            valid = false;
        }
        if (!valid) {
            String msg = localStrings.getString("admin.event.invalid_module_type", modType);
            throw new IllegalArgumentException(msg);
        }
        this.moduleType = modType;
        this.moduleTypeCode = modTypeCode;
    }

    public String toString() {
        return "ModuleDeployEvent -- " + this.getAction() + " " + this.moduleType + "/" + this.getModuleName();
    }
}

