/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.appserv.management.event.StatisticMonitorNotification;
import com.sun.enterprise.admin.selfmanagement.event.CounterStatisticMonitorMBean;
import com.sun.enterprise.admin.selfmanagement.event.StatisticMonitor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterStatisticMonitor
extends StatisticMonitor
implements CounterStatisticMonitorMBean {
    private Number[] threshold = new Number[16];
    private Number modulus = INTEGER_ZERO;
    private Number offset = INTEGER_ZERO;
    private boolean notify = false;
    private boolean differenceMode = false;
    private Number initThreshold = INTEGER_ZERO;
    private Number[] previousScanCounter = new Number[16];
    private boolean[] modulusExceeded = new boolean[16];
    private Number[] derivedGaugeExceeded = new Number[16];
    private boolean[] derivedGaugeValid = new boolean[16];
    private boolean[] eventAlreadyNotified = new boolean[16];
    private StatisticMonitor.NumericalType[] type = new StatisticMonitor.NumericalType[16];
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "com.sun.appserv.management.event.StatisticMonitorNotification", "Notifications sent by the CounterStatisticMonitor MBean")};
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Reset the threshold values");
        }
        CounterStatisticMonitor counterStatisticMonitor = this;
        synchronized (counterStatisticMonitor) {
            for (int i = 0; i < this.elementCount; ++i) {
                this.threshold[i] = this.initThreshold;
            }
        }
    }

    @Override
    public synchronized void start() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.threshold[i] = this.initThreshold;
            this.modulusExceeded[i] = false;
            this.eventAlreadyNotified[i] = false;
            this.previousScanCounter[i] = null;
        }
        this.doStart();
    }

    @Override
    public synchronized void stop() {
        this.doStop();
    }

    @Override
    public synchronized Number getDerivedGauge(ObjectName object) {
        return (Number)super.getDerivedGauge(object);
    }

    @Override
    public synchronized long getDerivedGaugeTimeStamp(ObjectName object) {
        return super.getDerivedGaugeTimeStamp(object);
    }

    @Override
    public synchronized Number getThreshold(ObjectName object) {
        int index = this.indexOf(object);
        if (index != -1) {
            return this.threshold[index];
        }
        return null;
    }

    @Override
    public synchronized Number getInitThreshold() {
        return this.initThreshold;
    }

    @Override
    public synchronized void setInitThreshold(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null threshold");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative threshold");
        }
        this.initThreshold = value;
        for (int i = 0; i < this.elementCount; ++i) {
            this.resetAlreadyNotified(i, 16);
            this.threshold[i] = value;
            this.modulusExceeded[i] = false;
            this.eventAlreadyNotified[i] = false;
        }
    }

    @Override
    @Deprecated
    public synchronized Number getDerivedGauge() {
        return (Number)this.derivedGauge[0];
    }

    @Override
    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    @Override
    @Deprecated
    public synchronized Number getThreshold() {
        return this.threshold[0];
    }

    @Override
    @Deprecated
    public synchronized void setThreshold(Number value) throws IllegalArgumentException {
        this.setInitThreshold(value);
    }

    @Override
    public synchronized Number getOffset() {
        return this.offset;
    }

    @Override
    public synchronized void setOffset(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null offset");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative offset");
        }
        this.offset = value;
        for (int i = 0; i < this.elementCount; ++i) {
            this.resetAlreadyNotified(i, 16);
        }
    }

    @Override
    public synchronized Number getModulus() {
        return this.modulus;
    }

    @Override
    public synchronized void setModulus(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null modulus");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative modulus");
        }
        this.modulus = value;
        for (int i = 0; i < this.elementCount; ++i) {
            this.resetAlreadyNotified(i, 16);
            this.modulusExceeded[i] = false;
        }
    }

    @Override
    public synchronized boolean getNotify() {
        return this.notify;
    }

    @Override
    public synchronized void setNotify(boolean value) {
        this.notify = value;
    }

    @Override
    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    @Override
    public synchronized void setDifferenceMode(boolean value) {
        this.differenceMode = value;
        for (int i = 0; i < this.elementCount; ++i) {
            this.threshold[i] = this.initThreshold;
            this.modulusExceeded[i] = false;
            this.eventAlreadyNotified[i] = false;
            this.previousScanCounter[i] = null;
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return (MBeanNotificationInfo[])notifsInfo.clone();
    }

    private synchronized boolean updateDerivedGauge(Object scanCounter, int index) {
        boolean is_derived_gauge_valid;
        if (this.differenceMode) {
            if (this.previousScanCounter[index] != null) {
                this.setDerivedGaugeWithDifference((Number)scanCounter, null, index);
                if (((Number)this.derivedGauge[index]).longValue() < 0L) {
                    if (this.modulus.longValue() > 0L) {
                        this.setDerivedGaugeWithDifference((Number)scanCounter, this.modulus, index);
                    }
                    this.threshold[index] = this.initThreshold;
                    this.eventAlreadyNotified[index] = false;
                }
                is_derived_gauge_valid = true;
            } else {
                is_derived_gauge_valid = false;
            }
            this.previousScanCounter[index] = (Number)scanCounter;
        } else {
            this.derivedGauge[index] = (Number)scanCounter;
            is_derived_gauge_valid = true;
        }
        return is_derived_gauge_valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatisticMonitorNotification updateNotifications(int index) {
        StatisticMonitorNotification n = null;
        CounterStatisticMonitor counterStatisticMonitor = this;
        synchronized (counterStatisticMonitor) {
            if (!this.eventAlreadyNotified[index]) {
                if (((Number)this.derivedGauge[index]).longValue() >= this.threshold[index].longValue()) {
                    if (this.notify) {
                        n = new StatisticMonitorNotification("jmx.monitor.counter.threshold", this, 0L, 0L, "", null, null, null, this.threshold[index]);
                    }
                    if (!this.differenceMode) {
                        this.eventAlreadyNotified[index] = true;
                    }
                }
            } else if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "The notification:\n\tNotification observed object = " + this.getObservedObject(index) + "\n\tNotification observed attribute = " + this.getObservedAttribute() + "\n\tNotification threshold level = " + this.threshold[index] + "\n\tNotification derived gauge = " + this.derivedGauge[index] + "\nhas already been sent");
            }
        }
        return n;
    }

    private synchronized void updateThreshold(int index) {
        if (((Number)this.derivedGauge[index]).longValue() >= this.threshold[index].longValue()) {
            if (this.offset.longValue() > 0L) {
                long threshold_value;
                for (threshold_value = this.threshold[index].longValue(); ((Number)this.derivedGauge[index]).longValue() >= threshold_value; threshold_value += this.offset.longValue()) {
                }
                switch (this.type[index]) {
                    case INTEGER: {
                        this.threshold[index] = new Integer((int)threshold_value);
                        break;
                    }
                    case BYTE: {
                        this.threshold[index] = new Byte((byte)threshold_value);
                        break;
                    }
                    case SHORT: {
                        this.threshold[index] = new Short((short)threshold_value);
                        break;
                    }
                    case LONG: {
                        this.threshold[index] = new Long(threshold_value);
                        break;
                    }
                    default: {
                        if (!_logger.isLoggable(Level.WARNING)) break;
                        _logger.log(Level.WARNING, "Threshold Type is Invalid");
                    }
                }
                if (!this.differenceMode && this.modulus.longValue() > 0L && this.threshold[index].longValue() > this.modulus.longValue()) {
                    this.modulusExceeded[index] = true;
                    this.derivedGaugeExceeded[index] = (Number)this.derivedGauge[index];
                }
                this.eventAlreadyNotified[index] = false;
            } else {
                this.modulusExceeded[index] = true;
                this.derivedGaugeExceeded[index] = (Number)this.derivedGauge[index];
            }
        }
    }

    private synchronized void setDerivedGaugeWithDifference(Number scanCounter, Number mod, int index) {
        long derived = scanCounter.longValue() - this.previousScanCounter[index].longValue();
        if (mod != null) {
            derived += this.modulus.longValue();
        }
        switch (this.type[index]) {
            case INTEGER: {
                this.derivedGauge[index] = new Integer((int)derived);
                break;
            }
            case BYTE: {
                this.derivedGauge[index] = new Byte((byte)derived);
                break;
            }
            case SHORT: {
                this.derivedGauge[index] = new Short((short)derived);
                break;
            }
            case LONG: {
                this.derivedGauge[index] = new Long(derived);
                break;
            }
            default: {
                if (!_logger.isLoggable(Level.WARNING)) break;
                _logger.log(Level.WARNING, "Threshold Type is Invalid");
            }
        }
    }

    @Override
    boolean isComparableTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        int index = this.indexOf(object);
        if (value instanceof Integer) {
            this.type[index] = StatisticMonitor.NumericalType.INTEGER;
        } else if (value instanceof Byte) {
            this.type[index] = StatisticMonitor.NumericalType.BYTE;
        } else if (value instanceof Short) {
            this.type[index] = StatisticMonitor.NumericalType.SHORT;
        } else if (value instanceof Long) {
            this.type[index] = StatisticMonitor.NumericalType.LONG;
        } else {
            return false;
        }
        return true;
    }

    @Override
    Comparable<?> getDerivedGaugeFromComparable(ObjectName object, String attribute, Comparable<?> value) {
        int index = this.indexOf(object);
        if (this.modulusExceeded[index] && ((Number)this.derivedGauge[index]).longValue() < this.derivedGaugeExceeded[index].longValue()) {
            this.threshold[index] = this.initThreshold;
            this.modulusExceeded[index] = false;
            this.eventAlreadyNotified[index] = false;
        }
        this.derivedGaugeValid[index] = this.updateDerivedGauge(value, index);
        return (Comparable)this.derivedGauge[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onErrorNotification(StatisticMonitorNotification notification) {
        int index = this.indexOf(notification.getObservedObject());
        CounterStatisticMonitor counterStatisticMonitor = this;
        synchronized (counterStatisticMonitor) {
            this.modulusExceeded[index] = false;
            this.eventAlreadyNotified[index] = false;
            this.previousScanCounter[index] = null;
        }
    }

    @Override
    StatisticMonitorNotification buildAlarmNotification(ObjectName object, String attribute, Comparable<?> value) {
        int index = this.indexOf(object);
        StatisticMonitorNotification alarm = null;
        if (this.derivedGaugeValid[index]) {
            alarm = this.updateNotifications(index);
            this.updateThreshold(index);
        }
        return alarm;
    }

    @Override
    synchronized boolean isThresholdTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        int index = this.indexOf(object);
        Class<? extends Number> c = CounterStatisticMonitor.classForType(this.type[index]);
        return c.isInstance(this.threshold[index]) && CounterStatisticMonitor.isValidForType(this.offset, c) && CounterStatisticMonitor.isValidForType(this.modulus, c);
    }

    @Override
    synchronized void insertSpecificElementAt(int index) {
        if (this.elementCount >= this.threshold.length) {
            this.threshold = this.expandArray(this.threshold);
            this.previousScanCounter = this.expandArray(this.previousScanCounter);
            this.derivedGaugeExceeded = this.expandArray(this.derivedGaugeExceeded);
            this.derivedGaugeValid = this.expandArray(this.derivedGaugeValid);
            this.modulusExceeded = this.expandArray(this.modulusExceeded);
            this.eventAlreadyNotified = this.expandArray(this.eventAlreadyNotified);
            this.type = this.expandArray(this.type);
        }
        this.threshold[index] = INTEGER_ZERO;
        this.previousScanCounter[index] = null;
        this.derivedGaugeExceeded[index] = null;
        this.derivedGaugeValid[index] = false;
        this.modulusExceeded[index] = false;
        this.eventAlreadyNotified[index] = false;
        this.type[index] = StatisticMonitor.NumericalType.INTEGER;
    }

    @Override
    synchronized void removeSpecificElementAt(int index) {
        this.removeElementAt(this.threshold, index);
        this.removeElementAt(this.previousScanCounter, index);
        this.removeElementAt(this.derivedGaugeExceeded, index);
        this.removeElementAt(this.derivedGaugeValid, index);
        this.removeElementAt(this.modulusExceeded, index);
        this.removeElementAt(this.eventAlreadyNotified, index);
        this.removeElementAt((Object[])this.type, index);
    }
}

