/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.selfmanagement.event.CallflowEventListener;
import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.EventAbstractFactory;
import com.sun.enterprise.admin.selfmanagement.event.EventBuilder;
import com.sun.enterprise.admin.selfmanagement.event.TraceEvent;
import com.sun.enterprise.admin.selfmanagement.event.TraceEventImpl;
import com.sun.enterprise.admin.selfmanagement.event.TraceEventNotificationFilter;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ReflectionException;

public final class TraceEventFactory
extends EventAbstractFactory {
    private boolean notificationsEnabled = false;
    private static final TraceEventFactory instance = new TraceEventFactory();

    private TraceEventFactory() {
        EventBuilder.getInstance().addEventFactory("trace", this);
        try {
            TraceEventImpl impl = (TraceEventImpl)this.getMBeanServer().instantiate("com.sun.enterprise.admin.selfmanagement.event.TraceEventImpl");
            this.getMBeanServer().registerMBean(impl, TraceEvent.getTraceImplObjectName());
        }
        catch (ReflectionException rex) {
            _logger.log(Level.WARNING, "smgt.internal_error", rex);
        }
        catch (InstanceAlreadyExistsException iex) {
            _logger.log(Level.WARNING, "smgt.internal_error", iex);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "smgt.internal_error", ex);
        }
    }

    private synchronized void enableNotifications(boolean enable) {
        if (!this.notificationsEnabled) {
            CallflowEventListener.register();
            this.notificationsEnabled = true;
        } else if (!enable) {
            CallflowEventListener.unregister();
        }
    }

    public Event instrumentEvent(ElementProperty[] properties, String description) {
        this.enableNotifications(true);
        String eventName = "*";
        String ipAddress = "*";
        String callerPrincipal = "*";
        String componentName = "*";
        for (int i = 0; i < properties.length; ++i) {
            ElementProperty property = properties[i];
            String propertyName = property.getName().toLowerCase();
            if (propertyName.equals("name") && !TraceEvent.isValidType(eventName = "trace." + property.getValue().toLowerCase())) {
                throw new IllegalArgumentException(sm.getString("name", "selfmgmt_event.invalid_event_property", "trace"));
            }
            if (propertyName.equals("ipaddress")) {
                ipAddress = property.getValue().toLowerCase();
            }
            if (propertyName.equals("callerprincipal")) {
                callerPrincipal = property.getValue().toLowerCase();
            }
            if (!propertyName.equals("componentname")) continue;
            componentName = property.getValue().toLowerCase();
        }
        return new TraceEvent(eventName, new TraceEventNotificationFilter(eventName, ipAddress, callerPrincipal, componentName), description);
    }

    static TraceEventFactory getInstance() {
        return instance;
    }
}

