/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.meta.AdminConfigEventListener;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.server.core.ConfigInterceptor;
import com.sun.enterprise.admin.util.proxy.Interceptor;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.config.ConfigContextFactory;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.pluggable.ConfigEnvironment;
import com.sun.enterprise.config.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.server.ServerContextImpl;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class AdminContextImpl
implements AdminContext {
    private ServerContextImpl serverContext;
    private ConfigContext runtimeConfigContext;
    private ConfigContext adminConfigContext;
    private MBeanServer mbeanServer;
    private String domainName;
    private String serverName;
    private Logger adminLogger;
    private Interceptor configInterceptor;
    private URL adminMBeanRegistryURL;
    private URL runtimeMBeanRegistryURL;
    private static final String ADMIN_DESCRIPTORS_FILENAME = "/admin-mbeans-descriptors.xml";
    private static final String RUNTIME_DESCRIPTORS_FILENAME = "/runtime-mbeans-descriptors.xml";

    public AdminContextImpl() {
        String loggerName = System.getProperty("com.sun.aas.admin.logger.name");
        this.adminLogger = loggerName != null ? Logger.getLogger(loggerName) : Logger.getAnonymousLogger();
        this.domainName = "com.sun.appserv";
        MBeanRegistryFactory.setAdminContext(this);
    }

    public AdminContextImpl(ServerContextImpl srvCtx) {
        this();
        this.setServerContext(srvCtx);
    }

    public void setServerContext(ServerContextImpl srvCtx) {
        this.serverContext = srvCtx;
        this.runtimeConfigContext = this.serverContext.getConfigContext();
        String configFileName = this.serverContext.getServerConfigURL();
        try {
            this.adminConfigContext = ConfigContextFactory.createConfigContext(this.getAdminConfigEnvironment(configFileName));
            this.setServerName(srvCtx.getInstanceName());
            if (ServerHelper.isDAS(srvCtx.getConfigContext(), srvCtx.getInstanceName())) {
                this.registerValidator();
                this.registerConfigAdjustmentListener();
            }
        }
        catch (ConfigException ce) {
            this.adminLogger.log(Level.SEVERE, "core.determining_server_instance_failed", ce);
        }
        catch (RuntimeException ce) {
            this.adminLogger.log(Level.SEVERE, "core.admin_config_read_error", ce.getMessage());
            this.adminLogger.log(Level.WARNING, "core.admin_config_read_error_trace", ce);
            throw ce;
        }
        this.adminLogger.log(Level.FINEST, "core.log_config_id_runtime", new Long(this.runtimeConfigContext.hashCode()));
        this.adminLogger.log(Level.FINEST, "core.log_config_is_admin", new Long(this.adminConfigContext.hashCode()));
        this.serverName = this.serverContext.getInstanceName();
    }

    protected void registerConfigAdjustmentListener() {
        this.adminConfigContext.addConfigContextEventListener(new AdminConfigEventListener());
    }

    protected void registerValidator() {
        try {
            Class<?> cl = Class.forName("com.sun.enterprise.config.serverbeans.validation.DomainMgr");
            this.adminConfigContext.addConfigContextEventListener((ConfigContextEventListener)cl.newInstance());
        }
        catch (Exception ex) {
            this.adminLogger.log(Level.WARNING, "core.admin_validator_not_registered", "Error registering validator, config validator will not be available");
            this.adminLogger.log(Level.FINE, "core.admin_validator_register_error", ex.getMessage());
        }
    }

    public ConfigContext getAdminConfigContext() {
        return this.adminConfigContext;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public ConfigContext getRuntimeConfigContext() {
        return this.runtimeConfigContext;
    }

    public String getServerName() {
        return this.serverName;
    }

    public URL getAdminMBeanRegistryURL() {
        if (this.adminMBeanRegistryURL == null) {
            try {
                this.adminMBeanRegistryURL = MBeanRegistry.class.getResource(ADMIN_DESCRIPTORS_FILENAME);
            }
            catch (Throwable t) {
                this.adminLogger.log(Level.WARNING, "core.adminconfig_adminregistry_not_found", ADMIN_DESCRIPTORS_FILENAME);
            }
        }
        return this.adminMBeanRegistryURL;
    }

    public URL getRuntimeMBeanRegistryURL() {
        if (this.runtimeMBeanRegistryURL == null) {
            try {
                this.runtimeMBeanRegistryURL = MBeanRegistry.class.getResource(RUNTIME_DESCRIPTORS_FILENAME);
            }
            catch (Throwable t) {
                this.adminLogger.log(Level.WARNING, "core.adminconfig_runtimeregistry_not_found", RUNTIME_DESCRIPTORS_FILENAME);
            }
        }
        return this.runtimeMBeanRegistryURL;
    }

    public void setAdminConfigContext(ConfigContext ctx) {
    }

    public void setDomainName(String name) {
    }

    public void setMBeanServer(MBeanServer mbs) {
        this.mbeanServer = mbs;
    }

    public void setRuntimeConfigContext(ConfigContext ctx) {
        if (this.serverContext != null) {
            this.serverContext.setConfigContext(ctx);
        }
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setAdminMBeanRegistryURL(URL url) {
        this.adminMBeanRegistryURL = url;
    }

    public void setRuntimeMBeanRegistryURL(URL url) {
        this.runtimeMBeanRegistryURL = url;
    }

    public Logger getAdminLogger() {
        return this.adminLogger;
    }

    public void setAdminLogger(Logger logger) {
        this.adminLogger = logger;
    }

    public Interceptor getMBeanServerInterceptor() {
        if (this.configInterceptor == null) {
            this.configInterceptor = new ConfigInterceptor(this);
        }
        return this.configInterceptor;
    }

    public void setMBeanServerInterceptor(Interceptor interceptor) {
    }

    private ConfigEnvironment getAdminConfigEnvironment(String configFileName) {
        ConfigEnvironment ce = EnvironmentFactory.getEnvironmentFactory().getConfigEnvironment();
        ce.setUrl(configFileName);
        ce.setReadOnly(false);
        ce.setCachingEnabled(false);
        ce.setRootClass("com.sun.enterprise.config.serverbeans.Domain");
        ce.setHandler("com.sun.enterprise.config.serverbeans.ServerValidationHandler");
        ce.getConfigBeanInterceptor().setResolvingPaths(false);
        return ce;
    }

    public String getDottedNameMBeanImplClassName() {
        return "com.sun.enterprise.admin.mbeans.DottedNameGetSetMBeanImpl";
    }
}

