/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class JavaConfig
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String PROFILER = "Profiler";
    public static final String JVM_OPTIONS = "JvmOptions";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public JavaConfig() {
        this(1);
    }

    public JavaConfig(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(3);
        this.createProperty("profiler", PROFILER, 66064, Profiler.class);
        this.createAttribute(PROFILER, "name", "Name", 257, null, null);
        this.createAttribute(PROFILER, "classpath", "Classpath", 513, null, null);
        this.createAttribute(PROFILER, "native-library-path", "NativeLibraryPath", 513, null, null);
        this.createAttribute(PROFILER, "enabled", "Enabled", 1, null, "true");
        this.createProperty("jvm-options", JVM_OPTIONS, 65842, String.class);
        this.createProperty("property", ELEMENT_PROPERTY, 66098, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setProfiler(Profiler value) {
        this.setValue(PROFILER, value);
    }

    public Profiler getProfiler() {
        return (Profiler)this.getValue(PROFILER);
    }

    public void setJvmOptions(String[] value) {
        this.setValue(JVM_OPTIONS, value);
    }

    public String[] getJvmOptions() {
        return (String[])this.getValues(JVM_OPTIONS);
    }

    public int sizeJvmOptions() {
        return this.size(JVM_OPTIONS);
    }

    public int addJvmOptions(String value) throws ConfigException {
        return this.addJvmOptions(value, true);
    }

    public int addJvmOptions(String value, boolean overwrite) throws ConfigException {
        return this.addValue(JVM_OPTIONS, value, overwrite);
    }

    public int removeJvmOptions(String value) {
        return this.removeValue(JVM_OPTIONS, value);
    }

    public int removeJvmOptions(String value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(JVM_OPTIONS, value, overwrite);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(JavaConfig.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getJavaHome() {
        return this.getAttributeValue("java-home");
    }

    public void setJavaHome(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("java-home", v, overwrite);
    }

    public void setJavaHome(String v) {
        this.setAttributeValue("java-home", v);
    }

    public static String getDefaultJavaHome() {
        return "${com.sun.aas.javaRoot}".trim();
    }

    public boolean isDebugEnabled() {
        return JavaConfig.toBoolean(this.getAttributeValue("debug-enabled"));
    }

    public void setDebugEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("debug-enabled", "" + v, overwrite);
    }

    public void setDebugEnabled(boolean v) {
        this.setAttributeValue("debug-enabled", "" + v);
    }

    public static String getDefaultDebugEnabled() {
        return "false".trim();
    }

    public String getDebugOptions() {
        return this.getAttributeValue("debug-options");
    }

    public void setDebugOptions(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("debug-options", v, overwrite);
    }

    public void setDebugOptions(String v) {
        this.setAttributeValue("debug-options", v);
    }

    public static String getDefaultDebugOptions() {
        return "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n".trim();
    }

    public String getRmicOptions() {
        return this.getAttributeValue("rmic-options");
    }

    public void setRmicOptions(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("rmic-options", v, overwrite);
    }

    public void setRmicOptions(String v) {
        this.setAttributeValue("rmic-options", v);
    }

    public static String getDefaultRmicOptions() {
        return "-iiop -poa -alwaysgenerate -keepgenerated -g".trim();
    }

    public String getJavacOptions() {
        return this.getAttributeValue("javac-options");
    }

    public void setJavacOptions(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("javac-options", v, overwrite);
    }

    public void setJavacOptions(String v) {
        this.setAttributeValue("javac-options", v);
    }

    public static String getDefaultJavacOptions() {
        return "-g".trim();
    }

    public String getClasspathPrefix() {
        return this.getAttributeValue("classpath-prefix");
    }

    public void setClasspathPrefix(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("classpath-prefix", v, overwrite);
    }

    public void setClasspathPrefix(String v) {
        this.setAttributeValue("classpath-prefix", v);
    }

    public String getClasspathSuffix() {
        return this.getAttributeValue("classpath-suffix");
    }

    public void setClasspathSuffix(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("classpath-suffix", v, overwrite);
    }

    public void setClasspathSuffix(String v) {
        this.setAttributeValue("classpath-suffix", v);
    }

    public String getServerClasspath() {
        return this.getAttributeValue("server-classpath");
    }

    public void setServerClasspath(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("server-classpath", v, overwrite);
    }

    public void setServerClasspath(String v) {
        this.setAttributeValue("server-classpath", v);
    }

    public String getSystemClasspath() {
        return this.getAttributeValue("system-classpath");
    }

    public void setSystemClasspath(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("system-classpath", v, overwrite);
    }

    public void setSystemClasspath(String v) {
        this.setAttributeValue("system-classpath", v);
    }

    public String getNativeLibraryPathPrefix() {
        return this.getAttributeValue("native-library-path-prefix");
    }

    public void setNativeLibraryPathPrefix(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("native-library-path-prefix", v, overwrite);
    }

    public void setNativeLibraryPathPrefix(String v) {
        this.setAttributeValue("native-library-path-prefix", v);
    }

    public String getNativeLibraryPathSuffix() {
        return this.getAttributeValue("native-library-path-suffix");
    }

    public void setNativeLibraryPathSuffix(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("native-library-path-suffix", v, overwrite);
    }

    public void setNativeLibraryPathSuffix(String v) {
        this.setAttributeValue("native-library-path-suffix", v);
    }

    public String getBytecodePreprocessors() {
        return this.getAttributeValue("bytecode-preprocessors");
    }

    public void setBytecodePreprocessors(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("bytecode-preprocessors", v, overwrite);
    }

    public void setBytecodePreprocessors(String v) {
        this.setAttributeValue("bytecode-preprocessors", v);
    }

    public boolean isEnvClasspathIgnored() {
        return JavaConfig.toBoolean(this.getAttributeValue("env-classpath-ignored"));
    }

    public void setEnvClasspathIgnored(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("env-classpath-ignored", "" + v, overwrite);
    }

    public void setEnvClasspathIgnored(boolean v) {
        this.setAttributeValue("env-classpath-ignored", "" + v);
    }

    public static String getDefaultEnvClasspathIgnored() {
        return "true".trim();
    }

    public Profiler newProfiler() {
        return new Profiler();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "java-config";
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals("java-home")) {
            return "${com.sun.aas.javaRoot}".trim();
        }
        if (attr.equals("debug-enabled")) {
            return "false".trim();
        }
        if (attr.equals("debug-options")) {
            return "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n".trim();
        }
        if (attr.equals("rmic-options")) {
            return "-iiop -poa -alwaysgenerate -keepgenerated -g".trim();
        }
        if (attr.equals("javac-options")) {
            return "-g".trim();
        }
        if (attr.equals("env-classpath-ignored")) {
            return "true".trim();
        }
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        int i;
        str.append(indent);
        str.append(PROFILER);
        ConfigBean n = this.getProfiler();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(PROFILER, 0, str, indent);
        str.append(indent);
        str.append("JvmOptions[" + this.sizeJvmOptions() + "]");
        for (i = 0; i < this.sizeJvmOptions(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            str.append(indent + "\t");
            str.append("<");
            Object o = this.getValue(JVM_OPTIONS, i);
            str.append(o == null ? "null" : o.toString().trim());
            str.append(">\n");
            this.dumpAttributes(JVM_OPTIONS, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("JavaConfig\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

