/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.DiagnosticService;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.DomainXMLHelper;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class ServiceConfigHelper {
    private Element configElement;
    private Element diagnosticElement;
    private DomainXMLHelper xmlHelper;
    private boolean local;
    private String configName;
    private String repositoryDir;
    private String instanceName;
    private static String envInstanceRootVar = "${com.sun.aas.instanceRoot}";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public ServiceConfigHelper(String instanceName) {
        this.instanceName = instanceName;
    }

    public ServiceConfigHelper(String repositoryDir, String instanceName, boolean local) {
        this.repositoryDir = repositoryDir;
        this.instanceName = instanceName;
        this.local = local;
    }

    public String getAttribute(String attribute) throws DiagnosticException {
        if (this.local) {
            if (this.diagnosticElement == null) {
                this.initializeXMLElements();
            }
            return this.getDOMAttribute(attribute);
        }
        return this.getRuntimeAttribute(attribute);
    }

    public String getConfigName() {
        return this.configName;
    }

    public String instanceName() {
        return this.instanceName;
    }

    private void initializeXMLElements() throws DiagnosticException {
        try {
            this.xmlHelper = new DomainXMLHelper(this.repositoryDir);
            Element element = this.xmlHelper.getElement("server", this.instanceName);
            this.configName = this.xmlHelper.getAttribute(element, "config-ref");
            this.configElement = this.xmlHelper.getElement("config", this.configName);
            this.diagnosticElement = this.xmlHelper.getElement(this.configElement, "diagnostic-service");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DiagnosticException(e.getMessage());
        }
    }

    private String getRuntimeAttribute(String attribute) throws DiagnosticException {
        try {
            logger.log(Level.FINE, "Instance Name :" + this.instanceName);
            ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Server server = ServerHelper.getServerByName(configContext, this.instanceName);
            this.configName = server.getConfigRef();
            Config config = ConfigAPIHelper.getConfigByName(configContext, this.configName);
            if (attribute.equals("file")) {
                LogService logService = config.getLogService();
                return this.determineLogFile(logService.getFile());
            }
            DiagnosticService diagService = config.getDiagnosticService();
            return diagService.getAttributeValue(attribute);
        }
        catch (ConfigException ce) {
            logger.log(Level.SEVERE, "diagnostic-service.error_retrieving_logFileName", ce.getMessage());
            throw new DiagnosticException(ce.getMessage());
        }
    }

    private String getDOMAttribute(String attribute) throws DiagnosticException {
        if (attribute.equals("file")) {
            Element logElement = this.xmlHelper.getElement(this.configElement, "log-service");
            return this.determineLogFile(logElement.getAttribute("file"));
        }
        logger.log(Level.FINEST, "diagnostic-service.attribute_name", new Object[]{attribute});
        logger.log(Level.FINEST, "diagnostic-service.attribute_value", new Object[]{this.diagnosticElement.getAttribute(attribute)});
        return this.diagnosticElement.getAttribute(attribute);
    }

    private String determineLogFile(String logFileName) {
        int length;
        if (logFileName.startsWith(envInstanceRootVar) && (length = envInstanceRootVar.length()) > 0) {
            String logFileSuffix = logFileName.substring(length);
            logFileName = this.repositoryDir != null ? this.repositoryDir + logFileSuffix : logFileSuffix;
        }
        return logFileName;
    }
}

