/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.collect.ProcessExecutorException;
import com.sun.enterprise.diagnostics.collect.ProcessRunner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessExecutor {
    static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private String[] command;
    private long timeout;
    private ProcessRunner runner = null;

    public ProcessExecutor(String[] cmd, long timeout) {
        if (cmd == null || cmd.length == 0) {
            throw new IllegalArgumentException("process.null_or_empty_command");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("process.invalid_timeout_value " + new Long(timeout));
        }
        this.command = cmd;
        this.timeout = timeout;
    }

    public String getCommandString() {
        String cmdString = null;
        if (this.runner != null) {
            cmdString = this.runner.getCommandString();
        }
        if (cmdString == null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.command.length; ++i) {
                buf.append(this.command[i] + " ");
            }
            cmdString = buf.toString();
        }
        return cmdString;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("process.invalid_timeout_value " + new Long(timeout));
        }
        this.timeout = timeout;
    }

    public String execute() throws ProcessExecutorException {
        if (this.runner != null) {
            throw new IllegalStateException("process.already_executed");
        }
        this.runner = new ProcessRunner(this.command, this.timeout);
        Thread runnerThread = new Thread(this.runner);
        runnerThread.start();
        try {
            runnerThread.join(this.timeout);
        }
        catch (InterruptedException ie) {
            logger.log(Level.FINEST, "process.waiter_interrupted", this.getCommandString());
        }
        if (runnerThread.isAlive() && !this.runner.completed) {
            logger.log(Level.FINEST, "process.interrupting", new Object[]{new Long(this.timeout), this.getCommandString()});
            runnerThread.interrupt();
            try {
                runnerThread.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.runner.completed && !this.runner.interrupted) {
                this.runner.interrupted = true;
            }
        }
        if (this.runner.interrupted || this.runner.exception != null) {
            if (this.runner.exception == null) {
                this.runner.makeTimeoutException();
            }
            throw this.runner.exception;
        }
        return this.runner.stdout.toString();
    }

    public boolean isCompleted() {
        boolean completed = false;
        if (this.runner != null) {
            completed = this.runner.completed;
        }
        return completed;
    }

    public boolean isInterrupted() {
        boolean interrupted = false;
        if (this.runner != null) {
            interrupted = this.runner.interrupted;
        }
        return interrupted;
    }

    public String getStdout() {
        String stdout = null;
        if (this.runner != null) {
            stdout = this.runner.stdout.toString();
        }
        return stdout;
    }

    public String getStderr() {
        String stderr = null;
        if (this.runner != null) {
            stderr = this.runner.stderr.toString();
        }
        return stderr;
    }

    public int getExitCode() {
        int exitCode = 0;
        if (this.runner == null || !this.runner.completed) {
            throw new IllegalStateException("process.not_yet_executed");
        }
        exitCode = this.runner.exitCode;
        return exitCode;
    }

    public String executeAgain() throws ProcessExecutorException {
        this.runner = null;
        return this.execute();
    }
}

