/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.report.html;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Escape {
    public static final int UNDEFINED = -1;
    private static Escape instance = null;
    private boolean useHex = false;
    private final Map<Character, String> alwaysReplace = new HashMap<Character, String>();
    private final Map<String, Character> entityToChar;
    private final Map<Character, String> charToEntity;
    private String preserve;

    protected Escape() {
        this.alwaysReplace.put(new Character('&'), "amp");
        this.alwaysReplace.put(new Character('<'), "lt");
        this.alwaysReplace.put(new Character('>'), "gt");
        this.alwaysReplace.put(new Character('\"'), "quot");
        this.alwaysReplace.put(new Character('\''), "#039");
        this.alwaysReplace.put(new Character('\u00a0'), "nbsp");
        this.entityToChar = new HashMap<String, Character>();
        this.charToEntity = new HashMap<Character, String>();
        this.setEntity("nbsp", '\u00a0');
        this.setEntity("iexcl", '\u00a1');
        this.setEntity("cent", '\u00a2');
        this.setEntity("pound", '\u00a3');
        this.setEntity("curren", '\u00a4');
        this.setEntity("yen", '\u00a5');
        this.setEntity("brvbar", '\u00a6');
        this.setEntity("sect", '\u00a7');
        this.setEntity("uml", '\u00a8');
        this.setEntity("copy", '\u00a9');
        this.setEntity("ordf", '\u00aa');
        this.setEntity("laquo", '\u00ab');
        this.setEntity("not", '\u00ac');
        this.setEntity("shy", '\u00ad');
        this.setEntity("reg", '\u00ae');
        this.setEntity("macr", '\u00af');
        this.setEntity("deg", '\u00b0');
        this.setEntity("plusmn", '\u00b1');
        this.setEntity("sup2", '\u00b2');
        this.setEntity("sup3", '\u00b3');
        this.setEntity("acute", '\u00b4');
        this.setEntity("micro", '\u00b5');
        this.setEntity("para", '\u00b6');
        this.setEntity("middot", '\u00b7');
        this.setEntity("cedil", '\u00b8');
        this.setEntity("sup1", '\u00b9');
        this.setEntity("ordm", '\u00ba');
        this.setEntity("raquo", '\u00bb');
        this.setEntity("frac14", '\u00bc');
        this.setEntity("frac12", '\u00bd');
        this.setEntity("frac34", '\u00be');
        this.setEntity("iquest", '\u00bf');
        this.setEntity("Agrave", '\u00c0');
        this.setEntity("Aacute", '\u00c1');
        this.setEntity("Acirc", '\u00c2');
        this.setEntity("Atilde", '\u00c3');
        this.setEntity("Auml", '\u00c4');
        this.setEntity("Aring", '\u00c5');
        this.setEntity("AElig", '\u00c6');
        this.setEntity("Ccedil", '\u00c7');
        this.setEntity("Egrave", '\u00c8');
        this.setEntity("Eacute", '\u00c9');
        this.setEntity("Ecirc", '\u00ca');
        this.setEntity("Euml", '\u00cb');
        this.setEntity("Igrave", '\u00cc');
        this.setEntity("Iacute", '\u00cd');
        this.setEntity("Icirc", '\u00ce');
        this.setEntity("Iuml", '\u00cf');
        this.setEntity("ETH", '\u00d0');
        this.setEntity("Ntilde", '\u00d1');
        this.setEntity("Ograve", '\u00d2');
        this.setEntity("Oacute", '\u00d3');
        this.setEntity("Ocirc", '\u00d4');
        this.setEntity("Otilde", '\u00d5');
        this.setEntity("Ouml", '\u00d6');
        this.setEntity("times", '\u00d7');
        this.setEntity("Oslash", '\u00d8');
        this.setEntity("Ugrave", '\u00d9');
        this.setEntity("Uacute", '\u00da');
        this.setEntity("Ucirc", '\u00db');
        this.setEntity("Uuml", '\u00dc');
        this.setEntity("Yacute", '\u00dd');
        this.setEntity("THORN", '\u00de');
        this.setEntity("szlig", '\u00df');
        this.setEntity("agrave", '\u00e0');
        this.setEntity("aacute", '\u00e1');
        this.setEntity("acirc", '\u00e2');
        this.setEntity("atilde", '\u00e3');
        this.setEntity("auml", '\u00e4');
        this.setEntity("aring", '\u00e5');
        this.setEntity("aelig", '\u00e6');
        this.setEntity("ccedil", '\u00e7');
        this.setEntity("egrave", '\u00e8');
        this.setEntity("eacute", '\u00e9');
        this.setEntity("ecirc", '\u00ea');
        this.setEntity("euml", '\u00eb');
        this.setEntity("igrave", '\u00ec');
        this.setEntity("iacute", '\u00ed');
        this.setEntity("icirc", '\u00ee');
        this.setEntity("iuml", '\u00ef');
        this.setEntity("eth", '\u00f0');
        this.setEntity("ntilde", '\u00f1');
        this.setEntity("ograve", '\u00f2');
        this.setEntity("oacute", '\u00f3');
        this.setEntity("ocirc", '\u00f4');
        this.setEntity("otilde", '\u00f5');
        this.setEntity("ouml", '\u00f6');
        this.setEntity("divide", '\u00f7');
        this.setEntity("oslash", '\u00f8');
        this.setEntity("ugrave", '\u00f9');
        this.setEntity("uacute", '\u00fa');
        this.setEntity("ucirc", '\u00fb');
        this.setEntity("uuml", '\u00fc');
        this.setEntity("yacute", '\u00fd');
        this.setEntity("thorn", '\u00fe');
        this.setEntity("yuml", '\u00ff');
        this.setEntity("fnof", '\u0192');
        this.setEntity("Alpha", '\u0391');
        this.setEntity("Beta", '\u0392');
        this.setEntity("Gamma", '\u0393');
        this.setEntity("Delta", '\u0394');
        this.setEntity("Epsilon", '\u0395');
        this.setEntity("Zeta", '\u0396');
        this.setEntity("Eta", '\u0397');
        this.setEntity("Theta", '\u0398');
        this.setEntity("Iota", '\u0399');
        this.setEntity("Kappa", '\u039a');
        this.setEntity("Lambda", '\u039b');
        this.setEntity("Mu", '\u039c');
        this.setEntity("Nu", '\u039d');
        this.setEntity("Xi", '\u039e');
        this.setEntity("Omicron", '\u039f');
        this.setEntity("Pi", '\u03a0');
        this.setEntity("Rho", '\u03a1');
        this.setEntity("Sigma", '\u03a3');
        this.setEntity("Tau", '\u03a4');
        this.setEntity("Upsilon", '\u03a5');
        this.setEntity("Phi", '\u03a6');
        this.setEntity("Chi", '\u03a7');
        this.setEntity("Psi", '\u03a8');
        this.setEntity("Omega", '\u03a9');
        this.setEntity("alpha", '\u03b1');
        this.setEntity("beta", '\u03b2');
        this.setEntity("gamma", '\u03b3');
        this.setEntity("delta", '\u03b4');
        this.setEntity("epsilon", '\u03b5');
        this.setEntity("zeta", '\u03b6');
        this.setEntity("eta", '\u03b7');
        this.setEntity("theta", '\u03b8');
        this.setEntity("iota", '\u03b9');
        this.setEntity("kappa", '\u03ba');
        this.setEntity("lambda", '\u03bb');
        this.setEntity("mu", '\u03bc');
        this.setEntity("nu", '\u03bd');
        this.setEntity("xi", '\u03be');
        this.setEntity("omicron", '\u03bf');
        this.setEntity("pi", '\u03c0');
        this.setEntity("rho", '\u03c1');
        this.setEntity("sigmaf", '\u03c2');
        this.setEntity("sigma", '\u03c3');
        this.setEntity("tau", '\u03c4');
        this.setEntity("upsilon", '\u03c5');
        this.setEntity("phi", '\u03c6');
        this.setEntity("chi", '\u03c7');
        this.setEntity("psi", '\u03c8');
        this.setEntity("omega", '\u03c9');
        this.setEntity("thetasym", '\u03d1');
        this.setEntity("upsih", '\u03d2');
        this.setEntity("piv", '\u03d6');
        this.setEntity("bull", '\u2022');
        this.setEntity("hellip", '\u2026');
        this.setEntity("prime", '\u2032');
        this.setEntity("Prime", '\u2033');
        this.setEntity("oline", '\u203e');
        this.setEntity("frasl", '\u2044');
        this.setEntity("weierp", '\u2118');
        this.setEntity("image", '\u2111');
        this.setEntity("real", '\u211c');
        this.setEntity("trade", '\u2122');
        this.setEntity("alefsym", '\u2135');
        this.setEntity("larr", '\u2190');
        this.setEntity("uarr", '\u2191');
        this.setEntity("rarr", '\u2192');
        this.setEntity("darr", '\u2193');
        this.setEntity("harr", '\u2194');
        this.setEntity("crarr", '\u21b5');
        this.setEntity("lArr", '\u21d0');
        this.setEntity("uArr", '\u21d1');
        this.setEntity("rArr", '\u21d2');
        this.setEntity("dArr", '\u21d3');
        this.setEntity("hArr", '\u21d4');
        this.setEntity("forall", '\u2200');
        this.setEntity("part", '\u2202');
        this.setEntity("exist", '\u2203');
        this.setEntity("empty", '\u2205');
        this.setEntity("nabla", '\u2207');
        this.setEntity("isin", '\u2208');
        this.setEntity("notin", '\u2209');
        this.setEntity("ni", '\u220b');
        this.setEntity("prod", '\u220f');
        this.setEntity("sum", '\u2211');
        this.setEntity("minus", '\u2212');
        this.setEntity("lowast", '\u2217');
        this.setEntity("radic", '\u221a');
        this.setEntity("prop", '\u221d');
        this.setEntity("infin", '\u221e');
        this.setEntity("ang", '\u2220');
        this.setEntity("and", '\u2227');
        this.setEntity("or", '\u2228');
        this.setEntity("cap", '\u2229');
        this.setEntity("cup", '\u222a');
        this.setEntity("int", '\u222b');
        this.setEntity("there4", '\u2234');
        this.setEntity("sim", '\u223c');
        this.setEntity("cong", '\u2245');
        this.setEntity("asymp", '\u2248');
        this.setEntity("ne", '\u2260');
        this.setEntity("equiv", '\u2261');
        this.setEntity("le", '\u2264');
        this.setEntity("ge", '\u2265');
        this.setEntity("sub", '\u2282');
        this.setEntity("sup", '\u2283');
        this.setEntity("nsub", '\u2284');
        this.setEntity("sube", '\u2286');
        this.setEntity("supe", '\u2287');
        this.setEntity("oplus", '\u2295');
        this.setEntity("otimes", '\u2297');
        this.setEntity("perp", '\u22a5');
        this.setEntity("sdot", '\u22c5');
        this.setEntity("lceil", '\u2308');
        this.setEntity("rceil", '\u2309');
        this.setEntity("lfloor", '\u230a');
        this.setEntity("rfloor", '\u230b');
        this.setEntity("lang", '\u2329');
        this.setEntity("rang", '\u232a');
        this.setEntity("loz", '\u25ca');
        this.setEntity("spades", '\u2660');
        this.setEntity("clubs", '\u2663');
        this.setEntity("hearts", '\u2665');
        this.setEntity("diams", '\u2666');
        this.setEntity("quot", '\"');
        this.setEntity("amp", '&');
        this.setEntity("lt", '<');
        this.setEntity("gt", '>');
        this.setEntity("OElig", '\u0152');
        this.setEntity("oelig", '\u0153');
        this.setEntity("Scaron", '\u0160');
        this.setEntity("scaron", '\u0161');
        this.setEntity("Yuml", '\u0178');
        this.setEntity("circ", '\u02c6');
        this.setEntity("tilde", '\u02dc');
        this.setEntity("ensp", '\u2002');
        this.setEntity("emsp", '\u2003');
        this.setEntity("thinsp", '\u2009');
        this.setEntity("zwnj", '\u200c');
        this.setEntity("zwj", '\u200d');
        this.setEntity("lrm", '\u200e');
        this.setEntity("rlm", '\u200f');
        this.setEntity("ndash", '\u2013');
        this.setEntity("mdash", '\u2014');
        this.setEntity("lsquo", '\u2018');
        this.setEntity("rsquo", '\u2019');
        this.setEntity("sbquo", '\u201a');
        this.setEntity("ldquo", '\u201c');
        this.setEntity("rdquo", '\u201d');
        this.setEntity("bdquo", '\u201e');
        this.setEntity("dagger", '\u2020');
        this.setEntity("Dagger", '\u2021');
        this.setEntity("permil", '\u2030');
        this.setEntity("lsaquo", '\u2039');
        this.setEntity("rsaquo", '\u203a');
        this.setEntity("euro", '\u20ac');
        this.charToEntity.put(new Character(';'), "semi");
        this.charToEntity.put(new Character('\u00a0'), "nbsp");
        this.preserve = "_-!.~#()*,;:$&+=?/[]@";
    }

    public static final Escape getInstance() {
        if (instance == null) {
            instance = new Escape();
        }
        return instance;
    }

    public static final Escape setInstance(Escape escape) {
        if (escape == null) {
            throw new NullPointerException("Escape instance is null.");
        }
        instance = escape;
        return instance;
    }

    public String encodeAsEntity(char ch) {
        String replacement = this.charToEntity.get(new Character(ch));
        if (replacement == null) {
            String value = "" + ch;
            for (int i = value.length(); i < 3; ++i) {
                value = "0" + value;
            }
            return "&#" + value + ";";
        }
        return "&" + replacement + ";";
    }

    public String decodeAsEntity(String name) {
        if (name == null) {
            throw new NullPointerException("Entity name is null.");
        }
        if (name.startsWith("&") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.startsWith("#")) {
            try {
                name = name.substring(1);
                if (name.startsWith("X")) {
                    name = name.substring(1);
                    return "" + Integer.parseInt(name, 16);
                }
                return "" + Integer.parseInt(name);
            }
            catch (NumberFormatException nfe) {
                return "&" + name + ";";
            }
        }
        Character value = this.entityToChar.get(name);
        if (value == null) {
            return "&" + name + ";";
        }
        return "" + value.charValue();
    }

    public String encodeEntities(String cdata, String characters) {
        if (cdata == null) {
            throw new NullPointerException("The character data to encode is null.");
        }
        if (characters == null) {
            throw new NullPointerException("The list of additional characters to encode is null.");
        }
        StringBuffer buf = new StringBuffer();
        for (char ch : cdata.toCharArray()) {
            if (ch >= '\u0080' || this.alwaysReplace.containsKey(new Character(ch)) || characters.indexOf(ch) >= 0) {
                buf.append(this.encodeAsEntity(ch));
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public String decodeEntities(String cdata) {
        if (cdata == null) {
            throw new NullPointerException("The character data to decode is null.");
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (cdata.length() > 0) {
            i = cdata.indexOf(38);
            if (i < 0) {
                buf.append(cdata);
                cdata = "";
                continue;
            }
            buf.append(cdata.substring(0, i));
            cdata = cdata.substring(i);
            i = cdata.indexOf(59);
            if (i < 0) {
                buf.append(cdata);
                cdata = "";
                continue;
            }
            String entity = cdata.substring(1, i);
            cdata = cdata.substring(i + 1);
            String replace = this.decodeAsEntity(entity);
            buf.append(replace);
        }
        return buf.toString();
    }

    public Escape setUseHex(boolean flag) {
        this.useHex = flag;
        return this;
    }

    public Escape setEntity(String entity, char value) {
        if (entity == null) {
            throw new NullPointerException("The entity name is null.");
        }
        if (entity.startsWith("&")) {
            entity = entity.substring(1, entity.length());
        }
        if (entity.endsWith(";")) {
            entity = entity.substring(0, entity.length() - 1);
        }
        this.charToEntity.put(new Character(value), entity);
        this.entityToChar.put(entity, new Character(value));
        return this;
    }

    public String hexEncode(char ch) {
        byte[] bytes = ("" + ch).getBytes();
        StringBuffer buf = new StringBuffer();
        for (byte bt : bytes) {
            int ibt = bt & 0xFF;
            buf.append('%');
            String hex = Integer.toHexString(ibt);
            if (hex.length() < 2) {
                buf.append('0');
            }
            buf.append(hex);
        }
        return buf.toString();
    }

    public String hexEncode(String text, String characters) {
        StringBuffer buf = new StringBuffer();
        for (char ch : text.toCharArray()) {
            if (ch < '\u0080' && (Character.isLetterOrDigit(ch) || characters.indexOf(ch) >= 0) || this.preserve.indexOf(ch) >= 0) {
                buf.append(ch);
                continue;
            }
            buf.append(this.hexEncode(ch));
        }
        return buf.toString();
    }

    public String hexDecode(String text) {
        if (text == null) {
            throw new NullPointerException("The text to hex decode is null.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int index = 0;
        int length = text.length();
        while (index < length) {
            char ch = text.charAt(index);
            try {
                if (ch == '%') {
                    if (length - index <= 2) {
                        baos.write("%".getBytes());
                        ++index;
                        continue;
                    }
                    String hex = text.substring(index + 1, index + 3);
                    try {
                        int value = Integer.parseInt(hex, 16);
                        baos.write((byte)value);
                        index += 3;
                    }
                    catch (NumberFormatException exception) {
                        baos.write("%".getBytes());
                        ++index;
                    }
                    continue;
                }
                baos.write(("" + ch).getBytes());
                ++index;
            }
            catch (IOException exception) {}
        }
        return baos.toString();
    }
}

