/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.ejb.containers.SFSBVersionManager;
import com.sun.enterprise.iiop.SFSBAbstractInterceptor;
import com.sun.enterprise.iiop.SFSBServiceContextInfo;
import com.sun.enterprise.util.Utility;
import java.util.logging.Level;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class SFSBServerRequestInterceptor
extends SFSBAbstractInterceptor
implements ServerRequestInterceptor {
    private ThreadLocal<SFSBServiceContextInfo> scInfo = new ThreadLocal();

    public SFSBServerRequestInterceptor(Codec codec) {
        super("com.sun.enterprise.iiop.SFSBServerRequestInterceptor", codec);
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        try {
            ServiceContext serviceContext = ri.get_request_service_context(3456);
            if (serviceContext != null) {
                byte[] data = serviceContext.context_data;
                long version = Utility.bytesToLong(data, 0);
                SFSBVersionManager.setRequestClientVersion(version);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SFSBServerReqInterceptor:: receive_request_service_context: " + version);
                }
                SFSBServiceContextInfo info = new SFSBServiceContextInfo();
                info.requestVersion = version;
                info.valid = true;
                this.scInfo.set(info);
            } else {
                this.scInfo.set(null);
            }
        }
        catch (Exception ex) {
            this.scInfo.set(null);
            _logger.log(Level.INFO, "SFSBServerReqInterceptor:: receive_request_service_coventext: ", ex);
        }
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSFSBVersionNumber(String callName, ServerRequestInfo ri) {
        try {
            SFSBServiceContextInfo info = SFSBVersionManager.getServiceContext();
            if (info != null) {
                long version = SFSBVersionManager.getResponseClientVersion();
                byte[] data = new byte[8];
                Utility.longToBytes(version, data, 0);
                ri.add_reply_service_context(new ServiceContext(3456, data), false);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SFSBServerReqInterceptor:: " + callName + ": " + version);
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.INFO, "SFSBServerReqInterceptor:: " + callName + ": ", ex);
        }
        finally {
            SFSBVersionManager.clearServiceContextInfo();
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        this.sendSFSBVersionNumber("send_reply", ri);
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.sendSFSBVersionNumber("send_exception", ri);
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        try {
            SFSBServiceContextInfo info = SFSBVersionManager.getServiceContext();
            if (info != null) {
                _logger.log(Level.WARNING, "SFSBServerReqInterceptor:: send_other: ");
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "SFSBServerReqInterceptor:: send_other: ", ex);
        }
    }
}

