/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.selfmanagement;

import com.sun.appserv.management.alert.MailAlert;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.CustomMBeanException;
import com.sun.enterprise.admin.server.core.CustomMBeanRegistration;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ManagementRule;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.management.selfmanagement.LogMgmtEventsNotificationListener;
import com.sun.enterprise.management.selfmanagement.Rule;
import com.sun.enterprise.management.selfmanagement.SelfManagementService;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public final class RuleManager {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static final StringManager localStrings = StringManager.getManager(RuleManager.class);
    private final Map<String, Rule> activeRules;
    private final Map<String, Rule> inActiveRules;
    private final Map<String, Rule> noActionRules;
    private final Map<String, Rule> disabledRules;
    private final String USER_DEFINED_TYPE = "user";
    private ConfigContext configCtx = null;
    private final String instanceName;
    private MBeanServer instanceMbs = null;
    private String mailSMTPHost = null;
    private String srvAlertRecipients = null;
    private SelfManagementService service = null;

    public RuleManager(SelfManagementService service) {
        this.service = service;
        this.instanceName = ApplicationServer.getServerContext().getInstanceName();
        AdminService adSrv = AdminService.getAdminService();
        this.instanceMbs = adSrv.getAdminContext().getMBeanServer();
        this.configCtx = ApplicationServer.getServerContext().getConfigContext();
        this.activeRules = Collections.synchronizedMap(new HashMap());
        this.inActiveRules = Collections.synchronizedMap(new HashMap());
        this.noActionRules = Collections.synchronizedMap(new HashMap());
        this.disabledRules = Collections.synchronizedMap(new HashMap());
    }

    public void addRule(String ruleName, String description, Event ruleEvent, String actionMBeanName, Object handback, ConfigContext ctxToUse) throws InstanceNotFoundException {
        ObjectName actionObjName = null;
        Object alertAction = null;
        Rule ruleInstance = new Rule(ruleName, description);
        if (ctxToUse != null) {
            this.configCtx = ctxToUse;
        }
        try {
            if (actionMBeanName != null) {
                Domain domain = ServerBeansFactory.getDomainBean(this.configCtx);
                ApplicationRef appRef = this.verifyActionMBean(actionMBeanName, domain, ctxToUse);
                if (appRef != null) {
                    Applications apps = domain.getApplications();
                    Mbean definedMBean = apps.getMbeanByName(actionMBeanName);
                    if (appRef.isEnabled() && definedMBean.isEnabled()) {
                        actionObjName = definedMBean.getObjectType().equals("user") ? this.registerAction(ruleEvent, actionMBeanName, definedMBean, false, handback) : this.registerAction(ruleEvent, actionMBeanName, definedMBean, true, handback);
                        this.setupRuleBinding(0, ruleInstance, ruleEvent, actionObjName);
                    } else {
                        alertAction = this.registerAlertAction(ruleEvent, actionMBeanName, ruleName, handback);
                        _logger.log(Level.WARNING, "sgmt.ruleactiondisabled", new Object[]{ruleName, actionMBeanName});
                        this.setupRuleBinding(1, ruleInstance, ruleEvent, alertAction);
                    }
                } else {
                    _logger.log(Level.SEVERE, "smgt.invalid_action", new Object[]{ruleName, actionMBeanName});
                }
            } else {
                this.setupRuleBinding(3, ruleInstance, ruleEvent, null);
            }
        }
        catch (ConfigException ex) {
            _logger.log(Level.INFO, "config_error", ex);
        }
        catch (InstanceNotFoundException ex) {
            _logger.log(Level.INFO, "smgt.error_reg_action", new Object[]{ruleName, actionMBeanName});
            this.registerAlertAction(ruleEvent, actionMBeanName, ruleName, handback);
        }
        catch (MalformedObjectNameException ex) {
            _logger.log(Level.WARNING, "sgmt.error_reg_action", new Object[]{ruleName, actionMBeanName});
        }
        catch (RuntimeOperationsException ex) {
            _logger.log(Level.WARNING, "smgt.error_reg_action", new Object[]{ruleName, actionMBeanName});
            this.registerAlertAction(ruleEvent, actionMBeanName, ruleName, handback);
        }
        catch (CustomMBeanException cmbe) {
            _logger.log(Level.WARNING, "smgt.error_reg_action", new Object[]{ruleName, actionMBeanName});
            this.registerAlertAction(ruleEvent, actionMBeanName, ruleName, handback);
        }
        catch (RuntimeException ex) {
            _logger.log(Level.WARNING, "smgt.error_reg_action", new Object[]{ruleName, actionMBeanName});
            this.registerAlertAction(ruleEvent, actionMBeanName, ruleName, handback);
        }
    }

    private ApplicationRef verifyActionMBean(String actionMBeanName, Domain domain, ConfigContext ctxToUse) {
        ApplicationRef appRef = null;
        if (ctxToUse != null) {
            this.configCtx = ctxToUse;
        }
        try {
            Applications apps;
            Mbean definedMBean;
            Server instanceBean = ServerBeansFactory.getServerBean(this.configCtx);
            appRef = instanceBean.getApplicationRefByRef(actionMBeanName);
            if (appRef == null) {
                Cluster[] cluster;
                Clusters clusters = domain.getClusters();
                for (Cluster val : cluster = clusters.getCluster()) {
                    if (val.getServerRefByRef(this.instanceName) == null) continue;
                    appRef = val.getApplicationRefByRef(actionMBeanName);
                    break;
                }
            }
            if (appRef != null && (definedMBean = (apps = domain.getApplications()).getMbeanByName(actionMBeanName)) == null) {
                appRef = null;
            }
        }
        catch (ConfigException ex) {
            _logger.log(Level.INFO, "smgt.config_error", ex);
        }
        return appRef;
    }

    public void deleteRule(String name) {
        Rule ruleInstance;
        String description;
        block7: {
            Event ruleEvent = null;
            description = null;
            ruleInstance = null;
            try {
                if (this.activeRules.containsKey(name)) {
                    ruleInstance = this.activeRules.remove(name);
                    ruleEvent = ruleInstance.getEvent();
                    NotificationFilter filter = ruleEvent.getNotificationFilter();
                    ObjectName eventObjName = ruleEvent.getObjectName();
                    ObjectName actionObjName = (ObjectName)ruleInstance.getAction();
                    if (actionObjName != null) {
                        this.instanceMbs.removeNotificationListener(eventObjName, actionObjName, filter, null);
                    }
                    ruleEvent.destroy();
                    break block7;
                }
                if (this.inActiveRules.containsKey(name)) {
                    ruleInstance = this.inActiveRules.remove(name);
                    ruleEvent = ruleInstance.getEvent();
                    ruleEvent.destroy();
                    break block7;
                }
                if (this.noActionRules.containsKey(name)) {
                    ruleInstance = this.noActionRules.remove(name);
                    ruleEvent = ruleInstance.getEvent();
                    ruleEvent.destroy();
                    break block7;
                }
                if (this.disabledRules.containsKey(name)) {
                    ruleInstance = this.disabledRules.remove(name);
                    break block7;
                }
                _logger.log(Level.WARNING, "sgmt.delete_invalidname", name);
                return;
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "sgmt.error_delete_rule", new Object[]{name, ex.toString()});
                return;
            }
        }
        description = ruleInstance.getDescription();
        _logger.log(Level.INFO, "sgmt.deleted_rule", new Object[]{name, description});
        ruleInstance = null;
    }

    public void addDisabledRule(String ruleName, String ruleDescription) {
        Rule ruleInstance = new Rule(ruleName, ruleDescription);
        this.setupRuleBinding(2, ruleInstance, null, null);
    }

    Event checkEventExists(String type, ElementProperty[] eventProps) {
        return null;
    }

    private ObjectName registerAction(Event ruleEvent, String actionMBeanName, Mbean definedActionMBean, boolean isSystemDefined, Object handback) throws InstanceNotFoundException, MalformedObjectNameException, CustomMBeanException {
        ObjectName actionObjName = null;
        ObjectName eventObjName = ruleEvent.getObjectName();
        NotificationFilter filter = ruleEvent.getNotificationFilter();
        try {
            if (isSystemDefined) {
                CustomMBeanRegistration obj = this.getCustomMBeanRegistration();
                actionObjName = obj.registerMBean(definedActionMBean);
                this.instanceMbs.addNotificationListener(eventObjName, actionObjName, filter, null);
            } else {
                String objName = definedActionMBean.getObjectName();
                actionObjName = objName == null ? ObjectNames.getApplicationObjectName(this.instanceName, actionMBeanName) : this.getCascadedObjectName(objName);
                this.instanceMbs.addNotificationListener(eventObjName, actionObjName, filter, null);
                if (handback != null) {
                    this.createLoggingListener(ruleEvent, handback);
                }
            }
        }
        catch (CustomMBeanException ex) {
            if (ex.getCause() instanceof InstanceAlreadyExistsException) {
                String objName = definedActionMBean.getObjectName();
                actionObjName = this.getCascadedObjectName(objName);
            }
            throw ex;
        }
        return actionObjName;
    }

    private Object registerAlertAction(Event ruleEvent, String actionMBeanName, String ruleName, Object handback) throws InstanceNotFoundException {
        NotificationFilterSupport filter = null;
        if (this.srvAlertRecipients == null) {
            filter = new NotificationFilterSupport();
            filter.disableAllTypes();
        }
        String subject = localStrings.getString("ruleMgr.alert_action", ruleName, actionMBeanName);
        MailAlert alertAction = new MailAlert();
        alertAction.setSubject(subject);
        alertAction.setRecipients(this.srvAlertRecipients);
        ObjectName eventObjName = ruleEvent.getObjectName();
        this.createLoggingListener(ruleEvent, handback);
        return alertAction;
    }

    private void setupRuleBinding(int ruleState, Rule ruleInstance, Event ruleEvent, Object action) {
        String ruleName = ruleInstance.getName();
        Map ruleMap = this.getRuleMap(ruleName);
        if (ruleMap != null) {
            ruleMap.remove(ruleName);
        }
        ruleInstance.setState(ruleState);
        if (ruleState != 2) {
            ruleInstance.setEvent(ruleEvent);
            ruleInstance.setAction(action);
            ruleInstance.setEnabled(true);
        }
        switch (ruleState) {
            case 0: {
                this.activeRules.put(ruleName, ruleInstance);
                break;
            }
            case 1: {
                this.inActiveRules.put(ruleName, ruleInstance);
                break;
            }
            case 3: {
                this.noActionRules.put(ruleName, ruleInstance);
                break;
            }
            case 2: {
                this.disabledRules.put(ruleName, ruleInstance);
            }
        }
    }

    private CustomMBeanRegistration getCustomMBeanRegistration() {
        String CUSTOM_REGRISTRATION_IMPL_CLASS = "com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl";
        CustomMBeanRegistration customObj = null;
        Constructor<?> ctor = null;
        Object[] args = null;
        try {
            Class<?> c = Class.forName("com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl");
            Class[] params = new Class[]{MBeanServer.class};
            ctor = c.getConstructor(params);
            args = new Object[]{this.instanceMbs};
            customObj = (CustomMBeanRegistration)ctor.newInstance(args);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "smgt.internal_error", ex);
        }
        return customObj;
    }

    public void setMailSMTPHost(String value) {
        this.mailSMTPHost = this.mailSMTPHost != null ? value : "localhost";
    }

    public void setRecipients(String value) {
        this.srvAlertRecipients = value;
    }

    private ObjectName getCascadedObjectName(String actionMBeanName) throws MalformedObjectNameException {
        ObjectName configObjName = new ObjectName(actionMBeanName);
        String serverNameKey = "server";
        Hashtable<String, String> properties = configObjName.getKeyPropertyList();
        properties.put(serverNameKey, this.instanceName);
        ObjectName casdObjName = new ObjectName(configObjName.getDomain(), properties);
        return casdObjName;
    }

    private void createLoggingListener(Event event, Object handback) throws InstanceNotFoundException {
        LogMgmtEventsNotificationListener logListener = LogMgmtEventsNotificationListener.getInstance();
        this.instanceMbs.addNotificationListener(event.getObjectName(), logListener, event.getNotificationFilter(), handback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRule(ManagementRule rule, ConfigUpdate configUp, ConfigContext ctxToUse) throws Exception {
        String name = rule.getName();
        Rule ruleInstance = this.getRuleInstance(name);
        if (ruleInstance != null) {
            Rule rule2 = ruleInstance;
            synchronized (rule2) {
                String description = ruleInstance.getDescription();
                Set attributesChg = configUp.getAttributeSet();
                for (String attribute : attributesChg) {
                    if (!attribute.equals("enabled")) continue;
                    String oldValue = configUp.getOldValue(attribute);
                    String newValue = configUp.getNewValue(attribute);
                    _logger.log(Level.INFO, "sgmt.updateruleattribute", new Object[]{attribute, oldValue, newValue});
                    if (ruleInstance.isEnabled() && newValue.equals("false")) {
                        if (this.service.isServiceEnabled()) {
                            this.disableRule(ruleInstance, false);
                            _logger.log(Level.INFO, "smgt.disabledrule", new Object[]{name, description});
                            continue;
                        }
                        _logger.log(Level.WARNING, "sgmt.error_disablerule_noservice", new Object[]{name, description});
                        continue;
                    }
                    if (!ruleInstance.isEnabled() && newValue.equals("true")) {
                        if (this.service.isServiceEnabled()) {
                            this.service.addRule(rule, ctxToUse);
                            _logger.log(Level.INFO, "smgt.enabledrule", new Object[]{name, description});
                            continue;
                        }
                        _logger.log(Level.WARNING, "sgmt.error_enablerule_noservice", new Object[]{name, description});
                        continue;
                    }
                    _logger.log(Level.INFO, "smgt.cannot_changesstate", new Object[]{name, description});
                }
            }
        }
    }

    private Rule getRuleInstance(String ruleName) {
        Rule rule = null;
        if (this.activeRules.containsKey(ruleName)) {
            rule = this.activeRules.get(ruleName);
        } else if (this.disabledRules.containsKey(ruleName)) {
            rule = this.disabledRules.get(ruleName);
        } else if (this.inActiveRules.containsKey(ruleName)) {
            rule = this.inActiveRules.get(ruleName);
        } else if (this.noActionRules.containsKey(ruleName)) {
            rule = this.noActionRules.get(ruleName);
        }
        return rule;
    }

    private Map getRuleMap(String ruleName) {
        Map<String, Rule> ruleMap = null;
        if (this.activeRules.containsKey(ruleName)) {
            ruleMap = this.activeRules;
        } else if (this.disabledRules.containsKey(ruleName)) {
            ruleMap = this.disabledRules;
        } else if (this.inActiveRules.containsKey(ruleName)) {
            ruleMap = this.inActiveRules;
        } else if (this.noActionRules.containsKey(ruleName)) {
            ruleMap = this.noActionRules;
        }
        return ruleMap;
    }

    private void disableRule(Rule ruleInstance, boolean disableService) throws Exception {
        String ruleName = ruleInstance.getName();
        Event ruleEvent = ruleInstance.getEvent();
        try {
            if (ruleInstance.getState() == 0) {
                NotificationFilter filter = ruleEvent.getNotificationFilter();
                ObjectName eventObjName = ruleEvent.getObjectName();
                ObjectName actionObjName = (ObjectName)ruleInstance.getAction();
                this.instanceMbs.removeNotificationListener(eventObjName, actionObjName, filter, null);
                ruleInstance.setAction(null);
                if (!disableService) {
                    this.activeRules.remove(ruleName);
                }
            } else if (ruleInstance.getState() == 1) {
                ruleInstance.setAction(null);
                if (!disableService) {
                    this.inActiveRules.remove(ruleName);
                }
            } else if (ruleInstance.getState() == 3) {
                ruleInstance.setAction(null);
                if (!disableService) {
                    this.noActionRules.remove(ruleName);
                }
            }
            ruleEvent.destroy();
            ruleInstance.setEvent(null);
            if (!disableService) {
                ruleInstance.setEnabled(false);
                ruleInstance.setState(2);
                this.disabledRules.put(ruleName, ruleInstance);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "sgmt.error_disablerule", new Object[]{ruleName, ex});
            throw ex;
        }
    }

    synchronized void disableService() throws Exception {
        int size = this.activeRules.size() + this.inActiveRules.size() + this.noActionRules.size();
        HashMap<String, Rule> completeMap = new HashMap<String, Rule>(size);
        completeMap.putAll(this.activeRules);
        completeMap.putAll(this.inActiveRules);
        completeMap.putAll(this.noActionRules);
        Set rules = completeMap.keySet();
        for (String name : rules) {
            Rule ruleInstance = (Rule)completeMap.get(name);
            this.disableRule(ruleInstance, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAction(String ruleName, String actionName, ConfigContext ctxToUse) {
        Rule ruleInstance = this.getRuleInstance(ruleName);
        if (ruleInstance != null) {
            Rule rule = ruleInstance;
            synchronized (rule) {
                this.bindAction(ruleInstance, actionName, ctxToUse);
            }
        }
    }

    private void bindAction(Rule ruleInstance, String actionMBeanName, ConfigContext ctxToUse) {
        String ruleName = ruleInstance.getName();
        Event ruleEvent = ruleInstance.getEvent();
        ObjectName actionObjName = null;
        Object alertAction = null;
        try {
            Domain domain = ServerBeansFactory.getDomainBean(ctxToUse);
            ApplicationRef appRef = this.verifyActionMBean(actionMBeanName, domain, ctxToUse);
            if (appRef != null) {
                Applications apps = domain.getApplications();
                Mbean definedMBean = apps.getMbeanByName(actionMBeanName);
                if (appRef.isEnabled() && definedMBean.isEnabled()) {
                    actionObjName = definedMBean.getObjectType().equals("user") ? this.registerAction(ruleEvent, actionMBeanName, definedMBean, false, null) : this.registerAction(ruleEvent, actionMBeanName, definedMBean, true, null);
                    ruleInstance.setAction(actionObjName);
                    this.setupRuleBinding(0, ruleInstance, ruleEvent, actionObjName);
                    _logger.log(Level.INFO, "smgt.successaddaction", new Object[]{ruleName, actionMBeanName});
                } else {
                    _logger.log(Level.WARNING, "sgmt.ruleactiondisabled", new Object[]{ruleName, actionMBeanName});
                    ruleInstance.setState(1);
                    this.setupRuleBinding(1, ruleInstance, ruleEvent, alertAction);
                }
            } else {
                _logger.log(Level.SEVERE, "smgt.invalid_action", new Object[]{ruleName, actionMBeanName});
            }
        }
        catch (ConfigException ex) {
            _logger.log(Level.INFO, "config_error", ex);
        }
        catch (InstanceNotFoundException ex) {
            _logger.log(Level.INFO, "smgt.error_reg_action", new Object[]{ruleName, actionMBeanName});
        }
        catch (MalformedObjectNameException ex) {
            _logger.log(Level.WARNING, "sgmt.error_reg_action", new Object[]{ruleName, actionMBeanName});
        }
        catch (RuntimeOperationsException ex) {
            _logger.log(Level.WARNING, "smgt.error_reg_action", new Object[]{ruleName, actionMBeanName});
        }
        catch (CustomMBeanException cmbe) {
            _logger.log(Level.WARNING, "smgt.error_reg_action", new Object[]{ruleName, actionMBeanName});
        }
        catch (RuntimeException ex) {
            _logger.log(Level.WARNING, "smgt.error_reg_action", new Object[]{ruleName, actionMBeanName});
        }
    }

    public void deleteAction(String name) {
        Event ruleEvent = null;
        Rule ruleInstance = null;
        try {
            ruleInstance = this.getRuleInstance(name);
            ruleEvent = ruleInstance.getEvent();
            NotificationFilter filter = ruleEvent.getNotificationFilter();
            ObjectName eventObjName = ruleEvent.getObjectName();
            ObjectName actionObjName = (ObjectName)ruleInstance.getAction();
            this.instanceMbs.removeNotificationListener(eventObjName, actionObjName, filter, null);
            this.setupRuleBinding(3, ruleInstance, ruleEvent, null);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "sgmt.error_delete_action", new Object[]{name, ex.toString()});
        }
        ruleInstance = null;
    }
}

