/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public abstract class AbstractResourcePool
implements MonitorableResourcePool {
    protected static final StringManager localStrings = StringManager.getManager(AbstractResourcePool.class);
    protected ArrayList<ResourceHandle> resources;
    protected ArrayList<ResourceHandle> free;
    protected long idletime;
    protected String name;
    protected ResourceSpec resourceSpec;
    protected ResourceAllocator allocator;
    protected int maxPoolSize;
    protected int steadyPoolSize;
    protected int resizeQuantity;
    protected int maxWaitTime;
    protected boolean failAllConnections = false;
    protected boolean matchConnections = false;
    protected boolean poolInitialized = false;
    protected Timer timer;
    protected TimerTask resizerTask;
    protected boolean monitoringEnabled;
    protected PoolCounters poolCounters = null;
    protected boolean validation = false;
    protected final LinkedList waitQueue = new LinkedList();
    protected boolean connectionLeakTracing_;
    protected long connectionLeakTimeoutInMilliSeconds_;
    protected boolean connectionLeakReclaim_;
    protected boolean connectionCreationRetry_;
    protected int connectionCreationRetryAttempts_;
    protected long conCreationRetryInterval_;
    protected long validateAtmostPeriodInMilliSeconds_;
    protected int maxConnectionUsage_;
    private final Object connectionLeakLock;
    private HashMap<ResourceHandle, StackTraceElement[]> connectionLeakThreadStackHashMap;
    private HashMap<ResourceHandle, ConnectionLeakTask> connectionLeakTimerTaskHashMap;
    private boolean selfManaged_;
    private boolean validateAtmostEveryIdleSecs = false;
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public AbstractResourcePool(String poolName) throws PoolingException {
        this.name = poolName;
        this.setPoolConfiguration();
        this.monitoringEnabled = false;
        this.resources = new ArrayList(this.maxPoolSize);
        this.free = new ArrayList(this.maxPoolSize);
        this.connectionLeakThreadStackHashMap = new HashMap();
        this.connectionLeakTimerTaskHashMap = new HashMap();
        this.connectionLeakLock = new Object();
    }

    private void setPoolConfiguration() throws PoolingException {
        ConnectorConnectionPool poolResource;
        Context ic = Switch.getSwitch().getNamingManager().getInitialContext();
        try {
            String jndiNameOfPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(this.name);
            poolResource = (ConnectorConnectionPool)ic.lookup(jndiNameOfPool);
        }
        catch (NamingException ex) {
            throw new PoolingException(ex);
        }
        this.idletime = Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000;
        this.maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
        this.steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
        if (this.maxPoolSize < this.steadyPoolSize) {
            this.maxPoolSize = this.steadyPoolSize;
        }
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.failAllConnections = poolResource.isFailAllConnections();
        this.validation = poolResource.isIsConnectionValidationRequired();
        this.validateAtmostEveryIdleSecs = poolResource.isValidateAtmostEveryIdleSecs();
        this.setAdvancedPoolConfiguration(poolResource);
    }

    protected synchronized void initPool(ResourceSpec resourceSpec, ResourceAllocator allocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        this.resourceSpec = resourceSpec;
        this.allocator = allocator;
        this.createResources(this.allocator, this.steadyPoolSize - this.resources.size());
        if (this.idletime > 0L) {
            this.scheduleResizerTask();
        }
        this.poolInitialized = true;
    }

    private void scheduleResizerTask() {
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
            this.resizerTask = null;
        }
        this.resizerTask = new Resizer();
        if (this.timer == null) {
            this.timer = Switch.getSwitch().getTimer();
        }
        this.timer.scheduleAtFixedRate(this.resizerTask, this.idletime, this.idletime);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("schduled resizer task");
        }
    }

    public synchronized void addResource(ResourceSpec spec, ResourceHandle h) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resource added: " + spec + "," + h);
        }
        ResourceState state = new ResourceState();
        this.resources.add(h);
        h.setResourceState(state);
        state.setEnlisted(false);
        this.setResourceStateToBusy(h);
    }

    protected void setResourceStateToFree(ResourceHandle resourceHandle) {
        this.getResourceState(resourceHandle).setBusy(false);
        if (this.connectionLeakTracing_) {
            this.stopConnectionLeakTracing(resourceHandle);
        }
    }

    protected void setResourceStateToBusy(ResourceHandle resourceHandle) {
        this.getResourceState(resourceHandle).setBusy(true);
        if (this.connectionLeakTracing_) {
            this.startConnectionLeakTracing(resourceHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnectionLeakTracing(ResourceHandle resourceHandle) {
        Object object = this.connectionLeakLock;
        synchronized (object) {
            if (!this.connectionLeakThreadStackHashMap.containsKey(resourceHandle)) {
                this.connectionLeakThreadStackHashMap.put(resourceHandle, Thread.currentThread().getStackTrace());
                ConnectionLeakTask connectionLeakTask = new ConnectionLeakTask(resourceHandle);
                this.connectionLeakTimerTaskHashMap.put(resourceHandle, connectionLeakTask);
                if (this.timer == null) {
                    this.timer = Switch.getSwitch().getTimer();
                }
                this.timer.schedule((TimerTask)connectionLeakTask, this.connectionLeakTimeoutInMilliSeconds_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnectionLeakTracing(ResourceHandle resourceHandle) {
        Object object = this.connectionLeakLock;
        synchronized (object) {
            if (this.connectionLeakThreadStackHashMap.containsKey(resourceHandle)) {
                this.connectionLeakThreadStackHashMap.remove(resourceHandle);
                ConnectionLeakTask connectionLeakTask = this.connectionLeakTimerTaskHashMap.remove(resourceHandle);
                connectionLeakTask.cancel();
                this.timer.purge();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void potentialConnectionLeakFound(ResourceHandle resourceHandle) {
        Object object = this.connectionLeakLock;
        synchronized (object) {
            if (this.connectionLeakThreadStackHashMap.containsKey(resourceHandle)) {
                StackTraceElement[] threadStack = this.connectionLeakThreadStackHashMap.remove(resourceHandle);
                this.printConnectionLeakTrace(threadStack);
                this.connectionLeakTimerTaskHashMap.remove(resourceHandle);
                if (this.connectionLeakReclaim_) {
                    this.freeResource(resourceHandle);
                }
                if (this.monitoringEnabled) {
                    this.poolCounters.incrementNumPotentialConnLeak();
                }
            }
        }
    }

    private void printConnectionLeakTrace(StackTraceElement[] threadStackTrace) {
        StringBuffer stackTrace = new StringBuffer();
        String msg = localStrings.getStringWithDefault("potential.connection.leak.msg", "A potential connection leak detected for connection pool " + this.name + ". The stack trace of the thread is provided below : ", new Object[]{this.name});
        stackTrace.append(msg + "\n");
        for (int i = 2; i < threadStackTrace.length; ++i) {
            stackTrace.append(threadStackTrace[i].toString() + "\n");
        }
        if (this.monitoringEnabled) {
            msg = localStrings.getStringWithDefault("monitoring.statistics", "Monitoring Statistics :");
            stackTrace.append("\n" + msg + "\n");
            stackTrace.append(this.poolCounters.toString());
        }
        _logger.log(Level.WARNING, stackTrace.toString(), "ConnectionPoolName=" + this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllConnectionLeakTasks() {
        Object object = this.connectionLeakLock;
        synchronized (object) {
            for (ResourceHandle resourceHandle : this.connectionLeakTimerTaskHashMap.keySet()) {
                ConnectionLeakTask connectionLeakTask = this.connectionLeakTimerTaskHashMap.get(resourceHandle);
                connectionLeakTask.cancel();
            }
            if (this.timer != null) {
                this.timer.purge();
            }
            this.connectionLeakThreadStackHashMap.clear();
            this.connectionLeakTimerTaskHashMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = null;
        long startTime = 0L;
        long elapsedWaitTime = 0L;
        long remainingWaitTime = 0L;
        Object waitMonitor = new Object();
        if (this.maxWaitTime > 0) {
            startTime = System.currentTimeMillis();
        }
        while (true) {
            if ((result = this.internalGetResource(spec, alloc, tran)) != null) {
                if (!this.monitoringEnabled) break;
                this.poolCounters.incrementNumConnAcquired();
                elapsedWaitTime = System.currentTimeMillis() - startTime;
                this.poolCounters.setWaitTime(elapsedWaitTime);
                break;
            }
            if (this.maxWaitTime > 0) {
                elapsedWaitTime = System.currentTimeMillis() - startTime;
                if (elapsedWaitTime < (long)this.maxWaitTime) {
                    remainingWaitTime = (long)this.maxWaitTime - elapsedWaitTime;
                } else {
                    if (this.monitoringEnabled) {
                        this.poolCounters.incrementNumConnTimedOut();
                    }
                    String msg = localStrings.getStringWithDefault("poolmgr.no.available.resource", "No available resource. Wait-time expired.");
                    throw new PoolingException(msg);
                }
            }
            Object object = waitMonitor;
            synchronized (object) {
                LinkedList linkedList = this.waitQueue;
                synchronized (linkedList) {
                    this.waitQueue.addLast(waitMonitor);
                }
                try {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Resource Pool: getting on wait queue");
                    }
                    waitMonitor.wait(remainingWaitTime);
                }
                catch (InterruptedException ex) {
                    break;
                }
                linkedList = this.waitQueue;
                synchronized (linkedList) {
                    this.waitQueue.remove(waitMonitor);
                }
            }
        }
        alloc.fillInResourceObjects(result);
        return result;
    }

    protected abstract ResourceHandle prefetch(ResourceSpec var1, ResourceAllocator var2, Transaction var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceHandle internalGetResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result;
        block16: {
            if (!this.poolInitialized) {
                this.initPool(spec, alloc);
            }
            result = null;
            result = this.prefetch(spec, alloc, tran);
            if (result != null) {
                return result;
            }
            try {
                J2EETransaction j2eetran;
                Set set;
                if (tran == null || !alloc.shareableWithinComponent() || (set = (j2eetran = (J2EETransaction)tran).getResources(this.name)) == null) break block16;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    ResourceHandle h = (ResourceHandle)iter.next();
                    if (h.hasConnectionErrorOccurred()) {
                        iter.remove();
                        continue;
                    }
                    ResourceState state = h.getResourceState();
                    if (!h.getResourceAllocator().shareableWithinComponent() || !spec.isXA() && !this.isNonXAResourceAndFree(j2eetran, h)) continue;
                    if (this.matchConnections) {
                        if (!alloc.matchConnection(h)) {
                            if (!this.monitoringEnabled) continue;
                            this.poolCounters.incrementNumConnNotSuccessfullyMatched();
                            continue;
                        }
                        if (h.hasConnectionErrorOccurred()) {
                            if (this.failAllConnections) {
                                result = null;
                                break;
                            } else {
                                iter.remove();
                                continue;
                            }
                        }
                        if (this.monitoringEnabled) {
                            this.poolCounters.incrementNumConnSuccessfullyMatched();
                        }
                    }
                    if (state.isFree()) {
                        this.setResourceStateToBusy(h);
                    }
                    result = h;
                    break;
                }
            }
            catch (ClassCastException e) {
                _logger.log(Level.FINE, "Pool: getResource : transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
            }
        }
        if (result == null && (result = this.getUnenlistedResource(spec, alloc, tran)) != null) {
            if (this.maxConnectionUsage_ > 0) {
                result.incrementUsageCount();
            }
            if (this.monitoringEnabled) {
                this.poolCounters.incrementNumConnUsed();
            }
        }
        return result;
    }

    private boolean isNonXAResource(ResourceHandle resource) {
        return !resource.getResourceSpec().isXA();
    }

    private boolean isNonXAResourceInTransaction(J2EETransaction tran, ResourceHandle resource) {
        return resource.equals(tran.getNonXAResource());
    }

    private boolean isNonXAResourceAndFree(J2EETransaction tran, ResourceHandle resource) {
        return resource.getResourceState().isFree() && this.isNonXAResource(resource) && this.isNonXAResourceInTransaction(tran, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle resource;
        while ((resource = this.getResourceFromPool(spec, alloc, tran)) != null) {
            boolean isValid = this.isConnectionValid(resource, alloc);
            if (!resource.hasConnectionErrorOccurred() && isValid) break;
            AbstractResourcePool abstractResourcePool = this;
            synchronized (abstractResourcePool) {
                if (this.failAllConnections) {
                    resource = this.createSingleResourceAndAdjustPool(alloc, spec);
                    break;
                }
                this.resources.remove(resource);
                this.destroyResource(resource);
            }
        }
        return resource;
    }

    private boolean isConnectionValid(ResourceHandle h, ResourceAllocator alloc) {
        boolean connectionValid = true;
        if (this.validation || this.validateAtmostEveryIdleSecs) {
            long timeSinceValidation;
            long validationPeriod = this.validation ? this.validateAtmostPeriodInMilliSeconds_ : this.idletime;
            boolean validationRequired = true;
            long currentTime = h.getLastValidated();
            if (validationPeriod > 0L && (timeSinceValidation = (currentTime = System.currentTimeMillis()) - h.getLastValidated()) < validationPeriod) {
                validationRequired = false;
            }
            if (validationRequired) {
                if (!alloc.isConnectionValid(h)) {
                    connectionValid = false;
                    this.incrementNumConnFailedValidation();
                } else {
                    h.setLastValidated(currentTime);
                }
            }
        }
        return connectionValid;
    }

    protected boolean matchConnection(ResourceHandle resource, ResourceAllocator alloc) {
        boolean matched = true;
        if (this.matchConnections) {
            matched = alloc.matchConnection(resource);
            if (this.monitoringEnabled) {
                if (matched) {
                    this.poolCounters.incrementNumConnSuccessfullyMatched();
                } else {
                    this.poolCounters.incrementNumConnNotSuccessfullyMatched();
                }
            }
        }
        return matched;
    }

    protected synchronized ResourceHandle getResourceFromPool(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = null;
        Iterator<ResourceHandle> iter = this.free.iterator();
        while (iter.hasNext()) {
            ResourceHandle h = iter.next();
            if (h.hasConnectionErrorOccurred()) {
                iter.remove();
                continue;
            }
            if (h.isAssociated() || !this.matchConnection(h, alloc)) continue;
            result = h;
            break;
        }
        if (result != null) {
            this.setResourceStateToBusy(result);
            this.free.remove(result);
        } else {
            result = this.resizePoolAndGetNewResource(alloc);
        }
        return result;
    }

    private ResourceHandle resizePoolAndGetNewResource(ResourceAllocator alloc) throws PoolingException {
        ResourceHandle result = null;
        int numOfConnsToCreate = 0;
        if (this.resources.size() < this.steadyPoolSize) {
            numOfConnsToCreate = this.steadyPoolSize - this.resources.size();
        } else if (this.resources.size() + this.resizeQuantity <= this.maxPoolSize) {
            numOfConnsToCreate = this.resizeQuantity;
        } else if (this.resources.size() < this.maxPoolSize) {
            numOfConnsToCreate = this.maxPoolSize - this.resources.size();
        }
        if (numOfConnsToCreate > 0) {
            this.createResources(alloc, numOfConnsToCreate);
            int newResourcesIndex = this.free.size() - numOfConnsToCreate;
            result = this.free.remove(newResourcesIndex);
            this.setResourceStateToBusy(result);
        } else if (this.free.size() > 0) {
            this.purgeResources(this.resizeQuantity);
            result = this.resizePoolAndGetNewResource(alloc);
        }
        return result;
    }

    private int purgeResources(int quantity) {
        int resourcesCount;
        int freeResourcesCount = this.free.size();
        int n = resourcesCount = freeResourcesCount >= quantity ? quantity : freeResourcesCount;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Purging resources of size : " + resourcesCount);
        }
        for (int i = resourcesCount - 1; i >= 0; --i) {
            ResourceHandle resource = this.free.remove(i);
            this.resources.remove(resource);
            this.destroyResource(resource);
        }
        return resourcesCount;
    }

    protected ResourceHandle createSingleResourceAndAdjustPool(ResourceAllocator alloc, ResourceSpec spec) throws PoolingException {
        if (this.free.size() != 0) {
            ResourceHandle rHandle = this.free.get(0);
            this.resources.remove(rHandle);
            this.free.remove(rHandle);
        }
        ResourceHandle result = this.createSingleResource(alloc);
        this.addResource(spec, result);
        alloc.fillInResourceObjects(result);
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnCreated();
        }
        return result;
    }

    protected ResourceHandle createSingleResource(ResourceAllocator resourceAllocator) throws PoolingException {
        ResourceHandle resourceHandle = null;
        int count = 0;
        while (true) {
            try {
                ++count;
                resourceHandle = resourceAllocator.createResource();
                if (!this.validation && !this.validateAtmostEveryIdleSecs) break;
                resourceHandle.setLastValidated(System.currentTimeMillis());
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Connection creation failed for " + count + " time. It will be retried, " + "if connection creation retrial is enabled.", ex);
                if (!this.connectionCreationRetry_ || count >= this.connectionCreationRetryAttempts_) {
                    throw new PoolingException(ex);
                }
                try {
                    Thread.sleep(this.conCreationRetryInterval_);
                }
                catch (InterruptedException ie) {}
                continue;
            }
            break;
        }
        return resourceHandle;
    }

    private synchronized void createResources(ResourceAllocator alloc, int size) throws PoolingException {
        for (int i = 0; i < size; ++i) {
            this.createResourceAndAddToPool(alloc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyResource(ResourceHandle resourceHandle) {
        try {
            resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "poolmgr.destroy_resource_failed");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "poolmgr.destroy_resource_failed", ex);
            }
        }
        finally {
            if (resourceHandle.getResourceState().isBusy()) {
                this.stopConnectionLeakTracing(resourceHandle);
            }
            if (this.monitoringEnabled) {
                this.poolCounters.incrementNumConnDestroyed();
                if (resourceHandle.getResourceState().isBusy()) {
                    this.poolCounters.decrementNumConnUsed(true);
                } else {
                    this.poolCounters.decrementNumConnFree();
                }
            }
        }
    }

    public void resourceClosed(ResourceHandle h) throws IllegalStateException {
        ResourceState state;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceClosed: " + h);
        }
        if ((state = this.getResourceState(h)) == null) {
            throw new IllegalStateException("State is null");
        }
        if (!state.isBusy()) {
            throw new IllegalStateException("state.isBusy() : false");
        }
        this.setResourceStateToFree(h);
        state.touchTimestamp();
        if (state.isUnenlisted() || this.isNonXAResource(h) && this.isLocalResourceEligibleForReuse(h)) {
            this.freeUnenlistedResource(h);
        }
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnReleased();
        }
        _logger.log(Level.FINE, "Pool: resourceFreed: " + h);
    }

    private boolean isLocalResourceEligibleForReuse(ResourceHandle h) {
        boolean result = false;
        if (!this.isLocalResourceInTransaction(h)) {
            try {
                this.enforceDelistment(h);
            }
            catch (SystemException se) {
                _logger.log(Level.FINE, "Exception while delisting the local resource forcibily from transaction", se);
                return result;
            }
            h.getResourceState().setEnlisted(false);
            result = true;
        }
        return result;
    }

    private synchronized void enforceDelistment(ResourceHandle h) throws SystemException {
        Set set;
        J2EETransaction txn = (J2EETransaction)Switch.getSwitch().getTransactionManager().getTransaction();
        if (txn != null && (set = txn.getResources(this.name)) != null) {
            set.remove(h);
        }
    }

    private boolean isLocalResourceInTransaction(ResourceHandle h) {
        boolean result = true;
        try {
            J2EETransaction txn = (J2EETransaction)Switch.getSwitch().getTransactionManager().getTransaction();
            if (txn != null) {
                result = this.isNonXAResourceInTransaction(txn, h);
            }
        }
        catch (SystemException e) {
            _logger.log(Level.FINE, "Exception while checking whether the resource is nonxa and is enlisted in transaction : ", e);
        }
        return result;
    }

    protected void performMaxConnectionUsageOperation(ResourceHandle handle) {
        if (handle.getUsageCount() >= this.maxConnectionUsage_) {
            this.resources.remove(handle);
            this.free.remove(handle);
            this.destroyResource(handle);
            _logger.log(Level.INFO, "resource_pool.remove_max_used_conn", handle.getUsageCount());
            if (this.resources.size() < this.steadyPoolSize) {
                try {
                    this.createResourceAndAddToPool(handle.getResourceAllocator());
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "resource_pool.failed_creating_resource", e);
                }
            }
        }
    }

    protected synchronized void freeUnenlistedResource(ResourceHandle h) {
        this.freeResource(h);
    }

    protected synchronized void freeResource(ResourceHandle resourceHandle) {
        this.free.add(resourceHandle);
        if (this.monitoringEnabled) {
            this.poolCounters.decrementNumConnUsed(false);
        }
        if (this.maxConnectionUsage_ > 0) {
            this.performMaxConnectionUsageOperation(resourceHandle);
        }
        this.notifyWaitingThreads();
    }

    public synchronized void resourceErrorOccurred(ResourceHandle h) throws IllegalStateException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Pool: resourceErrorOccurred: " + h);
        }
        if (this.failAllConnections) {
            this.doFailAllConnectionsProcessing();
            return;
        }
        ResourceState state = this.getResourceState(h);
        if (state == null) {
            throw new IllegalStateException();
        }
        this.resources.remove(h);
        this.destroyResource(h);
    }

    private void doFailAllConnectionsProcessing() {
        this.logFine("doFailAllConnectionsProcessing entered");
        this.cancelResizerTask();
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnFailedValidation(this.resources.size());
        }
        this.emptyPool();
        try {
            this.createResources(this.allocator, this.steadyPoolSize);
        }
        catch (PoolingException pe) {
            this.logFine("in doFailAllConnectionsProcessing couldn't create steady resources");
        }
        this.scheduleResizerTask();
        this.logFine("doFailAllConnectionsProcessing done - created new resources");
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle resource) throws IllegalStateException {
        try {
            J2EETransaction j2eetran = (J2EETransaction)tran;
            HashSet<ResourceHandle> set = j2eetran.getResources(this.name);
            if (set == null) {
                set = new HashSet<ResourceHandle>();
                j2eetran.setResources(set, this.name);
            }
            set.add(resource);
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool: resourceEnlisted:transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
        }
        ResourceState state = this.getResourceState(resource);
        state.setEnlisted(true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceEnlisted: " + resource);
        }
    }

    public synchronized void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        try {
            J2EETransaction j2eetran = (J2EETransaction)tran;
            Set set = j2eetran.getResources(this.name);
            if (set == null) {
                return;
            }
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                ResourceHandle resource = (ResourceHandle)iter.next();
                ResourceState state = this.getResourceState(resource);
                state.setEnlisted(false);
                if (this.isResourceUnused(resource)) {
                    this.freeResource(resource);
                }
                iter.remove();
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Pool: transactionCompleted: " + resource);
            }
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool: transactionCompleted: transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
        }
    }

    protected boolean isResourceUnused(ResourceHandle h) {
        return this.getResourceState(h).isFree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThreads() {
        Object waitMonitor = null;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                waitMonitor = this.waitQueue.removeFirst();
            }
        }
        if (waitMonitor != null) {
            linkedList = waitMonitor;
            synchronized (linkedList) {
                waitMonitor.notify();
            }
        }
    }

    public int getNumThreadWaiting() {
        return this.waitQueue.size();
    }

    public long getNumConnFailedValidation() {
        return this.poolCounters.numConnFailedValidation;
    }

    public long getNumConnTimedOut() {
        return this.poolCounters.numConnTimedOut;
    }

    public synchronized long getNumConnFree() {
        return this.poolCounters.currNumConnFree;
    }

    public long getMaxNumConnFree() {
        return this.poolCounters.maxNumConnFree;
    }

    public long getMinNumConnFree() {
        if (this.poolCounters.minNumConnFree != Long.MAX_VALUE) {
            return this.poolCounters.minNumConnFree;
        }
        return 0L;
    }

    public synchronized long getNumConnInUse() {
        return this.poolCounters.currNumConnUsed;
    }

    public long getMaxNumConnUsed() {
        return this.poolCounters.maxNumConnUsed;
    }

    public long getCurrentConnRequestWaitTime() {
        return this.poolCounters.currConnectionRequestWait;
    }

    public long getMaxConnRequestWaitTime() {
        return this.poolCounters.maxConnectionRequestWait;
    }

    public long getMinConnRequestWaitTime() {
        if (this.poolCounters.minConnectionRequestWait != Long.MAX_VALUE) {
            return this.poolCounters.minConnectionRequestWait;
        }
        return 0L;
    }

    public long getTotalConnectionRequestWaitTime() {
        return this.poolCounters.totalConnectionRequestWait;
    }

    public long getMinNumConnUsed() {
        if (this.poolCounters.minNumConnUsed != Long.MAX_VALUE) {
            return this.poolCounters.minNumConnUsed;
        }
        return 0L;
    }

    public long getNumConnCreated() {
        return this.poolCounters.numConnCreated;
    }

    public long getNumConnDestroyed() {
        return this.poolCounters.numConnDestroyed;
    }

    public long getNumConnAcquired() {
        return this.poolCounters.numConnAcquired;
    }

    public long getNumConnReleased() {
        return this.poolCounters.numConnReleased;
    }

    public long getNumConnSuccessfullyMatched() {
        return this.poolCounters.numConnSuccessfullyMatched;
    }

    public long getNumConnNotSuccessfullyMatched() {
        return this.poolCounters.numConnNotSuccessfullyMatched;
    }

    public long getNumPotentialConnLeak() {
        return this.poolCounters.numPotentialConnLeak;
    }

    private void incrementNumConnFailedValidation() {
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnFailedValidation(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resizePool(boolean forced) {
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                return;
            }
        }
        int poolSize = this.resources.size();
        this.removeInvalidAndIdleResources();
        int noOfResourcesRemoved = poolSize - this.resources.size();
        if (this.resizeQuantity > 0 && forced) {
            int moreResourcesToRemove = this.resizeQuantity - noOfResourcesRemoved;
            int n = moreResourcesToRemove = moreResourcesToRemove <= this.resources.size() - this.steadyPoolSize ? moreResourcesToRemove : 0;
            if (moreResourcesToRemove > 0) {
                Iterator<ResourceHandle> iter = this.free.iterator();
                while (iter.hasNext() && moreResourcesToRemove > 0) {
                    ResourceHandle h = iter.next();
                    this.resources.remove(h);
                    this.destroyResource(h);
                    iter.remove();
                    --moreResourcesToRemove;
                }
            }
        }
        if (this.resources.size() < this.steadyPoolSize) {
            for (int i = this.resources.size(); i < this.steadyPoolSize; ++i) {
                try {
                    this.createResourceAndAddToPool(this.allocator);
                    continue;
                }
                catch (PoolingException ex) {
                    Object[] params = new Object[]{this.resourceSpec.getConnectionPoolName(), ex.getMessage()};
                    _logger.log(Level.WARNING, "resource_pool.resize_pool_error", params);
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: " + this.name + " -- Resource held: " + this.resources.size());
        }
    }

    private void removeInvalidAndIdleResources() {
        HashSet<Object> freeManagedConnections = new HashSet<Object>();
        int size = this.free.size();
        long currentTime = System.currentTimeMillis();
        Iterator<ResourceHandle> iter = this.free.iterator();
        while (iter.hasNext()) {
            ResourceHandle element = iter.next();
            ResourceState state = this.getResourceState(element);
            if (currentTime - state.getTimestamp() > this.idletime) {
                this.resources.remove(element);
                this.destroyResource(element);
                iter.remove();
                continue;
            }
            freeManagedConnections.add(element.getResource());
        }
        this.removeInvalidResources(freeManagedConnections);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: " + this.name + " -- Idle resources freed: " + (size - freeManagedConnections.size()));
            _logger.log(Level.FINE, "Pool: " + this.name + " -- Invalid resources removed: " + (freeManagedConnections.size() - this.free.size()));
        }
    }

    private void removeInvalidResources(Set freeManagedConnections) {
        try {
            _logger.log(Level.FINE, "Sending to RA a set of free connections of size : " + freeManagedConnections.size());
            Set invalidManagedConnections = this.allocator.getInvalidConnections(freeManagedConnections);
            if (invalidManagedConnections != null) {
                _logger.log(Level.FINE, "Received from RA invalid connections : " + invalidManagedConnections.size());
                for (ManagedConnection invalidManagedConnection : invalidManagedConnections) {
                    Iterator<ResourceHandle> freeResourcesIter = this.free.iterator();
                    while (freeResourcesIter.hasNext()) {
                        ResourceHandle handle = freeResourcesIter.next();
                        if (!invalidManagedConnection.equals(handle.getResource())) continue;
                        this.resources.remove(handle);
                        this.destroyResource(handle);
                        freeResourcesIter.remove();
                        this.incrementNumConnFailedValidation();
                    }
                }
            } else {
                _logger.log(Level.FINE, "RA does not support ValidatingManagedConnectionFactory");
            }
        }
        catch (ResourceException re) {
            _logger.log(Level.FINE, "ResourceException while trying to get invalid connections from MCF", re);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Exception while trying to get invalid connections from MCF", e);
        }
    }

    private ResourceState getResourceState(ResourceHandle h) {
        return h.getResourceState();
    }

    public synchronized void emptyPool() {
        this.logFine("EmptyPool: Name = " + this.name);
        for (ResourceHandle h : this.resources) {
            this.destroyResource(h);
        }
        this.free.clear();
        this.resources.clear();
    }

    public synchronized void emptyFreeConnectionsInPool() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Emptying free connections in pool : " + this.name);
        }
        Iterator<ResourceHandle> i$ = this.free.iterator();
        while (i$.hasNext()) {
            ResourceHandle aFree;
            ResourceHandle h = aFree = i$.next();
            this.resources.remove(h);
            this.destroyResource(h);
        }
        this.free.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Pool [");
        sb.append(this.name);
        sb.append("] PoolSize=");
        sb.append(this.resources.size());
        sb.append("  FreeResources=");
        sb.append(this.free.size());
        sb.append("  QueueSize=");
        sb.append(this.waitQueue.size());
        sb.append(" matching=");
        sb.append(this.matchConnections ? "on" : "off");
        sb.append(" validation=");
        sb.append(this.validation ? "on" : "off");
        return sb.toString();
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void disableMonitoring() {
        this.monitoringEnabled = false;
    }

    public void setMonitoringEnabledHigh() {
        int numConnFree;
        this.logFine("Enabling monitoring to level : HIGH");
        int n = numConnFree = this.poolInitialized ? this.free.size() : this.steadyPoolSize;
        if (this.poolCounters == null) {
            this.poolCounters = new HighPoolCounters(numConnFree);
        }
        this.poolCounters.reset(numConnFree);
        this.monitoringEnabled = true;
    }

    public void setMonitoringEnabledLow() {
        this.logFine("Enabling monitoring to level : LOW");
        if (this.poolCounters == null) {
            this.poolCounters = new LowPoolCounters(0);
        }
        this.poolCounters.reset(0);
        this.monitoringEnabled = true;
    }

    public synchronized void reconfigPoolProperties(ConnectorConnectionPool poolResource) throws PoolingException {
        int _idleTime = Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000;
        if (this.poolInitialized) {
            if ((long)_idleTime != this.idletime && _idleTime != 0) {
                this.scheduleResizerTask();
            }
            if (_idleTime == 0) {
                this.cancelResizerTask();
            }
        }
        this.idletime = _idleTime;
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.validation = poolResource.isIsConnectionValidationRequired();
        this.failAllConnections = poolResource.isFailAllConnections();
        boolean oldConnectionLeakTracing_ = this.connectionLeakTracing_;
        this.setAdvancedPoolConfiguration(poolResource);
        if (!this.connectionLeakTracing_ && oldConnectionLeakTracing_ && this.poolInitialized) {
            this.clearAllConnectionLeakTasks();
        }
        if (!this.isSelfManaged()) {
            int toKill;
            int _maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
            this.maxPoolSize = _maxPoolSize < this.steadyPoolSize ? this.steadyPoolSize : _maxPoolSize;
            int _steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
            int oldSteadyPoolSize = this.steadyPoolSize;
            this.steadyPoolSize = _steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : _steadyPoolSize;
            if (this.poolInitialized && (toKill = this.resources.size() - this.maxPoolSize) > 0) {
                this.killExtraResources(toKill);
            }
            if (oldSteadyPoolSize != this.steadyPoolSize) {
                if (this.poolInitialized) {
                    if (oldSteadyPoolSize < this.steadyPoolSize) {
                        this.increaseSteadyPoolSize(_steadyPoolSize);
                    }
                } else if (this.monitoringEnabled) {
                    this.poolCounters.setNumConnFree(this.steadyPoolSize);
                }
            }
        }
    }

    private void setAdvancedPoolConfiguration(ConnectorConnectionPool poolResource) {
        this.matchConnections = poolResource.matchConnections();
        this.maxConnectionUsage_ = Integer.parseInt(poolResource.getMaxConnectionUsage());
        this.connectionCreationRetryAttempts_ = Integer.parseInt(poolResource.getConCreationRetryAttempts());
        this.conCreationRetryInterval_ = Integer.parseInt(poolResource.getConCreationRetryInterval()) * 1000;
        this.connectionCreationRetry_ = this.connectionCreationRetryAttempts_ > 0;
        this.validateAtmostPeriodInMilliSeconds_ = Integer.parseInt(poolResource.getValidateAtmostOncePeriod()) * 1000;
        this.connectionLeakReclaim_ = poolResource.isConnectionReclaim();
        this.connectionLeakTimeoutInMilliSeconds_ = Integer.parseInt(poolResource.getConnectionLeakTracingTimeout()) * 1000;
        this.connectionLeakTracing_ = this.connectionLeakTimeoutInMilliSeconds_ > 0L;
    }

    private void killExtraResources(int numToKill) {
        this.cancelResizerTask();
        Iterator<ResourceHandle> iter = this.free.iterator();
        for (int i = 0; iter.hasNext() && i < numToKill; ++i) {
            ResourceHandle h = iter.next();
            this.resources.remove(h);
            this.destroyResource(h);
            iter.remove();
        }
        this.scheduleResizerTask();
    }

    private void increaseSteadyPoolSize(int newSteadyPoolSize) throws PoolingException {
        this.cancelResizerTask();
        for (int i = this.resources.size(); i < newSteadyPoolSize; ++i) {
            this.createResourceAndAddToPool(this.allocator);
        }
        this.scheduleResizerTask();
    }

    private void createResourceAndAddToPool(ResourceAllocator alloc) throws PoolingException {
        ResourceHandle resourceHandle = this.createSingleResource(alloc);
        this.addResource(this.resourceSpec, resourceHandle);
        this.setResourceStateToFree(resourceHandle);
        this.free.add(resourceHandle);
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnCreated();
        }
    }

    public void switchOnMatching() {
        this.matchConnections = true;
    }

    public String getPoolName() {
        return this.name;
    }

    public synchronized void cancelResizerTask() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.finest("Cancelling resizer");
        }
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
        }
        this.resizerTask = null;
        if (this.timer != null) {
            this.timer.purge();
        }
    }

    public synchronized void dumpPoolStatus() {
        _logger.log(Level.INFO, "Name of pool :" + this.name);
        _logger.log(Level.INFO, "Free connections :" + this.free.size());
        _logger.log(Level.INFO, "Total connections :" + this.resources.size());
        _logger.log(Level.INFO, "Pool's matching is :" + this.matchConnections);
        _logger.log(Level.INFO, "Free Table is :" + this.free);
        _logger.log(Level.INFO, "Resource Table is :" + this.resources);
    }

    public PoolCounters getPoolCounters() {
        return this.poolCounters;
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPoolSize(int size) {
        if (size < this.resources.size()) {
            AbstractResourcePool abstractResourcePool = this;
            synchronized (abstractResourcePool) {
                block7: {
                    int toKill = this.resources.size() - size;
                    if (toKill > 0) {
                        try {
                            this.killExtraResources(toKill);
                        }
                        catch (Exception re) {
                            if (!_logger.isLoggable(Level.FINE)) break block7;
                            _logger.fine("setMaxPoolSize:: killExtraResources throws exception: " + re.getMessage());
                        }
                    }
                }
            }
        }
        this.maxPoolSize = size;
    }

    public void setSteadyPoolSize(int size) {
        this.steadyPoolSize = size;
    }

    public void setSelfManaged(boolean selfManaged) {
        this.logFine("Setting selfManaged to : " + selfManaged + " in pool : " + this.name);
        this.selfManaged_ = selfManaged;
    }

    protected boolean isSelfManaged() {
        return this.selfManaged_;
    }

    class HighPoolCounters
    extends LowPoolCounters {
        AtomicLongFieldUpdater currConnectionRequestWaitFieldUpdater;
        AtomicLongFieldUpdater maxConnectionRequestWaitFieldUpdater;
        AtomicLongFieldUpdater minConnectionRequestWaitFieldUpdater;
        AtomicLongFieldUpdater totalConnectionRequestWaitFieldUpdater;
        AtomicLongFieldUpdater numConnAcquiredFieldUpdater;
        AtomicLongFieldUpdater numConnTimedOutFieldUpdater;
        AtomicLongFieldUpdater numConnReleasedFieldUpdater;
        AtomicLongFieldUpdater numConnFailedValidationFieldUpdater;
        AtomicLongFieldUpdater numConnSuccessfullyMatchedFieldUpdater;
        AtomicLongFieldUpdater numConnNotSuccessfullyMatchedFieldUpdater;
        AtomicLongFieldUpdater numPotentialConnLeakFieldUpdater;

        HighPoolCounters(int freePoolSize) {
            super(freePoolSize);
            this.currConnectionRequestWaitFieldUpdater = null;
            this.maxConnectionRequestWaitFieldUpdater = null;
            this.minConnectionRequestWaitFieldUpdater = null;
            this.totalConnectionRequestWaitFieldUpdater = null;
            this.numConnAcquiredFieldUpdater = null;
            this.numConnTimedOutFieldUpdater = null;
            this.numConnReleasedFieldUpdater = null;
            this.numConnFailedValidationFieldUpdater = null;
            this.numConnSuccessfullyMatchedFieldUpdater = null;
            this.numConnNotSuccessfullyMatchedFieldUpdater = null;
            this.numPotentialConnLeakFieldUpdater = null;
            this.currConnectionRequestWaitFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "currConnectionRequestWait");
            this.maxConnectionRequestWaitFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "maxConnectionRequestWait");
            this.minConnectionRequestWaitFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "minConnectionRequestWait");
            this.totalConnectionRequestWaitFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "totalConnectionRequestWait");
            this.numConnTimedOutFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numConnTimedOut");
            this.numConnAcquiredFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numConnAcquired");
            this.numConnReleasedFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numConnReleased");
            this.numConnFailedValidationFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numConnFailedValidation");
            this.numConnSuccessfullyMatchedFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numConnSuccessfullyMatched");
            this.numConnNotSuccessfullyMatchedFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numConnNotSuccessfullyMatched");
            this.numPotentialConnLeakFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numPotentialConnLeak");
        }

        public void setWaitTime(long elapsedWaitTime) {
            this.currConnectionRequestWaitFieldUpdater.set(this, elapsedWaitTime);
            this.totalConnectionRequestWaitFieldUpdater.addAndGet(this, elapsedWaitTime);
            if (elapsedWaitTime > this.maxConnectionRequestWaitFieldUpdater.get(this)) {
                this.maxConnectionRequestWaitFieldUpdater.set(this, elapsedWaitTime);
            }
            if (elapsedWaitTime < this.minConnectionRequestWaitFieldUpdater.get(this)) {
                this.minConnectionRequestWaitFieldUpdater.set(this, elapsedWaitTime);
            }
        }

        protected void incrementNumConnAcquired() {
            this.numConnAcquiredFieldUpdater.incrementAndGet(this);
        }

        protected void incrementNumConnTimedOut() {
            this.numConnTimedOutFieldUpdater.incrementAndGet(this);
        }

        protected void incrementNumConnReleased() {
            this.numConnReleasedFieldUpdater.incrementAndGet(this);
        }

        protected void incrementNumConnFailedValidation(int incr) {
            this.numConnFailedValidationFieldUpdater.addAndGet(this, incr);
        }

        protected void incrementNumConnSuccessfullyMatched() {
            this.numConnSuccessfullyMatchedFieldUpdater.incrementAndGet(this);
        }

        protected void incrementNumConnNotSuccessfullyMatched() {
            this.numConnNotSuccessfullyMatchedFieldUpdater.incrementAndGet(this);
        }

        protected void incrementNumPotentialConnLeak() {
            this.numPotentialConnLeakFieldUpdater.incrementAndGet(this);
        }

        protected void reset(int freePoolSize) {
            super.reset(freePoolSize);
            this.numConnFailedValidationFieldUpdater.set(this, 0L);
            this.numConnTimedOutFieldUpdater.set(this, 0L);
            this.numConnAcquiredFieldUpdater.set(this, 0L);
            this.numConnReleasedFieldUpdater.set(this, 0L);
            this.currConnectionRequestWaitFieldUpdater.set(this, 0L);
            this.maxConnectionRequestWaitFieldUpdater.set(this, 0L);
            this.minConnectionRequestWaitFieldUpdater.set(this, Long.MAX_VALUE);
            this.totalConnectionRequestWaitFieldUpdater.set(this, 0L);
            this.numConnSuccessfullyMatchedFieldUpdater.set(this, 0L);
            this.numConnNotSuccessfullyMatchedFieldUpdater.set(this, 0L);
            this.numPotentialConnLeakFieldUpdater.set(this, 0L);
        }

        public String toString() {
            StringBuffer strBuffer = new StringBuffer(super.toString());
            strBuffer.append("\n numConnFailedValidation = " + this.numConnFailedValidation);
            strBuffer.append("\n numConnTimedOut = " + this.numConnTimedOut);
            strBuffer.append("\n numConnAcquired = " + this.numConnAcquired);
            strBuffer.append("\n numConnReleased = " + this.numConnReleased);
            strBuffer.append("\n currConnectionRequestWait = " + this.currConnectionRequestWait);
            strBuffer.append("\n minConnectionRequestWait = " + this.minConnectionRequestWait);
            strBuffer.append("\n maxConnectionRequestWait = " + this.maxConnectionRequestWait);
            strBuffer.append("\n totalConnectionRequestWait = " + this.totalConnectionRequestWait);
            strBuffer.append("\n numConnSuccessfullyMatched = " + this.numConnSuccessfullyMatched);
            strBuffer.append("\n numConnNotSuccessfullyMatched = " + this.numConnNotSuccessfullyMatched);
            strBuffer.append("\n numPotentialConnLeak = " + this.numPotentialConnLeak);
            return strBuffer.toString();
        }
    }

    class LowPoolCounters
    extends PoolCounters {
        AtomicLongFieldUpdater maxNumConnUsedFieldUpdater;
        AtomicLongFieldUpdater minNumConnUsedFieldUpdater;
        AtomicLongFieldUpdater currNumConnUsedFieldUpdater;
        AtomicLongFieldUpdater maxNumConnFreeFieldUpdater;
        AtomicLongFieldUpdater minNumConnFreeFieldUpdater;
        AtomicLongFieldUpdater currNumConnFreeFieldUpdater;
        AtomicLongFieldUpdater numConnCreatedFieldUpdater;
        AtomicLongFieldUpdater numConnDestroyedFieldUpdater;
        Object lock;

        LowPoolCounters(int freePoolSize) {
            super(freePoolSize);
            this.maxNumConnUsedFieldUpdater = null;
            this.minNumConnUsedFieldUpdater = null;
            this.currNumConnUsedFieldUpdater = null;
            this.maxNumConnFreeFieldUpdater = null;
            this.minNumConnFreeFieldUpdater = null;
            this.currNumConnFreeFieldUpdater = null;
            this.numConnCreatedFieldUpdater = null;
            this.numConnDestroyedFieldUpdater = null;
            this.lock = null;
            this.maxNumConnUsedFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "maxNumConnUsed");
            this.minNumConnUsedFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "minNumConnUsed");
            this.currNumConnUsedFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "currNumConnUsed");
            this.maxNumConnFreeFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "maxNumConnFree");
            this.minNumConnFreeFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "minNumConnFree");
            this.currNumConnFreeFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "currNumConnFree");
            this.numConnCreatedFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numConnCreated");
            this.numConnDestroyedFieldUpdater = AtomicLongFieldUpdater.newUpdater(this.poolCountersClass, "numConnDestroyed");
            this.lock = new Object();
        }

        protected void incrementNumConnCreated() {
            this.numConnCreatedFieldUpdater.incrementAndGet(this);
        }

        protected void incrementNumConnDestroyed() {
            this.numConnDestroyedFieldUpdater.incrementAndGet(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void incrementNumConnUsed() {
            long numConnFree;
            long numConnUsed;
            Object object = this.lock;
            synchronized (object) {
                numConnUsed = this.currNumConnUsedFieldUpdater.incrementAndGet(this);
                numConnFree = this.setNumConnFree(this.currNumConnFreeFieldUpdater.get(this) - 1L);
            }
            this.latchMaxAndMinNumConnFree(numConnFree);
            this.latchMaxAndMinNumConnUsed(numConnUsed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decrementNumConnUsed(boolean isConnectionDestroyed) {
            long numConnFree;
            long numConnUsed;
            Object object = this.lock;
            synchronized (object) {
                numConnUsed = this.currNumConnUsedFieldUpdater.decrementAndGet(this);
                if (isConnectionDestroyed) {
                    numConnFree = this.currNumConnFreeFieldUpdater.get(this);
                    if (numConnFree + numConnUsed < (long)AbstractResourcePool.this.steadyPoolSize) {
                        numConnFree = this.currNumConnFreeFieldUpdater.incrementAndGet(this);
                    }
                } else {
                    numConnFree = this.currNumConnFreeFieldUpdater.incrementAndGet(this);
                }
            }
            this.latchMaxAndMinNumConnFree(numConnFree);
            this.latchMaxAndMinNumConnUsed(numConnUsed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decrementNumConnFree() {
            long numConnFree = -1L;
            Object object = this.lock;
            synchronized (object) {
                if (this.currNumConnFreeFieldUpdater.get(this) + this.currNumConnUsedFieldUpdater.get(this) > (long)AbstractResourcePool.this.steadyPoolSize) {
                    numConnFree = this.setNumConnFree(this.currNumConnFreeFieldUpdater.get(this) - 1L);
                }
            }
            this.latchMaxAndMinNumConnFree(numConnFree);
        }

        protected long setNumConnFree(long numConnFree) {
            long numConnFreeToSet = numConnFree >= 0L ? numConnFree : 0L;
            this.currNumConnFreeFieldUpdater.set(this, numConnFreeToSet);
            return numConnFreeToSet;
        }

        private void latchMaxAndMinNumConnUsed(long numConnInUse) {
            if (numConnInUse > this.maxNumConnUsedFieldUpdater.get(this)) {
                this.maxNumConnUsedFieldUpdater.set(this, numConnInUse);
            }
            if (numConnInUse < this.minNumConnUsedFieldUpdater.get(this)) {
                if (numConnInUse <= 0L) {
                    this.minNumConnUsedFieldUpdater.set(this, 0L);
                } else {
                    this.minNumConnUsedFieldUpdater.set(this, numConnInUse);
                }
            }
        }

        private void latchMaxAndMinNumConnFree(long numConnFree) {
            if (numConnFree > this.maxNumConnFreeFieldUpdater.get(this)) {
                this.maxNumConnFreeFieldUpdater.set(this, numConnFree);
            }
            if (numConnFree < this.minNumConnFreeFieldUpdater.get(this)) {
                if (numConnFree <= 0L) {
                    this.minNumConnFreeFieldUpdater.set(this, 0L);
                } else {
                    this.minNumConnFreeFieldUpdater.set(this, numConnFree);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset(int freePoolSize) {
            super.reset(freePoolSize);
            Object object = this.lock;
            synchronized (object) {
                this.maxNumConnUsedFieldUpdater.set(this, 0L);
                this.minNumConnUsedFieldUpdater.set(this, Long.MAX_VALUE);
                this.currNumConnUsedFieldUpdater.set(this, 0L);
                this.maxNumConnFreeFieldUpdater.set(this, 0L);
                this.minNumConnFreeFieldUpdater.set(this, Long.MAX_VALUE);
                this.currNumConnFreeFieldUpdater.set(this, freePoolSize);
            }
            this.numConnCreatedFieldUpdater.set(this, 0L);
            this.numConnDestroyedFieldUpdater.set(this, 0L);
        }

        public String toString() {
            StringBuffer strBuffer = new StringBuffer(super.toString());
            strBuffer.append("\n maxNumConnUsed = " + this.maxNumConnUsed);
            strBuffer.append("\n minNumConnUsed = " + this.minNumConnUsed);
            strBuffer.append("\n currNumConnUsed = " + this.currNumConnUsed);
            strBuffer.append("\n maxNumConnFree =  = " + this.maxNumConnFree);
            strBuffer.append("\n minNumConnFree = " + this.minNumConnFree);
            strBuffer.append("\n currNumConnFree = " + this.currNumConnFree);
            strBuffer.append("\n numConnCreated = " + this.numConnCreated);
            strBuffer.append("\n numConnDestroyed = " + this.numConnDestroyed);
            return strBuffer.toString();
        }
    }

    class PoolCounters {
        volatile long maxNumConnUsed = 0L;
        volatile long minNumConnUsed = Long.MAX_VALUE;
        volatile long currNumConnUsed = 0L;
        volatile long maxNumConnFree = 0L;
        volatile long minNumConnFree = Long.MAX_VALUE;
        volatile long currNumConnFree = 0L;
        volatile long numConnCreated = 0L;
        volatile long numConnDestroyed = 0L;
        volatile long numConnFailedValidation = 0L;
        volatile long numConnTimedOut = 0L;
        volatile long numConnAcquired = 0L;
        volatile long numConnReleased = 0L;
        volatile long currConnectionRequestWait = 0L;
        volatile long maxConnectionRequestWait = 0L;
        volatile long minConnectionRequestWait = Long.MAX_VALUE;
        volatile long totalConnectionRequestWait = 0L;
        volatile long numConnSuccessfullyMatched = 0L;
        volatile long numConnNotSuccessfullyMatched = 0L;
        volatile long numPotentialConnLeak = 0L;
        Class poolCountersClass = this.getClass();

        PoolCounters(int freePoolSize) {
            while (!this.poolCountersClass.equals(PoolCounters.class)) {
                this.poolCountersClass = this.poolCountersClass.getSuperclass();
            }
        }

        protected void setWaitTime(long elapsedWaitTime) {
        }

        protected void incrementNumConnUsed() {
        }

        protected void decrementNumConnUsed(boolean isConnectionDestroyed) {
        }

        protected void decrementNumConnFree() {
        }

        protected void incrementNumConnCreated() {
        }

        protected void incrementNumConnDestroyed() {
        }

        protected void incrementNumConnMatched() {
        }

        protected void incrementNumConnNotMatched() {
        }

        protected void incrementNumConnAcquired() {
        }

        protected void incrementNumConnTimedOut() {
        }

        protected void incrementNumConnReleased() {
        }

        protected void incrementNumConnFailedValidation(int incr) {
        }

        protected void incrementNumConnSuccessfullyMatched() {
        }

        protected void incrementNumConnNotSuccessfullyMatched() {
        }

        protected void incrementNumPotentialConnLeak() {
        }

        protected void reset(int freePoolSize) {
        }

        protected long setNumConnFree(long numConnFree) {
            return numConnFree;
        }

        public String toString() {
            return "PoolCounters: ";
        }
    }

    class ConnectionLeakTask
    extends TimerTask {
        ResourceHandle resourceHandle;

        ConnectionLeakTask(ResourceHandle resourceHandle) {
            this.resourceHandle = resourceHandle;
        }

        public void run() {
            AbstractResourcePool.this.potentialConnectionLeakFound(this.resourceHandle);
        }
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        public void run() {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "AbstractResourcePool: resize pool " + AbstractResourcePool.this.name);
            }
            AbstractResourcePool.this.resizePool(true);
        }
    }
}

