/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;

public class JdbcConnectionPoolDeployer
implements ResourceDeployer {
    private static StringManager sm = StringManager.getManager(JdbcConnectionPoolDeployer.class);
    private static String msg = sm.getString("resource.restart_needed");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - deployResource : " + resource + " calling actualDeploy");
        this.actualDeployResource(resource);
    }

    public synchronized void actualDeployResource(Object resource) {
        _logger.fine(" JdbcConnectionPoolDeployer - actualDeployResource : " + resource);
        JdbcConnectionPool adminPool = (JdbcConnectionPool)resource;
        ConnectorConnectionPool connConnPool = this.createConnectorConnectionPool(adminPool);
        try {
            ConnectorRuntime.getRuntime().createConnectorConnectionPool(connConnPool);
        }
        catch (ConnectorRuntimeException cre) {
            cre.printStackTrace();
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - unDeployResource : calling actualUndeploy of " + resource);
        this.actualUndeployResource(resource);
    }

    public synchronized void actualUndeployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - unDeployResource : " + resource);
        JdbcConnectionPool jdbcConnPool = (JdbcConnectionPool)resource;
        String poolName = jdbcConnPool.getName();
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        runtime.deleteConnectorConnectionPool(poolName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Pool Undeployed");
        }
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        JdbcConnectionPool adminPool = (JdbcConnectionPool)resource;
        if (!ConnectorRuntime.getRuntime().isConnectorConnectionPoolDeployed(adminPool.getName())) {
            _logger.fine("The JDBC connection pool " + adminPool.getName() + " is not referred or not yet created in this server " + "instance and hence pool redeployment is ignored");
            return;
        }
        ConnectorConnectionPool connConnPool = this.createConnectorConnectionPool(adminPool);
        if (connConnPool == null) {
            throw new ConnectorRuntimeException("Unable to create ConnectorConnectionPoolfrom JDBC connection pool");
        }
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("TransactionIsolation");
        excludes.add("GuaranteeIsolationLevel");
        excludes.add("ValidationTableName");
        excludes.add("ConnectionValidationRequired");
        excludes.add("ValidationMethod");
        excludes.add("StatementWrapping");
        excludes.add("StatementTimeout");
        try {
            _logger.finest("Calling reconfigure pool");
            boolean poolRecreateRequired = runtime.reconfigureConnectorConnectionPool(connConnPool, excludes);
            if (poolRecreateRequired) {
                _logger.finest("Pool recreation required");
                runtime.recreateConnectorConnectionPool(connConnPool);
                _logger.finest("Pool recreation done");
            }
        }
        catch (ConnectorRuntimeException cre) {
            cre.printStackTrace();
            throw cre;
        }
    }

    public synchronized void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException(msg);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException(msg);
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        JdbcConnectionPool res = rbeans.getJdbcConnectionPoolByName(name);
        if (res == null) {
            String msg = sm.getString("resource.no_resource", name);
            throw new Exception(msg);
        }
        return res;
    }

    private ConnectorDescriptor createConnectorDescriptor(String moduleDir) {
        ConnectorDescriptor connectorDescriptor = null;
        FileArchive fa = new FileArchive();
        try {
            fa.open(moduleDir);
            ConnectorArchivist archivist = new ConnectorArchivist();
            connectorDescriptor = (ConnectorDescriptor)archivist.open(fa);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        return connectorDescriptor;
    }

    private EnvironmentProperty[] getMCFConfigProperties(JdbcConnectionPool adminPool, ConnectorConnectionPool conConnPool, ConnectorDescriptor connDesc) {
        ArrayList<EnvironmentProperty> propList = new ArrayList<EnvironmentProperty>();
        propList.add(new EnvironmentProperty("ClassName", adminPool.getDatasourceClassname() == null ? "" : adminPool.getDatasourceClassname(), "The datasource class name", "java.lang.String"));
        propList.add(new EnvironmentProperty("ConnectionValidationRequired", adminPool.isIsConnectionValidationRequired() + "", "Is connection validation required", "java.lang.String"));
        propList.add(new EnvironmentProperty("ValidationMethod", adminPool.getConnectionValidationMethod() == null ? "" : adminPool.getConnectionValidationMethod(), "How the connection is validated", "java.lang.String"));
        propList.add(new EnvironmentProperty("ValidationTableName", adminPool.getValidationTableName() == null ? "" : adminPool.getValidationTableName(), "Validation Table name", "java.lang.String"));
        propList.add(new EnvironmentProperty("TransactionIsolation", adminPool.getTransactionIsolationLevel() == null ? "" : adminPool.getTransactionIsolationLevel(), "Transaction Isolatin Level", "java.lang.String"));
        propList.add(new EnvironmentProperty("GuaranteeIsolationLevel", adminPool.isIsIsolationLevelGuaranteed() + "", "Transaction Isolation Guarantee", "java.lang.String"));
        propList.add(new EnvironmentProperty("StatementWrapping", adminPool.isWrapJdbcObjects() + "", "Statement Wrapping", "java.lang.String"));
        propList.add(new EnvironmentProperty("StatementTimeout", adminPool.getStatementTimeoutInSeconds() + "", "Statement Timeout", "java.lang.String"));
        Set connDefDescSet = connDesc.getOutboundResourceAdapter().getConnectionDefs();
        if (connDefDescSet.size() != 1) {
            throw new MissingResourceException("Only one connDefDesc present", null, null);
        }
        Iterator iter = connDefDescSet.iterator();
        Set mcfConfigProps = null;
        while (iter.hasNext()) {
            mcfConfigProps = ((ConnectionDefDescriptor)iter.next()).getConfigProperties();
        }
        if (mcfConfigProps != null) {
            HashMap<String, String> mcfConPropKeys = new HashMap<String, String>();
            Iterator mcfConfigPropsIter = mcfConfigProps.iterator();
            while (mcfConfigPropsIter.hasNext()) {
                String key = ((EnvironmentProperty)mcfConfigPropsIter.next()).getName();
                mcfConPropKeys.put(key.toUpperCase(), key);
            }
            String driverProperties = "";
            for (ElementProperty rp : adminPool.getElementProperty()) {
                if (rp == null) continue;
                String name = rp.getName();
                if ("MATCHCONNECTIONS".equals(name.toUpperCase())) {
                    conConnPool.setMatchConnections(this.toBoolean(rp.getValue(), false));
                    this.logFine("MATCHCONNECTIONS");
                    continue;
                }
                if ("LAZYCONNECTIONASSOCIATION".equals(name.toUpperCase())) {
                    ConnectionPoolObjectsUtils.setLazyEnlistAndLazyAssocProperties(rp.getValue(), adminPool, conConnPool);
                    this.logFine("LAZYCONNECTIONASSOCIATION");
                    continue;
                }
                if ("LAZYCONNECTIONENLISTMENT".equals(name.toUpperCase())) {
                    conConnPool.setLazyConnectionEnlist(this.toBoolean(rp.getValue(), false));
                    this.logFine("LAZYCONNECTIONENLISTMENT");
                    continue;
                }
                if ("ASSOCIATEWITHTHREAD".equals(name.toUpperCase())) {
                    conConnPool.setAssociateWithThread(this.toBoolean(rp.getValue(), false));
                    this.logFine("ASSOCIATEWITHTHREAD");
                    continue;
                }
                if ("USERNAME".equals(name.toUpperCase()) || "USER".equals(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty("User", rp.getValue(), "user name", "java.lang.String"));
                    continue;
                }
                if ("PASSWORD".equals(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty("Password", rp.getValue(), "Password", "java.lang.String"));
                    continue;
                }
                if ("JDBC30DATASOURCE".equals(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty("JDBC30DataSource", rp.getValue(), "JDBC30DataSource", "java.lang.String"));
                    continue;
                }
                if (mcfConPropKeys.containsKey(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty((String)mcfConPropKeys.get(name.toUpperCase()), rp.getValue() == null ? "" : rp.getValue(), "Some property", "java.lang.String"));
                    continue;
                }
                driverProperties = driverProperties + "set" + this.escape(name) + "#" + this.escape(rp.getValue()) + "##";
            }
            if (!driverProperties.equals("")) {
                propList.add(new EnvironmentProperty("DriverProperties", driverProperties, "some proprietarty properties", "java.lang.String"));
            }
        }
        propList.add(new EnvironmentProperty("Delimiter", "#", "delim", "java.lang.String"));
        propList.add(new EnvironmentProperty("EscapeCharacter", "\\", "escapeCharacter", "java.lang.String"));
        EnvironmentProperty[] eProps = new EnvironmentProperty[propList.size()];
        ListIterator propListIter = propList.listIterator();
        int i = 0;
        while (propListIter.hasNext()) {
            eProps[i] = (EnvironmentProperty)propListIter.next();
            ++i;
        }
        return eProps;
    }

    private String escape(String value) {
        String seq = "\\";
        String replacement = "\\\\";
        value = value.replace(seq, replacement);
        seq = "#";
        replacement = "\\#";
        value = value.replace(seq, replacement);
        return value;
    }

    private String getSystemModuleLocation(String moduleName) {
        String j2eeModuleDirName = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + moduleName;
        return j2eeModuleDirName;
    }

    private boolean toBoolean(Object prop, boolean defaultVal) {
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf(((String)prop).toLowerCase());
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE) && msg != null) {
            _logger.fine(msg);
        }
    }

    public ConnectorConnectionPool createConnectorConnectionPool(JdbcConnectionPool adminPool) {
        String moduleName = this.getModuleName(adminPool);
        String moduleDir = this.getSystemModuleLocation(moduleName);
        int txSupport = this.getTxSupport(moduleName);
        ConnectorDescriptor connDesc = this.createConnectorDescriptor(moduleDir);
        ConnectorConnectionPool conConnPool = new ConnectorConnectionPool(adminPool.getName());
        conConnPool.setTransactionSupport(txSupport);
        this.setConnectorConnectionPoolAttributes(conConnPool, adminPool);
        ConnectorDescriptorInfo connDescInfo = this.createConnectorDescriptorInfo(connDesc, moduleName);
        connDescInfo.setMCFConfigProperties(this.getMCFConfigProperties(adminPool, conConnPool, connDesc));
        connDescInfo.setResourceAdapterConfigProperties((Set)null);
        conConnPool.setConnectorDescriptorInfo(connDescInfo);
        return conConnPool;
    }

    private String getModuleName(JdbcConnectionPool jcp) {
        Class dsClass;
        String resType = jcp.getResType();
        String dsClassName = jcp.getDatasourceClassname();
        String moduleName = "__ds";
        if (resType == null) {
            return moduleName;
        }
        if ("javax.sql.XADataSource".equals(resType) && dsClassName != null) {
            try {
                dsClass = Utility.loadClass(dsClassName);
                if (XADataSource.class.isAssignableFrom(dsClass)) {
                    return "__xa";
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ("javax.sql.ConnectionPoolDataSource".equals(resType) && dsClassName != null) {
            try {
                dsClass = Utility.loadClass(dsClassName);
                if (ConnectionPoolDataSource.class.isAssignableFrom(dsClass)) {
                    return "__cp";
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return moduleName;
    }

    private int getTxSupport(String moduleName) {
        if ("__xa".equals(moduleName)) {
            return ConnectionPoolObjectsUtils.parseTransactionSupportString("XATransaction");
        }
        return ConnectionPoolObjectsUtils.parseTransactionSupportString("LocalTransaction");
    }

    private ConnectorDescriptorInfo createConnectorDescriptorInfo(ConnectorDescriptor connDesc, String moduleName) {
        ConnectorDescriptorInfo connDescInfo = new ConnectorDescriptorInfo();
        connDescInfo.setManagedConnectionFactoryClass(connDesc.getOutboundResourceAdapter().getManagedConnectionFactoryImpl());
        connDescInfo.setRarName(moduleName);
        connDescInfo.setResourceAdapterClassName(connDesc.getResourceAdapterClass());
        connDescInfo.setConnectionDefinitionName(connDesc.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connDescInfo.setConnectionFactoryClass(connDesc.getOutboundResourceAdapter().getConnectionFactoryImpl());
        connDescInfo.setConnectionFactoryInterface(connDesc.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connDescInfo.setConnectionClass(connDesc.getOutboundResourceAdapter().getConnectionImpl());
        connDescInfo.setConnectionInterface(connDesc.getOutboundResourceAdapter().getConnectionIntf());
        return connDescInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setConnectorConnectionPoolAttributes(ConnectorConnectionPool ccp, JdbcConnectionPool adminPool) {
        ccp.setMaxPoolSize(adminPool.getMaxPoolSize() != null ? adminPool.getMaxPoolSize() : JdbcConnectionPool.getDefaultMaxPoolSize());
        ccp.setSteadyPoolSize(adminPool.getSteadyPoolSize() != null ? adminPool.getSteadyPoolSize() : JdbcConnectionPool.getDefaultSteadyPoolSize());
        ccp.setMaxWaitTimeInMillis(adminPool.getMaxWaitTimeInMillis() != null ? adminPool.getMaxWaitTimeInMillis() : JdbcConnectionPool.getDefaultMaxWaitTimeInMillis());
        ccp.setPoolResizeQuantity(adminPool.getPoolResizeQuantity() != null ? adminPool.getPoolResizeQuantity() : JdbcConnectionPool.getDefaultPoolResizeQuantity());
        ccp.setIdleTimeoutInSeconds(adminPool.getIdleTimeoutInSeconds() != null ? adminPool.getIdleTimeoutInSeconds() : JdbcConnectionPool.getDefaultIdleTimeoutInSeconds());
        ccp.setFailAllConnections(adminPool.isFailAllConnections());
        ccp.setConnectionValidationRequired(adminPool.isIsConnectionValidationRequired());
        ccp.setNonTransactional(adminPool.isNonTransactionalConnections());
        ccp.setNonComponent(adminPool.isAllowNonComponentCallers());
        ccp.setMatchConnections(adminPool.isMatchConnections());
        ccp.setAssociateWithThread(adminPool.isAssociateWithThread());
        ccp.setConnectionLeakTracingTimeout(adminPool.getConnectionLeakTimeoutInSeconds());
        ccp.setConnectionReclaim(adminPool.isConnectionLeakReclaim());
        boolean lazyConnectionEnlistment = adminPool.isLazyConnectionEnlistment();
        boolean lazyConnectionAssociation = adminPool.isLazyConnectionAssociation();
        if (lazyConnectionAssociation) {
            if (!lazyConnectionEnlistment) {
                _logger.log(Level.SEVERE, "conn_pool_obj_utils.lazy_enlist-lazy_assoc-invalid-combination", adminPool.getName());
                String i18nMsg = sm.getString("cpou.lazy_enlist-lazy_assoc-invalid-combination", adminPool.getName());
                throw new RuntimeException(i18nMsg);
            }
            ccp.setLazyConnectionAssoc(true);
            ccp.setLazyConnectionEnlist(true);
        } else {
            ccp.setLazyConnectionAssoc(lazyConnectionAssociation);
            ccp.setLazyConnectionEnlist(lazyConnectionEnlistment);
        }
        ccp.setMaxConnectionUsage(adminPool.getMaxConnectionUsageCount());
        ccp.setConCreationRetryAttempts(adminPool.getConnectionCreationRetryAttempts());
        ccp.setConCreationRetryInterval(adminPool.getConnectionCreationRetryIntervalInSeconds());
        ccp.setValidateAtmostOncePeriod(adminPool.getValidateAtmostOncePeriodInSeconds());
    }
}

