/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.gui;

import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.gui.ControlPanel;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.tools.verifier.gui.ResultsPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.logging.LogRecord;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MainPanel
extends JPanel
implements Runnable {
    static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    ResultsPanel resultsPanel = new ResultsPanel();
    ControlPanel verifierControls;
    JLabel statusLabel = new JLabel(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Idle", "Idle"));
    Verifier verifier;
    Enumeration components;
    Thread running = null;

    public MainPanel(JFrame parent) {
        this(parent, null, null);
    }

    public MainPanel(JFrame parent, String jarFileName, Verifier verifier) {
        super(new BorderLayout(), true);
        this.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.panelName", "Panel"));
        this.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.PanelDesc", "This is a panel"));
        this.statusLabel.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.labelName", "Label"));
        this.statusLabel.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.labelDesc", "This is a label"));
        this.verifierControls = new ControlPanel(parent);
        this.setJarFilename(jarFileName);
        this.verifier = verifier;
        this.add("North", this.verifierControls);
        this.add("Center", this.resultsPanel);
        this.add("South", this.statusLabel);
        this.verifierControls.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainPanel.this.getFileList().hasMoreElements()) {
                    MainPanel.this.resultsPanel.clearOldResults();
                    MainPanel.this.start();
                } else {
                    JOptionPane.showMessageDialog(MainPanel.this.verifierControls, smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.optionPane.okButtonNoFiles", "You must first select file to verify.") + "\n" + smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.optionPane.okButtonNoFiles2", "Use the Add button to select file to be verified, then click on OK button."));
                }
            }
        });
        this.verifierControls.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainFrame.getExitOnClose()) {
                    System.exit(0);
                } else {
                    MainPanel.this.stop();
                    MainPanel.this.enableOK();
                    MainPanel.this.enableClose();
                    MainPanel.this.reset();
                    try {
                        Class<?> cls = Class.forName("javax.swing.JFrame");
                        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(cls, MainPanel.this.resultsPanel);
                        frame.setVisible(false);
                    }
                    catch (ClassNotFoundException ex) {
                        ex.getMessage();
                    }
                }
            }
        });
    }

    public ControlPanel getVerifierControlPanel() {
        return this.verifierControls;
    }

    public void setJarFilename(String jarFileName) {
        File jarFile;
        if (jarFileName != null && (jarFile = new File(jarFileName)).exists()) {
            this.getVerifierControlPanel().addJarFile(jarFile);
        }
    }

    private Verifier getVerifier() {
        return this.verifier;
    }

    public void reset() {
        this.resultsPanel.clearOldResults();
        this.resultsPanel.clearResults();
        this.verifierControls.removeAllJarFiles();
    }

    public void setStatus(String stat) {
        this.statusLabel.setText(stat);
    }

    public Enumeration getFileList() {
        return this.verifierControls.listModel.elements();
    }

    public void clearResults() {
        this.resultsPanel.clearResults();
    }

    void disableOK() {
        this.verifierControls.okButton.setEnabled(false);
    }

    void enableOK() {
        this.verifierControls.okButton.setEnabled(true);
    }

    void disableClose() {
        this.verifierControls.closeButton.setEnabled(false);
    }

    void enableClose() {
        this.verifierControls.closeButton.setEnabled(true);
    }

    public void start() {
        if (this.running == null) {
            this.components = this.getFileList();
            this.clearResults();
            this.running = new Thread(this);
            this.running.setPriority(1);
            this.running.start();
        }
    }

    public void stop() {
        if (this.running != null) {
            this.running = null;
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Closed", "Closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.disableOK();
            while (this.components.hasMoreElements() && this.running != null) {
                File jarFile = (File)this.components.nextElement();
                String jarName = jarFile.getPath();
                try {
                    this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Verifying", "Verifying archive {0}...", new Object[]{jarName}));
                    ResultManager resultManager = this.getVerifier().verify(jarName);
                    for (LogRecord log : resultManager.getError()) {
                        log.setLoggerName(jarFile.getName());
                        this.resultsPanel.addError(log);
                    }
                    this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_WritingReport", "Writing report..."));
                    this.verifier.generateReports();
                    if (resultManager.getFailedCount() + resultManager.getErrorCount() == 0) {
                        this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.AllTestsPassed", "{0}: All tests passed.", new Object[]{jarFile.getName()}) + "\n");
                        continue;
                    }
                    this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.SomeTestsFailed", "{0}: Some tests failed.", new Object[]{jarFile.getName()}) + "\n");
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(this, smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoading", "Error verifying {0}: {1}", new Object[]{jarName, t.getMessage()}));
                    this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoading", "Error verifying {0}: {1}", new Object[]{jarName, t.getMessage()}) + "\n");
                }
            }
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Idle", "Idle"));
            this.enableOK();
            this.enableClose();
        }
        finally {
            this.running = null;
        }
    }
}

