/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.ejbcreatemethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.lang.reflect.Method;

public class EjbCreateMethodArgs
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean remote_exists = false;
        if (descriptor instanceof EjbSessionDescriptor) {
            boolean oneFailed = false;
            try {
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> c = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                boolean ejbCreateFound = false;
                boolean isLegalRMIIIOP = false;
                int foundAtLeastOne = 0;
                if (descriptor.getHomeClassName() == null || descriptor.getHomeClassName().equals("")) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.localinterfaceonly.notapp", "Not Applicable because, EJB [ {0} ] has Local Interfaces only.", new Object[]{descriptor.getEjbClassName()}));
                    return result;
                }
                if (descriptor.getRemoteClassName() != null && !descriptor.getRemoteClassName().equals("")) {
                    remote_exists = true;
                }
                do {
                    Method[] methods = c.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        ejbCreateFound = false;
                        isLegalRMIIIOP = false;
                        if (!methods[i].getName().startsWith("ejbCreate")) continue;
                        ++foundAtLeastOne;
                        ejbCreateFound = true;
                        if (remote_exists) {
                            Class[] ejbCreateMethodParameterTypes = methods[i].getParameterTypes();
                            if (RmiIIOPUtils.isValidRmiIIOPParameters(ejbCreateMethodParameterTypes)) {
                                isLegalRMIIIOP = true;
                            }
                        } else {
                            isLegalRMIIIOP = true;
                        }
                        if (ejbCreateFound && isLegalRMIIIOP) {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly declares [ {1} ] method with valid RMI-IIOP argument types.", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                            continue;
                        }
                        if (!ejbCreateFound || isLegalRMIIIOP) continue;
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: An [ {0} ] method was found, but [ {1} ] method has illegal parameter values.   [ {2} ] methods arguments types must be legal types for RMI-IIOP.", new Object[]{methods[i].getName(), methods[i].getName(), methods[i].getName()}));
                    }
                } while ((c = c.getSuperclass()) != null && foundAtLeastOne == 0);
                if (foundAtLeastOne == 0) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: [ {0} ] does not properly declare at least one ejbCreate(...) method.  [ {1} ] is not a valid bean.", new Object[]{descriptor.getEjbClassName(), descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
                oneFailed = true;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

