/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Set;

public class ServletClassDeclared
extends WebTest
implements WebCheck {
    final String servletClassPath = "WEB-INF/classes";

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (this.getVerifierContext().getJavaEEVersion().compareTo("5") >= 0) {
            result.setStatus(3);
            return result;
        }
        boolean oneWarning = false;
        boolean foundOne = false;
        result = this.loadWarFile(descriptor);
        FileArchive arch = null;
        Enumeration entries = null;
        try {
            String uri = this.getAbstractArchiveUri(descriptor);
            arch = new FileArchive();
            arch.open(uri);
            entries = arch.entries();
        }
        catch (Exception e) {
            e.printStackTrace();
            result.failed(smh.getLocalString(this.getClass().getName() + ".exception", "IOException while loading the war file [ {0} ]", new Object[]{descriptor.getName()}));
            return result;
        }
        while (entries.hasMoreElements()) {
            Object entry = entries.nextElement();
            String name = (String)entry;
            if (!name.startsWith("WEB-INF/classes") || !name.endsWith(".class")) continue;
            String classEntryName = name.substring(0, name.length() - ".class".length());
            String className = (classEntryName = classEntryName.substring("WEB-INF/classes".length() + 1, classEntryName.length())).replace('/', '.');
            Class servletClass = this.loadClass(result, className);
            if (Modifier.isAbstract(servletClass.getModifiers()) || !ServletClassDeclared.isImplementorOf(servletClass, "javax.servlet.Servlet")) continue;
            foundOne = true;
            Set servlets = descriptor.getServletDescriptors();
            boolean foundDD = false;
            for (WebComponentDescriptor servlet : servlets) {
                String servletClassName = servlet.getWebComponentImplementation();
                if (!servletClassName.equals(className)) continue;
                foundDD = true;
                break;
            }
            if (foundDD) {
                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Servlet class [ {0} ] found in war file is defined in the Deployement Descriptors", new Object[]{className}));
                continue;
            }
            oneWarning = true;
            result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning", "Servlet class [ {0} ] found in war file is not defined in the Deployement Descriptors", new Object[]{className}));
        }
        if (!foundOne) {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no servlet implementation within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        } else if (oneWarning) {
            result.setStatus(2);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

