/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.TagLibTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.web.FunctionDescriptor;

public class TaglibFunctionSignatureIsValid
extends TagLibTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        Result result = this.getInitializedResult();
        Context context = this.getVerifierContext();
        TagLibDescriptor[] tlds = context.getTagLibDescriptors();
        FunctionDescriptor[] fnDesc = null;
        if (tlds == null) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "No tag lib files are specified"));
            return result;
        }
        for (TagLibDescriptor tld : tlds) {
            if (tld.getSpecVersion().compareTo("2.0") < 0 || (fnDesc = tld.getFunctionDescriptors()) == null) continue;
            for (FunctionDescriptor fd : fnDesc) {
                this.checkSignature(result, fd, tld, compName);
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "function-signature element of the tag lib descriptor are properly defined."));
        }
        return result;
    }

    private void checkSignature(Result result, FunctionDescriptor fnDesc, TagLibDescriptor tld, ComponentNameConstructor compName) {
        String signature = fnDesc.getFunctionSignature();
        ClassLoader cl = this.getVerifierContext().getClassLoader();
        String retType = this.getRetType(signature);
        String[] parameter = this.getParameters(signature);
        if (this.checkIfPrimitive(retType) == null && !this.checkValidRType(retType)) {
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "ERROR: In the tld [ {0} ] return type is not specified correctly in this signature [ {1} ]", new Object[]{tld.getUri(), signature}));
        }
        if (!this.checkParamTypeClass(parameter, cl)) {
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "ERROR: In the tld [ {0} ] parameters are not specified correctly in this signature [ {1} ]", new Object[]{tld.getUri(), signature}));
        }
    }

    private boolean checkValidRType(String retType) {
        boolean valid = true;
        try {
            Class.forName(retType);
        }
        catch (ClassNotFoundException e) {
            valid = false;
            return false;
        }
        return valid;
    }

    private boolean checkParamTypeClass(String[] par, ClassLoader cl) {
        for (String s : par) {
            Class<?> c = this.checkIfPrimitive(s);
            if (c != null) continue;
            try {
                c = Class.forName(s, false, cl);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }
}

