/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.JarEntrySource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JarAccess {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final char SEPARATOR = File.separatorChar;
    private File jarName;
    private File dirName;
    private String beanName;
    private String[] fileNames;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JarAccess.class);

    public static void create(OutputStream out, File baseDir, String[] ejbNames, String[] files) throws IOException {
        int start = 0;
        if (ejbNames != null) {
            start = 1;
        }
        JarEntrySource[] data = new JarEntrySource[files.length + start];
        if (ejbNames != null) {
            data[0] = JarAccess.makeManifestEntry(ejbNames);
        }
        for (int i = 0; i < files.length; ++i) {
            data[i + start] = new JarEntrySource(JarAccess.entryName(files[i]), new File(baseDir, files[i]));
        }
        JarAccess.create(out, data);
    }

    public static JarEntrySource makeManifestEntry(String[] ejbNames) {
        StringBuffer s = new StringBuffer("Manifest-Version: 1.0\n");
        s.append("\n");
        for (int i = 0; i < ejbNames.length; ++i) {
            s.append("Name: " + ejbNames[i] + "\n");
            s.append("Enterprise-Bean: True\n");
            s.append("\n");
        }
        return new JarEntrySource(MANIFEST, new ByteArrayInputStream(s.toString().getBytes()));
    }

    public static void create(OutputStream out, String[] files) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out);
        for (int i = 0; i < files.length; ++i) {
            JarAccess.addEntry(zos, new JarEntrySource(new File(files[i])));
        }
        zos.close();
    }

    public static void create(OutputStream out, JarEntrySource[] entries) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out);
        for (int i = 0; i < entries.length; ++i) {
            try {
                JarAccess.addEntry(zos, entries[i]);
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_jaraccess_create", ex);
                throw new IOException("Invalid JAR entry: " + entries[i].getName());
            }
        }
        zos.close();
    }

    private static String entryName(String name) {
        if ((name = name.replace(File.separatorChar, '/')).startsWith("/")) {
            name = name.substring(1);
        } else if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }

    static void addEntry(ZipOutputStream zos, JarEntrySource source) throws IOException {
        String name = source.getName();
        if (name.equals("") || name.equals(".")) {
            return;
        }
        ZipEntry e = new ZipEntry(name);
        e.setTime(source.getTime());
        boolean markOnly = source.isMarkOnly();
        if (markOnly) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!markOnly) {
            byte[] buf = new byte[1024];
            int len = 0;
            BufferedInputStream is = new BufferedInputStream(source.getInputStream());
            while (len != -1) {
                try {
                    len = ((InputStream)is).read(buf, 0, buf.length);
                }
                catch (EOFException eof) {
                    break;
                }
                if (len == -1) continue;
                zos.write(buf, 0, len);
            }
            ((InputStream)is).close();
        }
        zos.closeEntry();
    }

    public static void extract(InputStream in, String[] files) throws IOException {
        ZipEntry e;
        ZipInputStream zis = new ZipInputStream(in);
        block0: while ((e = zis.getNextEntry()) != null) {
            if (files == null) {
                JarAccess.extractFile(zis, e);
                continue;
            }
            String name = e.getName().replace('/', File.separatorChar);
            for (int i = 0; i < files.length; ++i) {
                if (!name.startsWith(files[i])) continue;
                JarAccess.extractFile(zis, e);
                continue block0;
            }
        }
    }

    private static void extractFile(ZipInputStream zis, ZipEntry e) throws IOException {
        File f = new File(e.getName().replace('/', File.separatorChar));
        if (e.isDirectory()) {
            if (!f.exists() && !f.mkdirs() || !f.isDirectory()) {
                throw new IOException(f + ": could not create directory");
            }
        } else {
            int len;
            File d;
            if (!(f.getParent() == null || ((d = new File(f.getParent())).exists() || d.mkdirs()) && d.isDirectory())) {
                throw new IOException(d + ": could not create directory");
            }
            FileOutputStream os = new FileOutputStream(f);
            byte[] b = new byte[512];
            while ((len = zis.read(b, 0, b.length)) != -1) {
                ((OutputStream)os).write(b, 0, len);
            }
            zis.closeEntry();
            ((OutputStream)os).close();
        }
    }

    public static Vector extract(InputStream in, String[] files, String directory) throws IOException {
        ZipEntry e;
        Vector<File> extractedFiles = new Vector<File>();
        ZipInputStream zis = new ZipInputStream(in);
        block0: while ((e = zis.getNextEntry()) != null) {
            if (files == null) {
                File extractedFile = JarAccess.extractFile(zis, e, directory);
                extractedFiles.addElement(extractedFile);
                continue;
            }
            String name = e.getName().replace('/', File.separatorChar);
            for (int i = 0; i < files.length; ++i) {
                if (!name.startsWith(files[i])) continue;
                File extractedFile = JarAccess.extractFile(zis, e, directory);
                extractedFiles.addElement(extractedFile);
                continue block0;
            }
        }
        return extractedFiles;
    }

    private static File extractFile(ZipInputStream zis, ZipEntry e, String dir) throws IOException {
        File f = new File(dir + File.separatorChar + e.getName().replace('/', File.separatorChar));
        if (e.isDirectory()) {
            if (!f.exists() && !f.mkdirs() || !f.isDirectory()) {
                throw new IOException(f + ": could not create directory");
            }
        } else {
            int len;
            File d;
            if (!(f.getParent() == null || ((d = new File(f.getParent())).exists() || d.mkdirs()) && d.isDirectory())) {
                throw new IOException(d + ": could not create directory");
            }
            FileOutputStream os = new FileOutputStream(f);
            byte[] b = new byte[512];
            while ((len = zis.read(b, 0, b.length)) != -1) {
                ((OutputStream)os).write(b, 0, len);
            }
            zis.closeEntry();
            ((OutputStream)os).close();
        }
        return f;
    }

    private static void list(InputStream in, String[] files) throws IOException {
        ZipEntry e;
        ZipInputStream zis = new ZipInputStream(in);
        block0: while ((e = zis.getNextEntry()) != null) {
            String name = e.getName().replace('/', File.separatorChar);
            zis.closeEntry();
            if (files == null) {
                JarAccess.printEntry(e);
                continue;
            }
            for (int i = 0; i < files.length; ++i) {
                if (!name.startsWith(files[i])) continue;
                JarAccess.printEntry(e);
                continue block0;
            }
        }
    }

    private static void printEntry(ZipEntry e) throws IOException {
        JarAccess.output(e.getName());
    }

    private boolean parseArgs(String[] args) {
        int i;
        int l = args.length;
        for (i = 0; i < l; ++i) {
            if (args[i].equals("-bean")) {
                if (i + 1 >= l) {
                    JarAccess.error(localStrings.getLocalString("jaraccess.bean.option", ""));
                    return false;
                }
                this.beanName = args[i + 1];
                ++i;
                continue;
            }
            if (!args[i].equals("-dir")) break;
            if (i + 1 >= l) {
                JarAccess.error(localStrings.getLocalString("jaraccess.dir.option", ""));
                return false;
            }
            this.dirName = new File(args[i + 1]);
            ++i;
        }
        if (i + 1 >= l) {
            JarAccess.error(localStrings.getLocalString("jaraccess.num.args", ""));
            return false;
        }
        this.jarName = new File(args[i]);
        this.fileNames = new String[l - ++i];
        for (int j = 0; j < l - i; ++j) {
            this.fileNames[j] = args[j + i];
        }
        return true;
    }

    private void printArgs() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "jarName: " + this.jarName);
            _logger.log(Level.FINE, "dirName: " + this.dirName);
            _logger.log(Level.FINE, "beanName: " + this.beanName);
            _logger.log(Level.FINE, "fileNames: " + this.fileNames);
        }
        if (this.fileNames != null) {
            for (int i = 0; i < this.fileNames.length; ++i) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "fileNames[" + i + "]: " + this.fileNames[i]);
            }
        }
    }

    protected static void output(String s) {
        _logger.log(Level.FINE, s);
    }

    protected static void error(String s) {
        _logger.log(Level.SEVERE, "enterprise_util.some_error", s);
    }
}

