/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.collection;

import com.sun.enterprise.util.collection.LongArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class LongArray {
    long[] data;
    int size;
    double growFactor;

    public LongArray() {
        this(6, 0.5);
    }

    public LongArray(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    public LongArray(int initialCapacity, double growFactor) {
        this.data = new long[initialCapacity];
        this.growFactor = growFactor;
    }

    public void add(int index, long val) {
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = val;
        ++this.size;
    }

    public boolean add(long val) {
        if (this.size == this.data.length) {
            this.makeRoom(1);
        }
        this.data[this.size++] = val;
        return true;
    }

    public boolean addAll(LongArray coll) {
        int collSize = coll.size();
        this.makeRoom(collSize);
        LongIterator longIter = coll.longIterator();
        while (longIter.hasNext()) {
            this.data[this.size++] = longIter.nextLong();
        }
        return collSize > 0;
    }

    public boolean addAll(int index, LongArray coll) {
        int collSize = coll.size();
        this.makeRoom(collSize);
        System.arraycopy(this.data, index, this.data, index + collSize, this.size - index);
        LongIterator longIter = coll.longIterator();
        while (longIter.hasNext()) {
            this.data[index++] = longIter.nextLong();
        }
        this.size += collSize;
        return collSize > 0;
    }

    public void clear() {
        this.size = 0;
        this.data = new long[6];
    }

    public boolean contains(long val) {
        return this.indexOf(val) >= 0;
    }

    public boolean containsAll(LongArray coll) {
        LongIterator iter = coll.longIterator();
        while (iter.hasNext()) {
            if (this.contains(iter.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(long[] array) {
        int i = array.length;
        while (i > 0) {
            if (this.contains(array[--i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public long get(int index) {
        return this.data[index];
    }

    public int hashCode() {
        long hashCode = 1L;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31L * hashCode + this.data[i];
        }
        return (int)hashCode;
    }

    public int indexOf(long val) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != val) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(long val) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != val) continue;
            return i;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return new LongIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new LongIterator(index);
    }

    public long remove(int index) {
        long val = this.data[index];
        if (index < this.size - 1) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        --this.size;
        return val;
    }

    public boolean remove(long val) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != val || i >= this.size - 1) continue;
            System.arraycopy(this.data, i + 1, this.data, i, this.size - i);
            --this.size;
            return true;
        }
        return false;
    }

    public boolean removeAll(LongArray coll) {
        boolean removed = false;
        LongIterator iter = coll.longIterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.nextLong())) continue;
            removed = true;
        }
        return removed;
    }

    public boolean removeAll(long[] array) {
        boolean removed = false;
        for (int i = 0; i < array.length; ++i) {
            if (!this.remove(array[i])) continue;
            removed = true;
        }
        return removed;
    }

    public boolean retainAll(LongArray coll) {
        return false;
    }

    public boolean retainAll(long[] array) {
        return false;
    }

    public Object set(int index, Object o) {
        long oldVal = this.data[index];
        this.data[index] = (Long)o;
        return oldVal;
    }

    public long set(int index, long val) {
        long oldVal = this.data[index];
        this.data[index] = val;
        return oldVal;
    }

    public int size() {
        return this.size;
    }

    public long[] toArray() {
        return this.data;
    }

    protected void makeRoom(int space) {
        if (space + this.size >= this.data.length) {
            long[] oldData = this.data;
            int newSize = this.size + space + (int)((double)this.size * this.growFactor) + 1;
            this.data = new long[newSize];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
    }

    public Iterator iterator() {
        return new LongIterator(0);
    }

    public LongIterator longIterator() {
        return new LongIterator(0);
    }

    public void print() {
        System.out.print("Data (size: " + this.size + "): ");
        for (int i = 0; i < this.size; ++i) {
            System.out.print(" " + this.data[i]);
        }
        System.out.println();
    }

    public void printStat() {
        System.out.println("Size: " + this.size);
        System.out.println("Length: " + this.data.length);
    }

    public static void main(String[] args) {
        int i;
        int count = 1000000;
        ArrayList<Long> al = new ArrayList<Long>(count);
        LongArray la = new LongArray(count, 0.1);
        LongArrayList lal = new LongArrayList(count, 0.1);
        long t1 = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            al.add(Long.valueOf(i));
        }
        long t2 = System.currentTimeMillis();
        System.out.println("ArrayList took: " + (double)(t2 - t1) / 1000.0 + " sec.");
        al.clear();
        t1 = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            la.add(i);
        }
        t2 = System.currentTimeMillis();
        System.out.println("LongArray took: " + (double)(t2 - t1) / 1000.0 + " sec.");
        la.printStat();
        la.clear();
        t1 = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            lal.add(i);
        }
        t2 = System.currentTimeMillis();
        System.out.println("LongArrayList took: " + (double)(t2 - t1) / 1000.0 + " sec.");
        lal.clear();
        for (i = 0; i < count; ++i) {
            la.add(i);
        }
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < count; ++j) {
                if (la.get(j) == (long)j) continue;
                System.out.println("data[" + j + "]: " + la.get(j));
            }
        }
    }

    private class LongIterator
    implements ListIterator {
        int startIndex;
        int index = 0;

        LongIterator(int startAt) {
            this.startIndex = startAt;
        }

        public void add(Object o) {
        }

        public boolean hasPrevious() {
            return this.index > this.startIndex;
        }

        public boolean hasNext() {
            return this.index < LongArray.this.size;
        }

        public Object previous() {
            return LongArray.this.data[--this.index];
        }

        public int previousIndex() {
            return this.index;
        }

        public Object next() {
            return LongArray.this.data[this.index++];
        }

        public int nextIndex() {
            return this.index;
        }

        public long previousLong() {
            return LongArray.this.data[--this.index];
        }

        public long nextLong() {
            return LongArray.this.data[this.index++];
        }

        public void remove() {
        }

        public void set(Object o) {
        }
    }
}

