/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.pool;

import com.sun.enterprise.util.collection.DList;
import com.sun.enterprise.util.collection.DListNode;
import com.sun.enterprise.util.collection.FastStack;
import com.sun.enterprise.util.pool.AbstractPool;
import com.sun.enterprise.util.pool.ObjectFactory;
import com.sun.enterprise.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectPool
extends AbstractPool
implements PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected DList list;
    protected int minSize;
    protected int initialSize;
    protected int maxLimit;
    protected long maxIdleTime;
    protected Boolean isBounded;

    public ObjectPool(ObjectFactory factory, int minSize, int initialSize, long maxIdleTime) {
        this.factory = factory;
        this.minSize = minSize;
        this.initialSize = initialSize;
        this.maxIdleTime = maxIdleTime;
        this.setMaxLimit(-1);
        this.initPool();
    }

    public ObjectPool(ObjectFactory factory, int minSize, int initialSize, int maxLimit, long maxIdleTime) {
        this.factory = factory;
        this.minSize = minSize;
        this.maxIdleTime = maxIdleTime;
        this.initialSize = initialSize;
        this.setMaxLimit(maxLimit);
        this.initPool();
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(int limit) {
        if (limit <= 0 || limit >= 0x7FFFFFFE) {
            this.isBounded = null;
        } else {
            this.isBounded = true;
            this.maxLimit = limit;
        }
    }

    private void initPool() {
        this.list = new DList();
        this.collection = this.list;
        super.preload(this.minSize < this.initialSize ? this.initialSize : this.minSize);
        this.scheduler.addTimeRepeatableTask(this, (int)this.maxIdleTime);
    }

    protected boolean canCreate() {
        return this.isBounded == null ? true : this.createdCount < this.maxLimit;
    }

    protected Object checkin(Object object) {
        this.list.addAsLastNode(new TimeStampedDListNode(object, _clock.getTime()));
        return this;
    }

    private Object obtainObject(Object param) {
        TimeStampedDListNode tsNode = (TimeStampedDListNode)this.list.delinkLastNode();
        return tsNode.object;
    }

    protected Object checkout(Object param) {
        return this.obtainObject(param);
    }

    public void prolog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() {
        int killedCount = 0;
        long now = _clock.getTime();
        long allowed = now - this.maxIdleTime;
        TimeStampedDListNode tsNode = null;
        FastStack stack = new FastStack();
        Collection collection = this.collection;
        synchronized (collection) {
            Object done = null;
            while (done == null) {
                tsNode = (TimeStampedDListNode)this.list.getFirstDListNode();
                if (tsNode == null) {
                    done = new Object();
                    continue;
                }
                if (tsNode.timeStamp <= allowed) {
                    this.list.delink(tsNode);
                    stack.push(tsNode.object);
                    ++killedCount;
                    continue;
                }
                done = new Object();
            }
            this.createdCount -= killedCount;
            if (this.createdCount < this.minSize) {
                super.preload(this.minSize - this.createdCount);
            }
            if (this.waitCount > 0) {
                if (killedCount == 1) {
                    this.collection.notify();
                } else {
                    this.collection.notifyAll();
                }
            }
        }
        while (!stack.isEmpty()) {
            Object object = stack.pop();
            this.beforeDestroy(object);
            this.factory.destroy(object);
        }
        _logger.log(Level.FINE, "Leaving service after killing " + killedCount + " (idle) objects. Now size: " + this.list.size());
    }

    public void epilog() {
    }

    public long getFrequency() {
        return this.maxIdleTime;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long missedByMillis) {
        return true;
    }

    public String toString() {
        return "";
    }

    class TimeStampedDListNode
    extends DListNode {
        long timeStamp;

        public TimeStampedDListNode(Object object, long ts) {
            super(object);
            this.timeStamp = ts;
        }

        public String toString() {
            return "TSDListNode: " + this.object;
        }
    }
}

