/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.ServletStats;
import com.sun.enterprise.web.monitor.PwcServletStats;
import com.sun.enterprise.web.stats.ServletTimeStatisticImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;

public class ServletStatsImpl
implements ServletStats {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private GenericStatsImpl baseStatsImpl;
    private MutableCountStatistic maxTimeMillis;
    private MutableCountStatistic processingTimeMillis;
    private TimeStatistic serviceTimeMillis;
    private MutableCountStatistic requestCount;
    private MutableCountStatistic errorCount;
    private PwcServletStats pwcServletStats;

    public ServletStatsImpl(PwcServletStats pwcServletStats) {
        this.pwcServletStats = pwcServletStats;
        this.baseStatsImpl = new GenericStatsImpl(ServletStats.class, (Object)this);
        this.initializeStatistics();
    }

    public CountStatistic getMaxTime() {
        this.maxTimeMillis.setCount(this.pwcServletStats.getMaxTimeMillis());
        return (CountStatistic)this.maxTimeMillis.unmodifiableView();
    }

    public CountStatistic getProcessingTime() {
        this.processingTimeMillis.setCount(this.pwcServletStats.getProcessingTimeMillis());
        return (CountStatistic)this.processingTimeMillis.unmodifiableView();
    }

    public TimeStatistic getServiceTime() {
        return this.serviceTimeMillis;
    }

    public CountStatistic getRequestCount() {
        this.requestCount.setCount((long)this.pwcServletStats.getRequestCount());
        return (CountStatistic)this.requestCount.unmodifiableView();
    }

    public CountStatistic getErrorCount() {
        this.errorCount.setCount((long)this.pwcServletStats.getErrorCount());
        return (CountStatistic)this.errorCount.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl("ErrorCount");
        this.errorCount = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxTime", "milliseconds");
        this.maxTimeMillis = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("ProcessingTime", "milliseconds");
        this.processingTimeMillis = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("RequestCount");
        this.requestCount = new MutableCountStatisticImpl((CountStatistic)c);
        this.serviceTimeMillis = new ServletTimeStatisticImpl("ServiceTime", "milliseconds", this.pwcServletStats);
    }
}

