/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.security.jmac.config.ConfigHelper;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class ClientPipeCloser {
    private Map<ServiceReferenceDescriptor, ConfigHelper.AuthConfigRegistrationWrapper> svcRefListenerMap = Collections.synchronizedMap(new WeakHashMap());
    private static final ClientPipeCloser INSTANCE = new ClientPipeCloser();

    private ClientPipeCloser() {
    }

    public static ClientPipeCloser getInstance() {
        return INSTANCE;
    }

    public void registerListenerWrapper(ServiceReferenceDescriptor desc, ConfigHelper.AuthConfigRegistrationWrapper wrapper) {
        this.svcRefListenerMap.put(desc, wrapper);
    }

    public ConfigHelper.AuthConfigRegistrationWrapper lookupListenerWrapper(ServiceReferenceDescriptor desc) {
        ConfigHelper.AuthConfigRegistrationWrapper listenerWrapper = this.svcRefListenerMap.get(desc);
        return listenerWrapper;
    }

    public void removeListenerWrapper(ConfigHelper.AuthConfigRegistrationWrapper wrapper) {
        ServiceReferenceDescriptor entryToRemove = null;
        for (ServiceReferenceDescriptor svc : this.svcRefListenerMap.keySet()) {
            ConfigHelper.AuthConfigRegistrationWrapper wrp = this.svcRefListenerMap.get(svc);
            if (wrp != wrapper) continue;
            entryToRemove = svc;
            break;
        }
        if (entryToRemove != null) {
            this.svcRefListenerMap.remove(entryToRemove);
        }
    }

    public void cleanupClientPipe(ServiceReferenceDescriptor desc) {
        ConfigHelper.AuthConfigRegistrationWrapper listenerWrapper = this.svcRefListenerMap.get(desc);
        if (listenerWrapper != null) {
            listenerWrapper.disable();
        }
        this.svcRefListenerMap.remove(desc);
    }
}

