/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.comet.CometContext;
import com.sun.enterprise.web.connector.grizzly.comet.CometEvent;
import com.sun.enterprise.web.connector.grizzly.comet.CometHandler;
import com.sun.enterprise.web.connector.grizzly.comet.CometInputStream;
import com.sun.grizzly.cometd.BayeuxCometHandler;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbUtils;
import com.sun.grizzly.cometd.util.JSONParser;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHandler
implements CometHandler<Object[]> {
    private static final Logger logger = SelectorThread.logger();
    private CometdRequest req;
    private CometdResponse res;
    private String clientId;
    private String channel;

    @Override
    public void attach(Object[] reqRes) {
        this.req = (CometdRequest)reqRes[0];
        this.res = (CometdResponse)reqRes[1];
    }

    @Override
    public void onEvent(CometEvent event) throws IOException {
        Object obj = event.attachment();
        try {
            if (obj instanceof Data) {
                Data data = (Data)obj;
                if (data.getClientId().equals(this.getClientId())) {
                    return;
                }
                String sdata = "," + data.toData() + "]*/";
                this.res.write(sdata);
                this.res.flush();
                event.getCometContext().resumeCometHandler(this);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Data.onEvent", t);
        }
        if (event.getType() == 4) {
            CometInputStream is = (CometInputStream)obj;
            byte[] dataStream = new byte[16384];
            is.setReadTimeout(2000);
            while (is.read(dataStream) > 0) {
            }
            String sdata = new String(dataStream).trim();
            if (sdata.length() <= 1) {
                return;
            }
            try {
                Verb verb = VerbUtils.parse(JSONParser.parse(sdata));
                CometContext cometContext = event.getCometContext();
                cometContext.notify(BayeuxCometHandler.newCometdContext(this.req, this.res, verb), 1, (Integer)cometContext.getAttribute("bayeuxCometHandler"));
                event.getCometContext().removeAttribute(this);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Data.onEvent", t);
            }
        }
    }

    @Override
    public void onInitialize(CometEvent event) throws IOException {
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.res.write("]*/");
        this.res.flush();
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

