/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant;

import com.sun.org.apache.commons.digester.Digester;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.InputSource;

public class ValidatorTask
extends Task {
    protected String path = null;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void execute() throws BuildException {
        if (this.path == null) {
            throw new BuildException("Must specify 'path'");
        }
        File file = new File(this.path, "/WEB-INF/web.xml");
        if (!file.exists() || !file.canRead()) {
            throw new BuildException("Cannot find web.xml");
        }
        Digester digester = ContextConfig.createWebXmlDigester(true, true);
        try {
            file = file.getCanonicalFile();
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            InputSource is = new InputSource(file.toURL().toExternalForm());
            is.setByteStream(stream);
            digester.parse(is);
        }
        catch (Throwable t) {
            throw new BuildException("Validation failure", t);
        }
    }
}

