/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

class TcpWorkerThread
implements ThreadPoolRunnable {
    PoolTcpEndpoint endpoint;

    public TcpWorkerThread(PoolTcpEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Object[] getInitData() {
        Object[] obj = new Object[2];
        obj[1] = this.endpoint.getConnectionHandler().init();
        obj[0] = new TcpConnection();
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIt(Object[] perThrData) {
        if (this.endpoint.isRunning()) {
            Socket s = null;
            try {
                s = this.endpoint.acceptSocket();
            }
            finally {
                if (this.endpoint.isRunning()) {
                    this.endpoint.tp.runIt(this);
                }
            }
            if (null != s) {
                TcpConnection con = null;
                int step = 1;
                try {
                    this.endpoint.setSocketOptions(s);
                    step = 2;
                    if (this.endpoint.getServerSocketFactory() != null) {
                        this.endpoint.getServerSocketFactory().handshake(s);
                    }
                    step = 3;
                    con = (TcpConnection)perThrData[0];
                    con.setEndpoint(this.endpoint);
                    con.setSocket(s);
                    this.endpoint.getConnectionHandler().processConnection(con, (Object[])perThrData[1]);
                }
                catch (SocketException se) {
                    PoolTcpEndpoint.log.error("Remote Host " + s.getInetAddress() + " SocketException: " + se.getMessage());
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                catch (Throwable t) {
                    if (step == 2) {
                        PoolTcpEndpoint.log.error("Handshake failed", t);
                    } else {
                        PoolTcpEndpoint.log.error("Unexpected error", t);
                    }
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                finally {
                    if (con != null) {
                        con.recycle();
                    }
                }
            }
        }
    }
}

