/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.iiop.AbstractType;
import sun.rmi.rmic.iiop.ArrayType;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.ContextElement;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.DirectoryLoader;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.ImplementationType;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.NCClassType;
import sun.rmi.rmic.iiop.NCInterfaceType;
import sun.rmi.rmic.iiop.PrimitiveType;
import sun.rmi.rmic.iiop.RemoteType;
import sun.rmi.rmic.iiop.SpecialClassType;
import sun.rmi.rmic.iiop.SpecialInterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.tree.IntegerExpression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Node;

public abstract class CompoundType
extends Type {
    protected Method[] methods;
    protected InterfaceType[] interfaces;
    protected Member[] members;
    protected ClassDefinition classDef;
    protected ClassDeclaration classDecl;
    protected boolean isCORBAObject = false;
    protected boolean isIDLEntity = false;
    protected boolean isAbstractBase = false;
    protected boolean isValueBase = false;
    protected boolean isCORBAUserException = false;
    protected boolean isException = false;
    protected boolean isCheckedException = false;
    protected boolean isRemoteExceptionOrSubclass = false;
    protected String idlExceptionName;
    protected String qualifiedIDLExceptionName;

    public boolean isCORBAObject() {
        return this.isCORBAObject;
    }

    public boolean isIDLEntity() {
        return this.isIDLEntity;
    }

    public boolean isValueBase() {
        return this.isValueBase;
    }

    public boolean isAbstractBase() {
        return this.isAbstractBase;
    }

    public boolean isException() {
        return this.isException;
    }

    public boolean isCheckedException() {
        return this.isCheckedException;
    }

    public boolean isRemoteExceptionOrSubclass() {
        return this.isRemoteExceptionOrSubclass;
    }

    public boolean isCORBAUserException() {
        return this.isCORBAUserException;
    }

    public boolean isIDLEntityException() {
        return this.isIDLEntity() && this.isException();
    }

    public boolean isBoxed() {
        return this.isIDLEntity() && !this.isValueBase() && !this.isAbstractBase() && !this.isCORBAObject() && !this.isIDLEntityException();
    }

    public String getIDLExceptionName() {
        return this.idlExceptionName;
    }

    public String getQualifiedIDLExceptionName(boolean global) {
        if (this.qualifiedIDLExceptionName != null && global && this.getIDLModuleNames().length > 0) {
            return "::" + this.qualifiedIDLExceptionName;
        }
        return this.qualifiedIDLExceptionName;
    }

    public String getSignature() {
        String sig = this.classDecl.getType().getTypeSignature();
        if (sig.endsWith(";")) {
            sig = sig.substring(0, sig.length() - 1);
        }
        return sig;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.classDecl;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDef;
    }

    public ClassType getSuperclass() {
        return null;
    }

    public InterfaceType[] getInterfaces() {
        if (this.interfaces != null) {
            return (InterfaceType[])this.interfaces.clone();
        }
        return null;
    }

    public Method[] getMethods() {
        if (this.methods != null) {
            return (Method[])this.methods.clone();
        }
        return null;
    }

    public Member[] getMembers() {
        if (this.members != null) {
            return (Member[])this.members.clone();
        }
        return null;
    }

    public static CompoundType forCompound(ClassDefinition classDef, ContextStack stack) {
        CompoundType result = null;
        try {
            result = (CompoundType)CompoundType.makeType(classDef.getType(), classDef, stack);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result;
    }

    protected void destroy() {
        if (!this.destroyed) {
            int i;
            super.destroy();
            if (this.methods != null) {
                for (i = 0; i < this.methods.length; ++i) {
                    if (this.methods[i] == null) continue;
                    this.methods[i].destroy();
                }
                this.methods = null;
            }
            if (this.interfaces != null) {
                for (i = 0; i < this.interfaces.length; ++i) {
                    if (this.interfaces[i] == null) continue;
                    this.interfaces[i].destroy();
                }
                this.interfaces = null;
            }
            if (this.members != null) {
                for (i = 0; i < this.members.length; ++i) {
                    if (this.members[i] == null) continue;
                    this.members[i].destroy();
                }
                this.members = null;
            }
            this.classDef = null;
            this.classDecl = null;
        }
    }

    protected Class loadClass() {
        Class ourClass = null;
        try {
            this.env.getMain().compileAllClasses(this.env);
        }
        catch (Exception e1) {
            Enumeration e = this.env.getClasses();
            while (e.hasMoreElements()) {
                ClassDeclaration c = (ClassDeclaration)e.nextElement();
            }
            CompoundType.failedConstraint(26, false, this.stack, "required classes");
            this.env.flushErrors();
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            ourClass = cl.loadClass(this.getQualifiedName());
        }
        catch (ClassNotFoundException cfe) {
            try {
                ourClass = this.env.classPathLoader.loadClass(this.getQualifiedName());
            }
            catch (NullPointerException e) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (ourClass == null) {
            if (this.env.loader == null) {
                File destDir = this.env.getMain().getDestinationDir();
                if (destDir == null) {
                    destDir = new File(".");
                }
                this.env.loader = new DirectoryLoader(destDir);
            }
            try {
                ourClass = this.env.loader.loadClass(this.getQualifiedName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ourClass;
    }

    protected boolean printExtends(IndentingWriter writer, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        ClassType parent = this.getSuperclass();
        if (!(parent == null || useIDLNames && (parent.isType(1024) || parent.isType(2048)))) {
            writer.p(" extends ");
            parent.printTypeName(writer, useQualifiedNames, useIDLNames, globalIDLNames);
            return true;
        }
        return false;
    }

    protected void printImplements(IndentingWriter writer, String prefix, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        InterfaceType[] interfaces = this.getInterfaces();
        String adjective = " implements";
        if (this.isInterface()) {
            adjective = " extends";
        }
        if (useIDLNames) {
            adjective = ":";
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (useIDLNames && (interfaces[i].isType(1024) || interfaces[i].isType(2048))) continue;
            if (i == 0) {
                writer.p(prefix + adjective + " ");
            } else {
                writer.p(", ");
            }
            interfaces[i].printTypeName(writer, useQualifiedNames, useIDLNames, globalIDLNames);
        }
    }

    protected void printMembers(IndentingWriter writer, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        Member[] members = this.getMembers();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isInnerClassDeclaration()) continue;
            Type it = members[i].getType();
            String visibility = members[i].getVisibility();
            String name = useIDLNames ? members[i].getIDLName() : members[i].getName();
            String value = members[i].getValue();
            writer.p(visibility);
            if (visibility.length() > 0) {
                writer.p(" ");
            }
            it.printTypeName(writer, useQualifiedNames, useIDLNames, globalIDLNames);
            writer.p(" " + name);
            if (value != null) {
                writer.pln(" = " + value + ";");
                continue;
            }
            writer.pln(";");
        }
    }

    protected void printMethods(IndentingWriter writer, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        Method[] methods = this.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method theMethod = methods[m];
            this.printMethod(theMethod, writer, useQualifiedNames, useIDLNames, globalIDLNames);
        }
    }

    protected void printMethod(Method it, IndentingWriter writer, boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) throws IOException {
        String visibility = it.getVisibility();
        writer.p(visibility);
        if (visibility.length() > 0) {
            writer.p(" ");
        }
        it.getReturnType().printTypeName(writer, useQualifiedNames, useIDLNames, globalIDLNames);
        if (useIDLNames) {
            writer.p(" " + it.getIDLName());
        } else {
            writer.p(" " + it.getName());
        }
        writer.p(" (");
        Type[] args = it.getArguments();
        String[] argNames = it.getArgumentNames();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                writer.p(", ");
            }
            if (useIDLNames) {
                writer.p("in ");
            }
            args[i].printTypeName(writer, useQualifiedNames, useIDLNames, globalIDLNames);
            writer.p(" " + argNames[i]);
        }
        writer.p(")");
        ValueType[] exceptions = this.isType(65536) ? it.getImplExceptions() : it.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            if (i == 0) {
                if (useIDLNames) {
                    writer.p(" raises (");
                } else {
                    writer.p(" throws ");
                }
            } else {
                writer.p(", ");
            }
            if (useIDLNames) {
                if (useQualifiedNames) {
                    writer.p(exceptions[i].getQualifiedIDLExceptionName(globalIDLNames));
                } else {
                    writer.p(exceptions[i].getIDLExceptionName());
                }
                writer.p(" [a.k.a. ");
                exceptions[i].printTypeName(writer, useQualifiedNames, useIDLNames, globalIDLNames);
                writer.p("]");
                continue;
            }
            exceptions[i].printTypeName(writer, useQualifiedNames, useIDLNames, globalIDLNames);
        }
        if (useIDLNames && exceptions.length > 0) {
            writer.p(")");
        }
        if (it.isInherited()) {
            writer.p(" // Inherited from ");
            writer.p(it.getDeclaredBy());
        }
        writer.pln(";");
    }

    protected CompoundType(ContextStack stack, int typeCode, ClassDefinition classDef) {
        super(stack, typeCode);
        this.classDef = classDef;
        this.classDecl = classDef.getClassDeclaration();
        this.interfaces = new InterfaceType[0];
        this.methods = new Method[0];
        this.members = new Member[0];
        if (classDef.isInnerClass()) {
            this.setTypeCode(typeCode | Integer.MIN_VALUE);
        }
        this.setFlags();
    }

    private void setFlags() {
        try {
            this.isCORBAObject = this.env.defCorbaObject.implementedBy((Environment)this.env, this.classDecl);
            this.isIDLEntity = this.env.defIDLEntity.implementedBy((Environment)this.env, this.classDecl);
            this.isValueBase = this.env.defValueBase.implementedBy((Environment)this.env, this.classDecl);
            this.isAbstractBase = this.isInterface() && this.isIDLEntity && !this.isValueBase && !this.isCORBAObject;
            boolean bl = this.isCORBAUserException = this.classDecl.getName() == idCorbaUserException;
            if (this.env.defThrowable.implementedBy((Environment)this.env, this.classDecl)) {
                this.isException = true;
                this.isCheckedException = !this.env.defRuntimeException.implementedBy((Environment)this.env, this.classDecl) && !this.env.defError.implementedBy((Environment)this.env, this.classDecl);
                this.isRemoteExceptionOrSubclass = this.env.defRemoteException.implementedBy((Environment)this.env, this.classDecl);
            } else {
                this.isException = false;
            }
        }
        catch (ClassNotFound e) {
            CompoundType.classNotFound(this.stack, e);
        }
    }

    protected CompoundType(ContextStack stack, ClassDefinition classDef, int typeCode) {
        super(stack, typeCode);
        this.classDef = classDef;
        this.classDecl = classDef.getClassDeclaration();
        if (classDef.isInnerClass()) {
            this.setTypeCode(typeCode | Integer.MIN_VALUE);
        }
        this.setFlags();
        Identifier id = classDef.getName();
        try {
            String idlName = IDLNames.getClassOrInterfaceName(id, this.env);
            String[] idlModuleNames = IDLNames.getModuleNames(id, this.isBoxed(), this.env);
            this.setNames(id, idlModuleNames, idlName);
            if (this.isException()) {
                this.isException = true;
                this.idlExceptionName = IDLNames.getExceptionName(this.getIDLName());
                this.qualifiedIDLExceptionName = IDLNames.getQualifiedName(this.getIDLModuleNames(), this.idlExceptionName);
            }
            this.interfaces = null;
            this.methods = null;
            this.members = null;
        }
        catch (Exception e) {
            CompoundType.failedConstraint(7, false, stack, id.toString(), e.getMessage());
            throw new CompilerError("");
        }
    }

    protected boolean initialize(Vector directInterfaces, Vector directMethods, Vector directMembers, ContextStack stack, boolean quiet) {
        boolean result = true;
        if (directInterfaces != null && directInterfaces.size() > 0) {
            this.interfaces = new InterfaceType[directInterfaces.size()];
            directInterfaces.copyInto(this.interfaces);
        } else {
            this.interfaces = new InterfaceType[0];
        }
        if (directMethods != null && directMethods.size() > 0) {
            this.methods = new Method[directMethods.size()];
            directMethods.copyInto(this.methods);
            try {
                IDLNames.setMethodNames(this, this.methods, this.env);
            }
            catch (Exception e) {
                CompoundType.failedConstraint(13, quiet, stack, this.getQualifiedName(), e.getMessage());
                result = false;
            }
        } else {
            this.methods = new Method[0];
        }
        if (directMembers != null && directMembers.size() > 0) {
            this.members = new Member[directMembers.size()];
            directMembers.copyInto(this.members);
            for (int i = 0; i < this.members.length; ++i) {
                if (!this.members[i].isInnerClassDeclaration()) continue;
                try {
                    this.members[i].init(stack, this);
                    continue;
                }
                catch (CompilerError e) {
                    return false;
                }
            }
            try {
                IDLNames.setMemberNames(this, this.members, this.methods, this.env);
            }
            catch (Exception e) {
                int constraint = this.classDef.isInterface() ? 19 : 20;
                CompoundType.failedConstraint(constraint, quiet, stack, this.getQualifiedName(), e.getMessage());
                result = false;
            }
        } else {
            this.members = new Member[0];
        }
        if (result) {
            result = this.setRepositoryID();
        }
        return result;
    }

    protected static Type makeType(sun.tools.java.Type theType, ClassDefinition classDef, ContextStack stack) {
        if (stack.anyErrors()) {
            return null;
        }
        String key = theType.toString();
        Type result = CompoundType.getType(key, stack);
        if (result != null) {
            return result;
        }
        result = CompoundType.getType(key + stack.getContextCodeString(), stack);
        if (result != null) {
            return result;
        }
        BatchEnvironment env = stack.getEnv();
        int typeCode = theType.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                result = PrimitiveType.forPrimitive(theType, stack);
                break;
            }
            case 9: {
                result = ArrayType.forArray(theType, stack);
                break;
            }
            case 10: {
                try {
                    ClassDefinition theClass = classDef;
                    if (theClass == null) {
                        theClass = env.getClassDeclaration(theType).getClassDefinition((Environment)env);
                    }
                    if (theClass.isInterface()) {
                        result = SpecialInterfaceType.forSpecial(theClass, stack);
                        if (result != null) break;
                        if (env.defRemote.implementedBy((Environment)env, theClass.getClassDeclaration())) {
                            boolean parentIsValue = stack.isParentAValue();
                            result = RemoteType.forRemote(theClass, stack, parentIsValue);
                            if (result != null || !parentIsValue) break;
                            result = NCInterfaceType.forNCInterface(theClass, stack);
                            break;
                        }
                        result = AbstractType.forAbstract(theClass, stack, true);
                        if (result != null) break;
                        result = NCInterfaceType.forNCInterface(theClass, stack);
                        break;
                    }
                    result = SpecialClassType.forSpecial(theClass, stack);
                    if (result != null) break;
                    ClassDeclaration classDecl = theClass.getClassDeclaration();
                    if (env.defRemote.implementedBy((Environment)env, classDecl)) {
                        boolean parentIsValue = stack.isParentAValue();
                        result = ImplementationType.forImplementation(theClass, stack, parentIsValue);
                        if (result != null || !parentIsValue) break;
                        result = NCClassType.forNCClass(theClass, stack);
                        break;
                    }
                    if (env.defSerializable.implementedBy((Environment)env, classDecl)) {
                        result = ValueType.forValue(theClass, stack, true);
                    }
                    if (result != null) break;
                    result = NCClassType.forNCClass(theClass, stack);
                }
                catch (ClassNotFound e) {
                    CompoundType.classNotFound(stack, e);
                }
                break;
            }
            default: {
                throw new CompilerError("Unknown typecode (" + typeCode + ") for " + theType.getTypeSignature());
            }
        }
        return result;
    }

    public static boolean isRemoteException(ClassType ex, BatchEnvironment env) {
        sun.tools.java.Type exceptionType = ex.getClassDeclaration().getType();
        return exceptionType.equals(env.typeRemoteException) || exceptionType.equals(env.typeIOException) || exceptionType.equals(env.typeException) || exceptionType.equals(env.typeThrowable);
    }

    protected boolean isConformingRemoteMethod(Method method, boolean quiet) throws ClassNotFound {
        boolean noIDLEntity;
        boolean haveRemote = false;
        ValueType[] exceptions = method.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!CompoundType.isRemoteException(exceptions[i], this.env)) continue;
            haveRemote = true;
            break;
        }
        if (!haveRemote) {
            CompoundType.failedConstraint(5, quiet, this.stack, method.getEnclosing(), method.toString());
        }
        boolean bl = noIDLEntity = !this.isIDLEntityException(method.getReturnType(), method, quiet);
        if (noIDLEntity) {
            Type[] args = method.getArguments();
            for (int i = 0; i < args.length; ++i) {
                if (!this.isIDLEntityException(args[i], method, quiet)) continue;
                noIDLEntity = false;
                break;
            }
        }
        return haveRemote && noIDLEntity;
    }

    protected boolean isIDLEntityException(Type type, Method method, boolean quiet) throws ClassNotFound {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isCompound() && ((CompoundType)type).isIDLEntityException()) {
            CompoundType.failedConstraint(18, quiet, this.stack, method.getEnclosing(), method.toString());
            return true;
        }
        return false;
    }

    protected void swapInvalidTypes() {
        int i;
        for (i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i].getStatus() == 1) continue;
            this.interfaces[i] = (InterfaceType)this.getValidType(this.interfaces[i]);
        }
        for (i = 0; i < this.methods.length; ++i) {
            this.methods[i].swapInvalidTypes();
        }
        for (i = 0; i < this.members.length; ++i) {
            this.members[i].swapInvalidTypes();
        }
    }

    protected boolean addTypes(int typeCodeFilter, HashSet checked, Vector matching) {
        boolean result = super.addTypes(typeCodeFilter, checked, matching);
        if (result) {
            int i;
            ClassType parent = this.getSuperclass();
            if (parent != null) {
                parent.addTypes(typeCodeFilter, checked, matching);
            }
            for (i = 0; i < this.interfaces.length; ++i) {
                this.interfaces[i].addTypes(typeCodeFilter, checked, matching);
            }
            for (i = 0; i < this.methods.length; ++i) {
                this.methods[i].getReturnType().addTypes(typeCodeFilter, checked, matching);
                Type[] args = this.methods[i].getArguments();
                for (int j = 0; j < args.length; ++j) {
                    Type arg = args[j];
                    arg.addTypes(typeCodeFilter, checked, matching);
                }
                ValueType[] exceptions = this.methods[i].getExceptions();
                for (int j = 0; j < exceptions.length; ++j) {
                    ValueType ex = exceptions[j];
                    ex.addTypes(typeCodeFilter, checked, matching);
                }
            }
            for (i = 0; i < this.members.length; ++i) {
                Type cType = this.members[i].getType();
                cType.addTypes(typeCodeFilter, checked, matching);
            }
        }
        return result;
    }

    private boolean isConformingConstantType(MemberDefinition member) {
        return this.isConformingConstantType(member.getType(), member);
    }

    private boolean isConformingConstantType(sun.tools.java.Type theType, MemberDefinition member) {
        boolean result = true;
        int typeCode = theType.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 10: {
                if (theType.getClassName() == idJavaLangString) break;
                CompoundType.failedConstraint(3, false, this.stack, member.getClassDefinition(), member.getName());
                result = false;
                break;
            }
            case 9: {
                CompoundType.failedConstraint(3, false, this.stack, member.getClassDefinition(), member.getName());
                result = false;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + typeCode);
            }
        }
        return result;
    }

    protected Vector updateParentClassMethods(ClassDefinition current, Vector currentMethods, boolean quiet, ContextStack stack) throws ClassNotFound {
        ClassDeclaration parentDecl = current.getSuperClass((Environment)this.env);
        while (parentDecl != null) {
            ClassDefinition parentDef = parentDecl.getClassDefinition((Environment)this.env);
            Identifier currentID = parentDecl.getName();
            if (currentID == idJavaLangObject) break;
            for (MemberDefinition member = parentDef.getFirstMember(); member != null; member = member.getNextMember()) {
                Method method;
                if (!member.isMethod() || member.isInitializer() || member.isConstructor() || member.isPrivate()) continue;
                try {
                    method = new Method(this, member, quiet, stack);
                }
                catch (Exception e) {
                    return null;
                }
                int index = currentMethods.indexOf(method);
                if (index >= 0) {
                    Method currentMethod = (Method)currentMethods.elementAt(index);
                    currentMethod.setDeclaredBy(currentID);
                    continue;
                }
                currentMethods.addElement(method);
            }
            parentDecl = parentDef.getSuperClass((Environment)this.env);
        }
        return currentMethods;
    }

    protected Vector addAllMethods(ClassDefinition current, Vector directMethods, boolean noMultiInheritedMethods, boolean quiet, ContextStack stack) throws ClassNotFound {
        ClassDeclaration[] interfaces = current.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Vector result = this.addAllMethods(interfaces[i].getClassDefinition((Environment)this.env), directMethods, noMultiInheritedMethods, quiet, stack);
            if (result != null) continue;
            return null;
        }
        for (MemberDefinition member = current.getFirstMember(); member != null; member = member.getNextMember()) {
            Method existingMethod;
            ClassDefinition existingMemberClassDef;
            Method method;
            if (!member.isMethod() || member.isInitializer() || member.isPrivate()) continue;
            try {
                method = new Method(this, member, quiet, stack);
            }
            catch (Exception e) {
                return null;
            }
            if (!directMethods.contains(method)) {
                directMethods.addElement(method);
                continue;
            }
            if (!(!noMultiInheritedMethods || current == this.classDef || stack.isParentAValue() || stack.getContext().isValue() || current == (existingMemberClassDef = (existingMethod = (Method)directMethods.elementAt(directMethods.indexOf(method))).getMemberDefinition().getClassDefinition()) || this.inheritsFrom(current, existingMemberClassDef) || this.inheritsFrom(existingMemberClassDef, current))) {
                String message = existingMemberClassDef.getName() + " and " + current.getName();
                CompoundType.failedConstraint(6, quiet, stack, this.classDef, message, method);
                return null;
            }
            int index = directMethods.indexOf(method);
            Method other = (Method)directMethods.get(index);
            Method newMethod = method.mergeWith(other);
            directMethods.set(index, newMethod);
        }
        return directMethods;
    }

    protected boolean inheritsFrom(ClassDefinition def, ClassDefinition otherDef) {
        ClassDefinition superDef;
        if (def == otherDef) {
            return true;
        }
        if (def.getSuperClass() != null && this.inheritsFrom(superDef = def.getSuperClass().getClassDefinition(), otherDef)) {
            return true;
        }
        ClassDeclaration[] interfaces = def.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            superDef = interfaces[i].getClassDefinition();
            if (!this.inheritsFrom(superDef, otherDef)) continue;
            return true;
        }
        return false;
    }

    protected Vector addRemoteInterfaces(Vector list, boolean allowNonConforming, ContextStack stack) throws ClassNotFound {
        ClassDefinition theInterface = this.getClassDefinition();
        ClassDeclaration[] interfaces = theInterface.getInterfaces();
        stack.setNewContextCode(10);
        for (int i = 0; i < interfaces.length; ++i) {
            ClassDefinition def = interfaces[i].getClassDefinition((Environment)this.env);
            InterfaceType it = SpecialInterfaceType.forSpecial(def, stack);
            if (it == null) {
                if (this.env.defRemote.implementedBy((Environment)this.env, interfaces[i])) {
                    it = RemoteType.forRemote(def, stack, false);
                } else {
                    it = AbstractType.forAbstract(def, stack, true);
                    if (it == null && allowNonConforming) {
                        it = NCInterfaceType.forNCInterface(def, stack);
                    }
                }
            }
            if (it == null) {
                return null;
            }
            list.addElement(it);
        }
        return list;
    }

    protected Vector addNonRemoteInterfaces(Vector list, ContextStack stack) throws ClassNotFound {
        ClassDefinition theInterface = this.getClassDefinition();
        ClassDeclaration[] interfaces = theInterface.getInterfaces();
        stack.setNewContextCode(10);
        for (int i = 0; i < interfaces.length; ++i) {
            ClassDefinition def = interfaces[i].getClassDefinition((Environment)this.env);
            InterfaceType it = SpecialInterfaceType.forSpecial(def, stack);
            if (it == null && (it = AbstractType.forAbstract(def, stack, true)) == null) {
                it = NCInterfaceType.forNCInterface(def, stack);
            }
            if (it == null) {
                return null;
            }
            list.addElement(it);
        }
        return list;
    }

    protected boolean addAllMembers(Vector allMembers, boolean onlyConformingConstants, boolean quiet, ContextStack stack) {
        boolean result = true;
        for (MemberDefinition member = this.getClassDefinition().getFirstMember(); member != null && result; member = member.getNextMember()) {
            if (member.isMethod()) continue;
            try {
                String value = null;
                member.getValue((Environment)this.env);
                Node node = member.getValue();
                if (node != null) {
                    if (member.getType().getTypeCode() == 2) {
                        Integer intValue = (Integer)((IntegerExpression)node).getValue();
                        value = "L'" + String.valueOf((char)intValue.intValue()) + "'";
                    } else {
                        value = node.toString();
                    }
                }
                if (onlyConformingConstants && member.getInnerClass() == null && (value == null || !this.isConformingConstantType(member))) {
                    CompoundType.failedConstraint(3, quiet, stack, member.getClassDefinition(), member.getName());
                    result = false;
                    break;
                }
                try {
                    Member newMember = new Member(member, value, stack, this);
                    allMembers.addElement(newMember);
                }
                catch (CompilerError e) {
                    result = false;
                }
                continue;
            }
            catch (ClassNotFound e) {
                CompoundType.classNotFound(stack, e);
                result = false;
            }
        }
        return result;
    }

    protected boolean addConformingConstants(Vector allMembers, boolean quiet, ContextStack stack) {
        boolean result = true;
        for (MemberDefinition member = this.getClassDefinition().getFirstMember(); member != null && result; member = member.getNextMember()) {
            if (member.isMethod()) continue;
            try {
                String value = null;
                member.getValue((Environment)this.env);
                Node node = member.getValue();
                if (node != null) {
                    value = node.toString();
                }
                if (value == null) continue;
                if (!this.isConformingConstantType(member)) {
                    CompoundType.failedConstraint(3, quiet, stack, member.getClassDefinition(), member.getName());
                    result = false;
                    break;
                }
                try {
                    Member newMember = new Member(member, value, stack, this);
                    allMembers.addElement(newMember);
                }
                catch (CompilerError e) {
                    result = false;
                }
                continue;
            }
            catch (ClassNotFound e) {
                CompoundType.classNotFound(stack, e);
                result = false;
            }
        }
        return result;
    }

    protected ValueType[] getMethodExceptions(MemberDefinition member, boolean quiet, ContextStack stack) throws Exception {
        boolean result = true;
        stack.setNewContextCode(5);
        ClassDeclaration[] except = member.getExceptions((Environment)this.env);
        ValueType[] exceptions = new ValueType[except.length];
        try {
            for (int i = 0; i < except.length; ++i) {
                ClassDefinition theClass = except[i].getClassDefinition((Environment)this.env);
                try {
                    ValueType type = ValueType.forValue(theClass, stack, false);
                    if (type != null) {
                        exceptions[i] = type;
                        continue;
                    }
                    result = false;
                    continue;
                }
                catch (ClassCastException e1) {
                    CompoundType.failedConstraint(22, quiet, stack, this.getQualifiedName());
                    throw new CompilerError("Method: exception " + theClass.getName() + " not a class type!");
                }
                catch (NullPointerException e2) {
                    CompoundType.failedConstraint(23, quiet, stack, this.getQualifiedName());
                    throw new CompilerError("Method: caught null pointer exception");
                }
            }
        }
        catch (ClassNotFound e) {
            CompoundType.classNotFound(quiet, stack, e);
            result = false;
        }
        if (!result) {
            throw new Exception();
        }
        int dupCount = 0;
        for (int i = 0; i < exceptions.length; ++i) {
            for (int j = 0; j < exceptions.length; ++j) {
                if (i == j || exceptions[i] == null || exceptions[i] != exceptions[j]) continue;
                exceptions[j] = null;
                ++dupCount;
            }
        }
        if (dupCount > 0) {
            int offset = 0;
            ValueType[] temp = new ValueType[exceptions.length - dupCount];
            for (int i = 0; i < exceptions.length; ++i) {
                if (exceptions[i] == null) continue;
                temp[offset++] = exceptions[i];
            }
            exceptions = temp;
        }
        return exceptions;
    }

    protected static String getVisibilityString(MemberDefinition member) {
        String vis = "";
        String prefix = "";
        if (member.isPublic()) {
            vis = vis + "public";
            prefix = " ";
        } else if (member.isProtected()) {
            vis = vis + "protected";
            prefix = " ";
        } else if (member.isPrivate()) {
            vis = vis + "private";
            prefix = " ";
        }
        if (member.isStatic()) {
            vis = vis + prefix;
            vis = vis + "static";
            prefix = " ";
        }
        if (member.isFinal()) {
            vis = vis + prefix;
            vis = vis + "final";
            prefix = " ";
        }
        return vis;
    }

    protected boolean assertNotImpl(Type type, boolean quiet, ContextStack stack, CompoundType enclosing, boolean dataMember) {
        if (type.isType(65536)) {
            int constraint = dataMember ? 28 : 21;
            CompoundType.failedConstraint(constraint, quiet, stack, type, enclosing.getName());
            return false;
        }
        return true;
    }

    public class Member
    implements ContextElement,
    Cloneable {
        private Type type;
        private String vis;
        private String value;
        private String name;
        private String idlName;
        private boolean innerClassDecl;
        private boolean constant;
        private MemberDefinition member;
        private boolean forceTransient;

        public String getElementName() {
            return "\"" + this.getName() + "\"";
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getIDLName() {
            return this.idlName;
        }

        public String getVisibility() {
            return this.vis;
        }

        public boolean isPublic() {
            return this.member.isPublic();
        }

        public boolean isPrivate() {
            return this.member.isPrivate();
        }

        public boolean isStatic() {
            return this.member.isStatic();
        }

        public boolean isFinal() {
            return this.member.isFinal();
        }

        public boolean isTransient() {
            if (this.forceTransient) {
                return true;
            }
            return this.member.isTransient();
        }

        public String getValue() {
            return this.value;
        }

        public boolean isInnerClassDeclaration() {
            return this.innerClassDecl;
        }

        public boolean isConstant() {
            return this.constant;
        }

        public String toString() {
            String result = this.type.toString();
            if (this.value != null) {
                result = result + " = " + this.value;
            }
            return result;
        }

        protected void swapInvalidTypes() {
            if (this.type.getStatus() != 1) {
                this.type = CompoundType.this.getValidType(this.type);
            }
        }

        protected void setTransient() {
            if (!this.isTransient()) {
                this.forceTransient = true;
                this.vis = this.vis.length() > 0 ? this.vis + " transient" : "transient";
            }
        }

        protected MemberDefinition getMemberDefinition() {
            return this.member;
        }

        public void destroy() {
            if (this.type != null) {
                this.type.destroy();
                this.type = null;
                this.vis = null;
                this.value = null;
                this.name = null;
                this.idlName = null;
                this.member = null;
            }
        }

        public Member(MemberDefinition member, String value, ContextStack stack, CompoundType enclosing) {
            this.member = member;
            this.value = value;
            this.forceTransient = false;
            boolean bl = this.innerClassDecl = member.getInnerClass() != null;
            if (!this.innerClassDecl) {
                this.init(stack, enclosing);
            }
        }

        public void init(ContextStack stack, CompoundType enclosing) {
            this.constant = false;
            this.name = this.member.getName().toString();
            this.vis = CompoundType.getVisibilityString(this.member);
            this.idlName = null;
            int contextCode = 6;
            stack.setNewContextCode(contextCode);
            if (this.member.isVariable()) {
                if (this.value != null && this.member.isConstant()) {
                    contextCode = 7;
                    this.constant = true;
                } else if (this.member.isStatic()) {
                    contextCode = 8;
                } else if (this.member.isTransient()) {
                    contextCode = 9;
                }
            }
            stack.setNewContextCode(contextCode);
            stack.push(this);
            this.type = CompoundType.makeType(this.member.getType(), null, stack);
            if (this.type == null || !this.innerClassDecl && !this.member.isStatic() && !this.member.isTransient() && !CompoundType.this.assertNotImpl(this.type, false, stack, enclosing, true)) {
                stack.pop(false);
                throw new CompilerError("");
            }
            if (this.constant && this.type.isPrimitive()) {
                if (this.type.isType(64) || this.type.isType(128) || this.type.isType(256)) {
                    int length = this.value.length();
                    char lastChar = this.value.charAt(length - 1);
                    if (!Character.isDigit(lastChar)) {
                        this.value = this.value.substring(0, length - 1);
                    }
                } else if (this.type.isType(2)) {
                    this.value = this.value.toUpperCase();
                }
            }
            if (this.constant && this.type.isType(512)) {
                this.value = "L" + this.value;
            }
            stack.pop(true);
        }

        public void setIDLName(String name) {
            this.idlName = name;
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("clone failed");
            }
        }
    }

    public class Method
    implements ContextElement,
    Cloneable {
        private MemberDefinition memberDef;
        private CompoundType enclosing;
        private ValueType[] exceptions;
        private ValueType[] implExceptions;
        private Type returnType;
        private Type[] arguments;
        private String[] argumentNames;
        private String vis;
        private String name;
        private String idlName;
        private String stringRep = null;
        private int attributeKind = 0;
        private String attributeName = null;
        private int attributePairIndex = -1;
        private Identifier declaredBy = null;

        public boolean isInherited() {
            return this.declaredBy != this.enclosing.getIdentifier();
        }

        public boolean isAttribute() {
            return this.attributeKind != 0;
        }

        public boolean isReadWriteAttribute() {
            return this.attributeKind == 3 || this.attributeKind == 4;
        }

        public int getAttributeKind() {
            return this.attributeKind;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public int getAttributePairIndex() {
            return this.attributePairIndex;
        }

        public String getElementName() {
            return this.memberDef.toString();
        }

        public boolean equals(Object obj) {
            Method other = (Method)obj;
            if (this.getName().equals(other.getName()) && this.arguments.length == other.arguments.length) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    if (this.arguments[i].equals(other.arguments[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public Method mergeWith(Method other) {
            if (!this.equals(other)) {
                CompoundType.this.env.error(0L, "attempt to merge method failed:", this.getName(), this.enclosing.getClassDefinition().getName());
            }
            Vector legalExceptions = new Vector();
            try {
                this.collectCompatibleExceptions(other.exceptions, this.exceptions, legalExceptions);
                this.collectCompatibleExceptions(this.exceptions, other.exceptions, legalExceptions);
            }
            catch (ClassNotFound e) {
                CompoundType.this.env.error(0L, "class.not.found", e.name, this.enclosing.getClassDefinition().getName());
                return null;
            }
            Method merged = (Method)this.clone();
            merged.exceptions = new ValueType[legalExceptions.size()];
            legalExceptions.copyInto(merged.exceptions);
            merged.implExceptions = merged.exceptions;
            return merged;
        }

        private void collectCompatibleExceptions(ValueType[] from, ValueType[] with, Vector list) throws ClassNotFound {
            block0: for (int i = 0; i < from.length; ++i) {
                ClassDefinition exceptionDef = from[i].getClassDefinition();
                if (list.contains(from[i])) continue;
                for (int j = 0; j < with.length; ++j) {
                    if (!exceptionDef.subClassOf((Environment)this.enclosing.getEnv(), with[j].getClassDeclaration())) continue;
                    list.addElement(from[i]);
                    continue block0;
                }
            }
        }

        public CompoundType getEnclosing() {
            return this.enclosing;
        }

        public Identifier getDeclaredBy() {
            return this.declaredBy;
        }

        public String getVisibility() {
            return this.vis;
        }

        public boolean isPublic() {
            return this.memberDef.isPublic();
        }

        public boolean isProtected() {
            return this.memberDef.isPrivate();
        }

        public boolean isPrivate() {
            return this.memberDef.isPrivate();
        }

        public boolean isStatic() {
            return this.memberDef.isStatic();
        }

        public String getName() {
            return this.name;
        }

        public String getIDLName() {
            return this.idlName;
        }

        public sun.tools.java.Type getType() {
            return this.memberDef.getType();
        }

        public boolean isConstructor() {
            return this.memberDef.isConstructor();
        }

        public boolean isNormalMethod() {
            return !this.memberDef.isConstructor() && this.attributeKind == 0;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public Type[] getArguments() {
            return (Type[])this.arguments.clone();
        }

        public String[] getArgumentNames() {
            return this.argumentNames;
        }

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public ValueType[] getExceptions() {
            return (ValueType[])this.exceptions.clone();
        }

        public ValueType[] getImplExceptions() {
            return (ValueType[])this.implExceptions.clone();
        }

        public ValueType[] getUniqueCatchList(ValueType[] list) {
            ValueType[] result = list;
            int newSize = list.length;
            try {
                int i;
                for (i = 0; i < list.length; ++i) {
                    ClassDeclaration decl = list[i].getClassDeclaration();
                    if (!CompoundType.this.env.defRemoteException.superClassOf((Environment)CompoundType.this.env, decl) && !CompoundType.this.env.defRuntimeException.superClassOf((Environment)CompoundType.this.env, decl) && !CompoundType.this.env.defError.superClassOf((Environment)CompoundType.this.env, decl)) continue;
                    list[i] = null;
                    --newSize;
                }
                for (i = 0; i < list.length; ++i) {
                    if (list[i] == null) continue;
                    ClassDefinition current = list[i].getClassDefinition();
                    for (int j = 0; j < list.length; ++j) {
                        if (j == i || list[i] == null || list[j] == null || !current.superClassOf((Environment)CompoundType.this.env, list[j].getClassDeclaration())) continue;
                        list[j] = null;
                        --newSize;
                    }
                }
            }
            catch (ClassNotFound e) {
                Type.classNotFound(CompoundType.this.stack, e);
            }
            if (newSize < list.length) {
                ValueType[] temp = new ValueType[newSize];
                int offset = 0;
                for (int i = 0; i < list.length; ++i) {
                    if (list[i] == null) continue;
                    temp[offset++] = list[i];
                }
                list = temp;
            }
            if (list.length == 0) {
                return null;
            }
            return list;
        }

        public ValueType[] getFilteredStubExceptions(ValueType[] list) {
            ValueType[] result = list;
            int newSize = list.length;
            try {
                for (int i = 0; i < list.length; ++i) {
                    ClassDeclaration decl = list[i].getClassDeclaration();
                    if ((!CompoundType.this.env.defRemoteException.superClassOf((Environment)CompoundType.this.env, decl) || CompoundType.this.env.defRemoteException.getClassDeclaration().equals((Object)decl)) && !CompoundType.this.env.defRuntimeException.superClassOf((Environment)CompoundType.this.env, decl) && !CompoundType.this.env.defError.superClassOf((Environment)CompoundType.this.env, decl)) continue;
                    list[i] = null;
                    --newSize;
                }
            }
            catch (ClassNotFound e) {
                Type.classNotFound(CompoundType.this.stack, e);
            }
            if (newSize < list.length) {
                ValueType[] temp = new ValueType[newSize];
                int offset = 0;
                for (int i = 0; i < list.length; ++i) {
                    if (list[i] == null) continue;
                    temp[offset++] = list[i];
                }
                list = temp;
            }
            return list;
        }

        public String toString() {
            if (this.stringRep == null) {
                int i;
                StringBuffer result = new StringBuffer(this.returnType.toString());
                result.append(" ");
                result.append(this.getName());
                result.append(" (");
                for (i = 0; i < this.arguments.length; ++i) {
                    if (i > 0) {
                        result.append(", ");
                    }
                    result.append(this.arguments[i]);
                    result.append(" ");
                    result.append(this.argumentNames[i]);
                }
                result.append(")");
                for (i = 0; i < this.exceptions.length; ++i) {
                    if (i == 0) {
                        result.append(" throws ");
                    } else {
                        result.append(", ");
                    }
                    result.append(this.exceptions[i]);
                }
                result.append(";");
                this.stringRep = result.toString();
            }
            return this.stringRep;
        }

        public void setAttributeKind(int kind) {
            this.attributeKind = kind;
        }

        public void setAttributePairIndex(int index) {
            this.attributePairIndex = index;
        }

        public void setAttributeName(String name) {
            this.attributeName = name;
        }

        public void setIDLName(String idlName) {
            this.idlName = idlName;
        }

        public void setImplExceptions(ValueType[] exceptions) {
            this.implExceptions = exceptions;
        }

        public void setDeclaredBy(Identifier by) {
            this.declaredBy = by;
        }

        protected void swapInvalidTypes() {
            int i;
            if (this.returnType.getStatus() != 1) {
                this.returnType = CompoundType.this.getValidType(this.returnType);
            }
            for (i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].getStatus() == 1) continue;
                this.arguments[i] = CompoundType.this.getValidType(this.arguments[i]);
            }
            for (i = 0; i < this.exceptions.length; ++i) {
                if (this.exceptions[i].getStatus() == 1) continue;
                this.exceptions[i] = (ValueType)CompoundType.this.getValidType(this.exceptions[i]);
            }
            for (i = 0; i < this.implExceptions.length; ++i) {
                if (this.implExceptions[i].getStatus() == 1) continue;
                this.implExceptions[i] = (ValueType)CompoundType.this.getValidType(this.implExceptions[i]);
            }
        }

        public void destroy() {
            if (this.memberDef != null) {
                int i;
                this.memberDef = null;
                this.enclosing = null;
                if (this.exceptions != null) {
                    for (i = 0; i < this.exceptions.length; ++i) {
                        if (this.exceptions[i] != null) {
                            this.exceptions[i].destroy();
                        }
                        this.exceptions[i] = null;
                    }
                    this.exceptions = null;
                }
                if (this.implExceptions != null) {
                    for (i = 0; i < this.implExceptions.length; ++i) {
                        if (this.implExceptions[i] != null) {
                            this.implExceptions[i].destroy();
                        }
                        this.implExceptions[i] = null;
                    }
                    this.implExceptions = null;
                }
                if (this.returnType != null) {
                    this.returnType.destroy();
                }
                this.returnType = null;
                if (this.arguments != null) {
                    for (i = 0; i < this.arguments.length; ++i) {
                        if (this.arguments[i] != null) {
                            this.arguments[i].destroy();
                        }
                        this.arguments[i] = null;
                    }
                    this.arguments = null;
                }
                if (this.argumentNames != null) {
                    for (i = 0; i < this.argumentNames.length; ++i) {
                        this.argumentNames[i] = null;
                    }
                    this.argumentNames = null;
                }
                this.vis = null;
                this.name = null;
                this.idlName = null;
                this.stringRep = null;
                this.attributeName = null;
                this.declaredBy = null;
            }
        }

        private String makeArgName(int argNum, Type type) {
            return "arg" + argNum;
        }

        public Method(CompoundType enclosing, MemberDefinition memberDef, boolean quiet, ContextStack stack) throws Exception {
            this.enclosing = enclosing;
            this.memberDef = memberDef;
            this.vis = CompoundType.getVisibilityString(memberDef);
            this.idlName = null;
            boolean valid = true;
            this.declaredBy = memberDef.getClassDeclaration().getName();
            this.name = memberDef.getName().toString();
            stack.setNewContextCode(2);
            stack.push(this);
            stack.setNewContextCode(3);
            sun.tools.java.Type methodType = memberDef.getType();
            sun.tools.java.Type rtnType = methodType.getReturnType();
            if (rtnType == sun.tools.java.Type.tVoid) {
                this.returnType = PrimitiveType.forPrimitive(rtnType, stack);
            } else {
                this.returnType = CompoundType.makeType(rtnType, null, stack);
                if (this.returnType == null || !CompoundType.this.assertNotImpl(this.returnType, quiet, stack, enclosing, false)) {
                    valid = false;
                    Type.failedConstraint(24, quiet, stack, enclosing.getName());
                }
            }
            stack.setNewContextCode(4);
            sun.tools.java.Type[] args = memberDef.getType().getArgumentTypes();
            this.arguments = new Type[args.length];
            this.argumentNames = new String[args.length];
            Vector origArgNames = memberDef.getArguments();
            for (int i = 0; i < args.length; ++i) {
                Type type = null;
                try {
                    type = CompoundType.makeType(args[i], null, stack);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (type != null) {
                    if (!CompoundType.this.assertNotImpl(type, quiet, stack, enclosing, false)) {
                        valid = false;
                        continue;
                    }
                    this.arguments[i] = type;
                    if (origArgNames != null) {
                        LocalMember local = (LocalMember)origArgNames.elementAt(i + 1);
                        this.argumentNames[i] = local.getName().toString();
                        continue;
                    }
                    this.argumentNames[i] = this.makeArgName(i, type);
                    continue;
                }
                valid = false;
                Type.failedConstraint(25, false, stack, enclosing.getQualifiedName(), this.name);
            }
            if (!valid) {
                stack.pop(false);
                throw new Exception();
            }
            try {
                this.exceptions = enclosing.getMethodExceptions(memberDef, quiet, stack);
                this.implExceptions = this.exceptions;
                stack.pop(true);
            }
            catch (Exception e) {
                stack.pop(false);
                throw new Exception();
            }
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("clone failed");
            }
        }
    }
}

