/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;

public class PrintGenerator
implements Generator,
Constants {
    private static final int JAVA = 0;
    private static final int IDL = 1;
    private static final int BOTH = 2;
    private int whatToPrint;
    private boolean global = false;
    private boolean qualified = false;
    private boolean trace = false;
    private boolean valueMethods = false;
    private IndentingWriter out;

    public PrintGenerator() {
        OutputStreamWriter writer = new OutputStreamWriter(System.out);
        this.out = new IndentingWriter(writer);
    }

    public boolean parseArgs(String[] argv, Main main) {
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i] == null) continue;
            String arg = argv[i].toLowerCase();
            if (arg.equals("-xprint")) {
                this.whatToPrint = 0;
                argv[i] = null;
                if (i + 1 >= argv.length) continue;
                if (argv[i + 1].equalsIgnoreCase("idl")) {
                    argv[++i] = null;
                    this.whatToPrint = 1;
                    continue;
                }
                if (!argv[i + 1].equalsIgnoreCase("both")) continue;
                argv[++i] = null;
                this.whatToPrint = 2;
                continue;
            }
            if (arg.equals("-xglobal")) {
                this.global = true;
                argv[i] = null;
                continue;
            }
            if (arg.equals("-xqualified")) {
                this.qualified = true;
                argv[i] = null;
                continue;
            }
            if (arg.equals("-xtrace")) {
                this.trace = true;
                argv[i] = null;
                continue;
            }
            if (!arg.equals("-xvaluemethods")) continue;
            this.valueMethods = true;
            argv[i] = null;
        }
        return true;
    }

    public void generate(sun.rmi.rmic.BatchEnvironment env, ClassDefinition cdef, File destDir) {
        CompoundType topType;
        BatchEnvironment ourEnv = (BatchEnvironment)env;
        ContextStack stack = new ContextStack(ourEnv);
        stack.setTrace(this.trace);
        if (this.valueMethods) {
            ourEnv.setParseNonConforming(true);
        }
        if ((topType = CompoundType.forCompound(cdef, stack)) != null) {
            try {
                Type[] theTypes = topType.collectMatching(0x2000000);
                block7: for (int i = 0; i < theTypes.length; ++i) {
                    this.out.pln("\n-----------------------------------------------------------\n");
                    Type theType = theTypes[i];
                    switch (this.whatToPrint) {
                        case 0: {
                            theType.println(this.out, this.qualified, false, false);
                            continue block7;
                        }
                        case 1: {
                            theType.println(this.out, this.qualified, true, this.global);
                            continue block7;
                        }
                        case 2: {
                            theType.println(this.out, this.qualified, false, false);
                            theType.println(this.out, this.qualified, true, this.global);
                            continue block7;
                        }
                        default: {
                            throw new CompilerError("Unknown type!");
                        }
                    }
                }
                this.out.flush();
            }
            catch (IOException e) {
                throw new CompilerError("PrintGenerator caught " + e);
            }
        }
    }
}

