/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.bean;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.jbi.jsf.bean.ListBean;
import com.sun.jbi.jsf.bean.SelectableJBIComponentInfo;
import com.sun.jbi.jsf.bean.SelectableJBIServiceAssemblyInfo;
import com.sun.jbi.jsf.bean.SelectableTargetInfo;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class ShowBean {
    private Logger sLog = JBILogger.getInstance();
    private static final String DEFAULT_RESULT = "";
    private JBIAdminCommands mJac;
    private String mName;
    private String mType;
    private List mTargetsList = new ArrayList();
    private String mFilterTargetComponentState = "Show All";
    private ArrayList mFilterTargetComponentStates = null;
    private String mFilterTargetAssemblyState = "Show All";
    private ArrayList mFilterTargetAssemblyStates = null;
    private String[] mTargetNames = null;
    private String[] mOriginalTargetNames = null;

    public ShowBean() {
        this.mJac = BeanUtilities.getClient();
    }

    public String check(String aTarget) {
        String NO_STATE_CHECK = null;
        String NO_LIBRARY_CHECK = null;
        String NO_COMPONENT_CHECK = null;
        String NO_DEPLOYMENT_CHECK = null;
        this.sLog.fine("ShowBean.check(" + aTarget + ")");
        String result = null;
        String queryResult = null;
        boolean isServiceAssembly = false;
        boolean isSharedLibrary = false;
        if (null != this.mJac) {
            try {
                if ("binding-component".equals(this.mType)) {
                    queryResult = this.mJac.showBindingComponent(this.mName, NO_STATE_CHECK, NO_LIBRARY_CHECK, NO_DEPLOYMENT_CHECK, aTarget);
                } else if ("service-engine".equals(this.mType)) {
                    queryResult = this.mJac.showServiceEngine(this.mName, NO_STATE_CHECK, NO_LIBRARY_CHECK, NO_DEPLOYMENT_CHECK, aTarget);
                } else if ("service-assembly".equals(this.mType)) {
                    queryResult = this.mJac.showServiceAssembly(this.mName, NO_STATE_CHECK, NO_COMPONENT_CHECK, aTarget);
                    isServiceAssembly = true;
                } else if ("shared-library".equals(this.mType)) {
                    queryResult = this.mJac.showSharedLibrary(this.mName, NO_COMPONENT_CHECK, aTarget);
                    isSharedLibrary = true;
                } else {
                    this.sLog.fine("ShowBean.check--unrecognized mType=" + this.mType);
                }
                if (null != queryResult) {
                    this.sLog.fine("ShowBean.check(" + aTarget + "), queryResult=" + queryResult);
                    List list = null;
                    if (isServiceAssembly) {
                        list = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)queryResult);
                        if (1 == list.size()) {
                            ServiceAssemblyInfo saInfo = (ServiceAssemblyInfo)list.get(0);
                            String state = saInfo.getState();
                            result = "Started".equals(state) ? I18nUtilities.getResourceString("jbi.operations.comp.started") : "Disabled(" + state + ")";
                        }
                    } else {
                        list = JBIComponentInfo.readFromXmlText((String)queryResult);
                        if (1 == list.size()) {
                            String state;
                            JBIComponentInfo compInfo = (JBIComponentInfo)list.get(0);
                            result = isSharedLibrary ? I18nUtilities.getResourceString("jbi.operations.start.enabled") : ("Started".equals(state = compInfo.getState()) ? I18nUtilities.getResourceString("jbi.operations.comp.started") : ("Stopped".equals(state) ? I18nUtilities.getResourceString("jbi.operations.comp.stopped") : ("Shutdown".equals(state) ? I18nUtilities.getResourceString("jbi.operations.comp.shutdown") : I18nUtilities.getResourceString("jbi.operations.comp.state.unknown"))));
                        }
                    }
                }
            }
            catch (JBIRemoteException jbiRemoteEx) {
                // empty catch block
            }
        }
        this.sLog.fine("check(" + aTarget + "), mName=" + this.mName + ", mType=" + this.mType + ", queryResult=" + queryResult + ", result = " + result);
        return result;
    }

    public String getDeploymentOrInstallationDescriptor() {
        String result = DEFAULT_RESULT;
        result = this.queryDeploymentOrInstallationDescriptor();
        this.sLog.fine("ShowBean.getDeploymentOrInstallationDescriptor(),result=" + result);
        return result;
    }

    public String getDescription() {
        String result = DEFAULT_RESULT;
        result = this.queryDescription();
        this.sLog.fine("ShowBean.getDescription(), result=" + result);
        return result;
    }

    public String getName() {
        this.sLog.fine("ShowBean.getName(), mName=" + this.mName);
        return this.mName;
    }

    public TableDataProvider getSharedTargetsTableData() {
        this.sLog.fine("ShowBean.getSharedTargetsTableData()");
        ObjectListDataProvider result = new ObjectListDataProvider(this.mTargetsList);
        this.sLog.fine("ShowBean.getSharedTargetsTableData(): result=" + result);
        return result;
    }

    public List getTargetsList() {
        this.sLog.fine("ShowBean.getTargetsList(), mTargetsList=" + this.mTargetsList);
        return this.mTargetsList;
    }

    public String getType() {
        this.sLog.fine("ShowBean.getType(), mType=" + this.mType);
        return this.mType;
    }

    public void initTargetNames() {
        List targets = this.getTargetsList();
        this.mTargetNames = new String[targets.size()];
        this.mOriginalTargetNames = new String[targets.size()];
        for (int i = 0; i < targets.size(); ++i) {
            SelectableTargetInfo tgtInfo = (SelectableTargetInfo)targets.get(i);
            this.mTargetNames[i] = tgtInfo.getName();
            this.mOriginalTargetNames[i] = tgtInfo.getName();
        }
    }

    public String[] getTargetNames() {
        return this.mTargetNames;
    }

    public String[] getOriginalTargetNames() {
        return this.mOriginalTargetNames;
    }

    public void setDeploymentOrInstallationDescriptor(String ignored) {
        throw new RuntimeException("ShowBean.setDesploymnetOrInstallationDescriptor(String)not supported (read-only property)");
    }

    public void setDescription(String ignored) {
        throw new RuntimeException("ShowBean.setDescription(String) not supported (read-only property)");
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public void setTargetsList(List aTargetsList) {
        this.sLog.fine("ShowBean.setTargetsList(" + aTargetsList + ")");
        this.mTargetsList = aTargetsList;
    }

    public void setType(String aType) {
        this.mType = aType;
    }

    public void setTargetNames(String[] aTargetNames) {
        this.mTargetNames = aTargetNames;
    }

    private String queryDeploymentOrInstallationDescriptor() {
        String result = DEFAULT_RESULT;
        String descriptor = DEFAULT_RESULT;
        try {
            JBIAdminCommands client = BeanUtilities.getClient();
            if (null != client) {
                this.sLog.fine("ShowBean.queryDeploymentOrInstallationDescriptor(), client=" + client + ", mType=" + this.mType + ", mName=" + this.mName);
                if ("binding-component".equals(this.mType) || "service-engine".equals(this.mType)) {
                    descriptor = client.getComponentInstallationDescriptor(this.mName);
                } else if ("shared-library".equals(this.mType)) {
                    descriptor = client.getSharedLibraryInstallationDescriptor(this.mName);
                } else if ("service-assembly".equals(this.mType)) {
                    descriptor = client.getServiceAssemblyDeploymentDescriptor(this.mName);
                }
                result = descriptor;
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            this.sLog.fine("ShowBeanqueryDeploymentOrInstallationDescriptor(), caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
            jbiRemoteEx.printStackTrace();
        }
        this.sLog.fine("ShowBean.queryDeploymentOrInstallationDescriptor(), result=" + result);
        return result;
    }

    private String queryDescription() {
        String result = DEFAULT_RESULT;
        ListBean listBean = BeanUtilities.getListBean();
        this.sLog.fine("ShowBean.queryDeploymentOrInstallationDescriptor(), mType=" + this.mType);
        if ("binding-component".equals(this.mType)) {
            List<SelectableJBIComponentInfo> bindings = listBean.getBindingComponentsInfoList(this.mFilterTargetComponentState, this.mFilterTargetComponentStates);
            result = ListBean.findDescription(this.mName, bindings);
        } else if ("service-assembly".equals(this.mType)) {
            List<SelectableJBIServiceAssemblyInfo> deployments = listBean.getServiceAssembliesInfoList(this.mFilterTargetAssemblyState, this.mFilterTargetAssemblyStates);
            result = ListBean.findDescription(this.mName, deployments);
        } else if ("service-engine".equals(this.mType)) {
            List<SelectableJBIComponentInfo> engines = listBean.getServiceEnginesInfoList(this.mFilterTargetComponentState, this.mFilterTargetComponentStates);
            result = ListBean.findDescription(this.mName, engines);
        } else if ("shared-library".equals(this.mType)) {
            List<SelectableJBIComponentInfo> libraries = listBean.getSharedLibrariesInfoList();
            result = ListBean.findDescription(this.mName, libraries);
        }
        this.sLog.fine("ShowBean.queryDescription(), result=" + result);
        return result;
    }

    public void setFilterTargetComponentState(String filterState) {
        this.mFilterTargetComponentState = filterState;
    }

    public void setFilterTargetComponentState(String filterState, String filterStates) {
        this.mFilterTargetComponentState = filterState;
        filterStates = filterStates.replace('[', ' ');
        filterStates = filterStates.replace(']', ' ');
        String[] states = filterStates.split("\\,");
        for (int i = 0; i < states.length; ++i) {
            states[i] = states[i].trim();
        }
        this.mFilterTargetComponentStates = new ArrayList<String>(Arrays.asList(states));
    }

    public String getFilterTargetComponentState() {
        return this.mFilterTargetComponentState;
    }

    public ArrayList getFilterTargetComponentStates() {
        return this.mFilterTargetComponentStates;
    }

    public void setFilterTargetAssemblyState(String filterState) {
        this.mFilterTargetAssemblyState = filterState;
    }

    public void setFilterTargetAssemblyState(String filterState, String filterStates) {
        this.mFilterTargetAssemblyState = filterState;
        filterStates = filterStates.replace('[', ' ');
        filterStates = filterStates.replace(']', ' ');
        String[] states = filterStates.split("\\,");
        for (int i = 0; i < states.length; ++i) {
            states[i] = states[i].trim();
        }
        this.mFilterTargetAssemblyStates = new ArrayList<String>(Arrays.asList(states));
    }

    public String getFilterTargetAssemblyState() {
        return this.mFilterTargetAssemblyState;
    }

    public ArrayList getFilterTargetAssemblyStates() {
        return this.mFilterTargetAssemblyStates;
    }
}

