/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.common;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Util {
    public static String replaceInvalidChars(String value) {
        return value.replaceAll("\\.", "_");
    }

    public static String fixupName(String name, String prefix) {
        if (name.startsWith(prefix)) {
            return name.substring(prefix.length() + 1);
        }
        return name;
    }

    public static String mapType(String type) {
        String rtype = type;
        if ("binding-component".equals(type)) {
            rtype = "bindingComponents";
        } else if ("service-engine".equals(type)) {
            rtype = "serviceEngines";
        } else if ("service-unit".equals(type)) {
            rtype = "serviceUnits";
        }
        return rtype;
    }

    public static String convertType(Object type) {
        String ctype = "";
        ctype = type instanceof Boolean ? type.toString() : type + "";
        return ctype;
    }

    public static String mapComponentValue(String containerValue, String componentValue) {
        if ("_s_".equals(containerValue)) {
            return componentValue;
        }
        return containerValue;
    }

    public static String mapInstalledType(String type) {
        String rtype = type;
        if ("service-engine".equals(type)) {
            rtype = "Engine";
        } else if ("binding-component".equals(type)) {
            rtype = "Binding";
        }
        return rtype;
    }

    public static String trimRight(String str, String token) {
        String result = "";
        if (str != null) {
            result = str.substring(0, str.lastIndexOf(token));
        }
        return result;
    }

    public static String trimLeft(String str, String token) {
        int index;
        String result = str;
        if (str != null && (index = str.indexOf(token)) >= 0) {
            result = str.substring(index + token.length());
        }
        return result;
    }

    public static String trimLeft2(String str, String token) {
        String result = "";
        if (str != null) {
            int index = str.indexOf(token);
            result = index >= 0 ? str.substring(token.length()) : str;
        }
        return result;
    }

    public static String getNamespace(String endpoint, String token) {
        String result = "";
        if (endpoint != null) {
            result = endpoint.substring(0, endpoint.indexOf(token));
        }
        return result;
    }

    public static Map getNameSpaces(Node root) {
        HashMap<String, String> map = new HashMap<String, String>();
        NamedNodeMap attributes = root.getAttributes();
        if (attributes.getLength() == 0) {
            return map;
        }
        for (int index = 0; index < attributes.getLength(); ++index) {
            Attr attrib = (Attr)attributes.item(index);
            String attibuteName = attrib.getNodeName();
            int nameSpaceDelimiter = attibuteName.indexOf(":");
            if (nameSpaceDelimiter == -1) continue;
            map.put(attibuteName.substring(nameSpaceDelimiter + 1, attibuteName.length()), attrib.getValue());
        }
        return map;
    }

    public static String resolveNameSpace(Map nameSpace, String qName) {
        int nameSpaceDelimiter = qName.indexOf(":");
        if (nameSpaceDelimiter == -1) {
            return qName;
        }
        String ns = qName.substring(0, nameSpaceDelimiter);
        return nameSpace.get(ns) + "^" + qName.substring(nameSpaceDelimiter + 1, qName.length());
    }

    public static Element getXMLDocumentRoot(ZipFile file, String entryName) throws Exception {
        ZipEntry ze = file.getEntry(entryName);
        InputSource is = new InputSource(file.getInputStream(ze));
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xmlDoc = db.parse(is);
        Element root = xmlDoc.getDocumentElement();
        return root;
    }

    public static Element getXMLDocumentRoot(String jbiFilePath) throws Exception {
        FileInputStream fis = new FileInputStream(jbiFilePath);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xmlDoc = db.parse(fis);
        Element root = xmlDoc.getDocumentElement();
        return root;
    }

    public static String getNodeTextValue(Node node) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node lNode = nl.item(i);
            if (lNode.getNodeType() != 3) continue;
            return lNode.getNodeValue();
        }
        return "";
    }
}

