/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.jbi.jsf.bean.ComponentConfigurationEntry;
import com.sun.jbi.jsf.bean.JBIComponentConfigBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jsftemplating.component.dataprovider.MultipleListDataProvider;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.TableRowGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConfigPropsTableHandler {
    private static Logger logger = Logger.getLogger(ComponentConfigPropsTableHandler.class.getName());

    public static void jbiGetSelectedTableRowKeys(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        RowKey[] keys = trg.getSelectedRowKeys();
        logger.fine("ComponentConfigPropsTableHandler.jbiGetSelectedTableRowKeys() = " + keys);
        handlerCtx.setOutputValue("rowKeys", (Object)keys);
    }

    public static void jbiDeleteTableRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        RowKey[] keys = (RowKey[])handlerCtx.getInputValue("rowKeys");
        logger.fine("ComponentConfigPropsTableHandler.jbiDeleteTableRows() = " + keys);
        ObjectListDataProvider dp = (ObjectListDataProvider)trg.getSourceData();
        for (RowKey key : keys) {
            dp.removeRow(key);
            logger.fine("delete Row with id = " + key.getRowId());
        }
    }

    public static void jbiCommitTableRowGroup(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        logger.fine("ComponentConfigPropsTableHandler.jbiCommitTableRowGroup() = " + trg);
        ObjectListDataProvider dp = (ObjectListDataProvider)trg.getSourceData();
        dp.commitChanges();
    }

    public static void getJBIComponentConfigTableList(HandlerContext handlerCtx) {
        JBIComponentConfigBean configBean = BeanUtilities.getJBIComponentConfigBean();
        ObjectListDataProvider provider = (ObjectListDataProvider)configBean.getComponentNewConfigurationData();
        List JbiXMLdata = provider.getList();
        ArrayList data = new ArrayList();
        logger.fine("ComponentConfigPropsTableHandler.getJBIComponentConfigTableList()");
        if (JbiXMLdata != null && JbiXMLdata.size() > 0) {
            for (ComponentConfigurationEntry entry : JbiXMLdata) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("name", entry.getName());
                oneRow.put("value", entry.getDefaultValue());
                oneRow.put("selected", false);
                oneRow.put("rendered", false);
                oneRow.put("disabled", true);
                data.add(oneRow);
                logger.fine("property name =" + entry.getName() + " def.  value =" + entry.getDefaultValue());
            }
        }
        handlerCtx.setOutputValue("TableList", data);
    }

    public static void jbiGetAllSingleMapRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
        List data = dp.getLists();
        if (null != data && 0 < data.size()) {
            logger.fine("ComponentConfigPropsTableHandler.jbiGetAllSingleMapRows() = " + data.get(0));
            handlerCtx.setOutputValue("Rows", data.get(0));
        }
    }

    public static void addRowToJBIComponentPropertiesTable(HandlerContext handlerCtx) {
        logger.fine("ComponentConfigPropsTableHandler.addRowToJBIComponentPropertiesTable()");
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        List names = (List)handlerCtx.getInputValue("NameList");
        List defaults = (List)handlerCtx.getInputValue("DefaultValueList");
        Boolean hasSelected = (Boolean)handlerCtx.getInputValue("HasSelected");
        MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
        List data = dp.getLists();
        ListIterator li = data.listIterator();
        while (li.hasNext()) {
            ListIterator ni;
            String name = null;
            String value = null;
            List list = (List)li.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (defaults != null && names != null) {
                if (names.size() == defaults.size()) {
                    ni = names.listIterator();
                    ListIterator dv = defaults.listIterator();
                    while (ni.hasNext() && dv.hasNext()) {
                        name = (String)ni.next();
                        value = (String)dv.next();
                        map.put(name, value);
                    }
                } else {
                    ni = names.listIterator();
                    while (ni.hasNext()) {
                        name = (String)ni.next();
                        map.put(name, " ");
                    }
                }
            }
            if (names != null && defaults == null) {
                ni = names.listIterator();
                while (ni.hasNext()) {
                    name = (String)ni.next();
                    map.put(name, " ");
                }
            }
            if (names == null && defaults == null) {
                map.put("name", " ");
                map.put("value", " ");
            }
            if (hasSelected == null) {
                map.put("selected", false);
            } else if (hasSelected.booleanValue()) {
                map.put("selected", false);
            }
            map.put("rendered", true);
            map.put("disabled", false);
            list.add(0, map);
            logger.fine("added property named =" + name + " with value = " + value);
        }
    }

    public static void getAddRemoveJBIComponentProps(HandlerContext handlerCtx) {
        logger.fine("ComponentConfigPropsTableHandler.getAddRemoveJBIComponentProps()");
        List newList = (List)handlerCtx.getInputValue("NewList");
        ArrayList names = (ArrayList)handlerCtx.getInputValue("NameList");
        JBIComponentConfigBean configBean = BeanUtilities.getJBIComponentConfigBean();
        ObjectListDataProvider provider = (ObjectListDataProvider)configBean.getComponentNewConfigurationData();
        List origList = provider.getList();
        ListIterator nli = newList.listIterator();
        ArrayList removeProps = new ArrayList();
        HashMap<String, String> addProps = new HashMap<String, String>();
        while (nli.hasNext()) {
            Map props = (Map)nli.next();
            if (!ComponentConfigPropsTableHandler.isOriginalEntry(origList, (String)props.get("name"))) {
                String name = (String)props.get("name");
                if (name == null || name.trim().equals("")) continue;
                addProps.put((String)props.get("name"), (String)props.get("value"));
                String value = (String)props.get("value");
                value = value == null ? "" : value;
                ComponentConfigurationEntry entry = new ComponentConfigurationEntry(name, value, value, true);
                origList.add(entry);
                logger.fine("add new  property named =" + props.get("name") + " with value=" + props.get("value"));
                continue;
            }
            ComponentConfigPropsTableHandler.UpdateOriginalEntry(origList, (String)props.get("name"), (String)props.get("value"));
            logger.fine("updating property named =" + props.get("name") + " with value=" + props.get("value"));
        }
        provider.commitChanges();
        handlerCtx.setOutputValue("AddProps", addProps);
        handlerCtx.setOutputValue("RemoveProps", removeProps);
    }

    public static void convertRowsToProperties(HandlerContext handlerCtx) {
        List newList = (List)handlerCtx.getInputValue("NewList");
        ListIterator li = newList.listIterator();
        HashMap<String, String> addProps = new HashMap<String, String>();
        while (li.hasNext()) {
            Map props = (Map)li.next();
            String name = (String)props.get("name");
            if (name == null || name.trim().equals("")) continue;
            addProps.put(name, (String)props.get("value"));
        }
        handlerCtx.setOutputValue("AddProps", addProps);
    }

    public static void getJBIComponentProperties(HandlerContext handlerCtx) {
        logger.fine("ComponentConfigPropsTableHandler.getJBIComponentProperties()");
        List newList = (List)handlerCtx.getInputValue("NewList");
        ListIterator li = newList.listIterator();
        Properties addProps = new Properties();
        while (li.hasNext()) {
            String value;
            Map props = (Map)li.next();
            String name = (String)props.get("name");
            if (name == null || name.trim().equals("") || (value = (String)props.get("value")) == null || value.trim().equals("")) continue;
            addProps.put(name, value);
            logger.fine("add to map property named =" + name + " and value=" + value);
        }
        handlerCtx.setOutputValue("AddProps", (Object)addProps);
    }

    private static boolean isOriginalEntry(List<ComponentConfigurationEntry> oldList, String newPropName) {
        for (ComponentConfigurationEntry entry : oldList) {
            if (!entry.getName().equals(newPropName)) continue;
            return true;
        }
        return false;
    }

    private static void UpdateOriginalEntry(List<ComponentConfigurationEntry> oldList, String propName, String newValue) {
        for (ComponentConfigurationEntry entry : oldList) {
            if (!entry.getName().equals(propName)) continue;
            entry.setNewValue(newValue);
        }
    }
}

