/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.util;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.client.JBIAdminCommandsClientFactory;
import com.sun.jbi.ui.common.JBIAdminCommands;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;

public final class ConnectionUtilities {
    private static Logger sLog = JBILogger.getInstance();
    private JBIAdminCommands mJac = null;

    public JBIAdminCommands getClient() {
        JBIAdminCommands result = null;
        result = null != this.mJac ? this.mJac : (this.mJac = this.tryLocalClient());
        sLog.fine("ConnectionUtilities.getClient(), result=" + result);
        return result;
    }

    private JBIAdminCommands tryLocalClient() {
        JBIAdminCommands result = null;
        MBeanServer defaultConnection = MBeanServerFactory.getMBeanServer();
        if (null != defaultConnection) {
            try {
                boolean DEFAULT_CONNECTION_REMOTE_FLAG = false;
                result = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)defaultConnection, (boolean)false);
                if (null != result && result.isJBIRuntimeEnabled()) {
                    sLog.fine("ConnectionUtilities.tryLocalClient(): local client found JBI runtime enabled");
                }
            }
            catch (Exception ex) {
                sLog.fine("ConnectionUtilities.tryLocalClient(): caught ex=" + ex);
                ex.printStackTrace(System.err);
            }
        }
        sLog.fine("ConnectionUtilities.tryLocalClient(), result=" + result);
        return result;
    }
}

