/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.http;

import com.sun.enterprise.admin.jmx.remote.UrlConnector;
import com.sun.enterprise.admin.jmx.remote.https.SunOneBasicHostNameVerifier;
import com.sun.enterprise.admin.jmx.remote.https.SunOneBasicX509TrustManager;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class HttpUrlConnector
extends UrlConnector {
    private HostnameVerifier hv = null;
    private X509TrustManager[] tms = null;
    private X509KeyManager[] kms = null;
    private SSLSocketFactory ssf = null;
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");

    public HttpUrlConnector(JMXServiceURL serviceUrl, Map environment) {
        super(serviceUrl, environment);
        this.hv = (HostnameVerifier)environment.get("HOSTNAME_VERIFIER_KEY");
        if (this.hv == null) {
            this.hv = new SunOneBasicHostNameVerifier(serviceUrl.getHost());
        }
        this.ssf = (SSLSocketFactory)environment.get("SSL_SOCKET_FACTORY");
        if (this.ssf == null) {
            Object tmgr = environment.get("TRUST_MANAGER_KEY");
            if (tmgr instanceof X509TrustManager[]) {
                this.tms = (X509TrustManager[])tmgr;
            } else if (tmgr instanceof X509TrustManager) {
                this.tms = new X509TrustManager[]{(X509TrustManager)tmgr};
            } else if (tmgr == null) {
                this.tms = new X509TrustManager[]{new SunOneBasicX509TrustManager(serviceUrl, environment)};
            }
            Object kmgr = environment.get("KEYMANAGER_KEY");
            if (kmgr instanceof X509KeyManager[]) {
                this.kms = (X509KeyManager[])kmgr;
            } else if (kmgr instanceof X509KeyManager) {
                this.kms = new X509KeyManager[]{(X509KeyManager)kmgr};
            }
        }
        this.initialize();
    }

    protected void validateJmxServiceUrl() throws RuntimeException {
    }

    protected void validateEnvironment() throws RuntimeException {
        super.validateEnvironment();
    }

    private void initialize() {
        if (this.ssf == null) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("SSLv3");
                sslContext.init(this.kms, this.tms, new SecureRandom());
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            if (sslContext != null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            }
        } else {
            HttpsURLConnection.setDefaultSSLSocketFactory(this.ssf);
        }
        HttpsURLConnection.setDefaultHostnameVerifier(this.hv);
    }
}

