/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RollBackAction {
    private String moduleID = null;
    private Map options = null;
    private int currentOperation = 0;
    private Map targetState = null;
    private Vector targetList = null;
    public static final int APP_REF_CREATED = 1;
    public static final int APP_STARTED = 2;
    public static final int APP_REF_DELETED = 3;
    public static final int APP_STOPPED = 4;
    public static final int DEPLOY_OPERATION = 1;
    public static final int UNDEPLOY_OPERATION = 2;
    public static final int CREATE_APP_REF_OPERATION = 3;
    public static final int DELETE_APP_REF_OPERATION = 4;

    public RollBackAction(int operation, String moduleID, Map options) {
        this.currentOperation = operation;
        this.moduleID = moduleID;
        this.options = options;
    }

    public void addTarget(SunTarget target, int state) {
        if (this.targetList == null) {
            this.targetList = new Vector();
            this.targetState = new HashMap();
        }
        this.targetState.put(target.getName(), new Integer(state));
        this.targetList.add(target);
    }

    public boolean rollback(ConnectionSource dasConnection, com.sun.enterprise.deployment.backend.DeploymentStatus rollbackStatus) {
        boolean retVal = false;
        switch (this.currentOperation) {
            case 1: {
                if (!this.stopModules(dasConnection, rollbackStatus)) {
                    return false;
                }
                if (!this.deleteAppRefs(dasConnection, rollbackStatus)) {
                    return false;
                }
                retVal = this.undeployModule(dasConnection, rollbackStatus);
                break;
            }
            case 3: {
                if (!this.stopModules(dasConnection, rollbackStatus)) {
                    return false;
                }
                retVal = this.deleteAppRefs(dasConnection, rollbackStatus);
                break;
            }
            case 2: {
                retVal = true;
                break;
            }
            case 4: {
                if (!this.createAppRefs(dasConnection, rollbackStatus)) {
                    return false;
                }
                retVal = this.startModules(dasConnection, rollbackStatus);
                break;
            }
        }
        return retVal;
    }

    private boolean undeployModule(ConnectionSource dasConnection, com.sun.enterprise.deployment.backend.DeploymentStatus rollbackStatus) {
        DeploymentMgr deplMgr = ProxyFactory.getInstance((ConnectionSource)dasConnection).getDomainRoot().getDeploymentMgr();
        Map undeployStatus = deplMgr.undeploy(this.moduleID, this.options);
        DeploymentStatus finalStatusFromMBean = DeploymentSupport.mapToDeploymentStatus((Map)undeployStatus);
        com.sun.enterprise.deployment.backend.DeploymentStatus tmp = DeploymentClientUtils.getDeploymentStatusFromAdminStatus(finalStatusFromMBean);
        rollbackStatus.addSubStage(tmp);
        return tmp == null || tmp.getStatus() >= 1;
    }

    private boolean deleteAppRefs(ConnectionSource dasConnection, com.sun.enterprise.deployment.backend.DeploymentStatus rollbackStatus) {
        if (this.targetList == null) {
            return true;
        }
        if ("true".equals(this.options.get("X-DeploymentMgr.Force"))) {
            this.options.put("X-DeploymentMgr.Cascade", "false");
        } else {
            this.options.put("X-DeploymentMgr.Cascade", "true");
        }
        try {
            SunTarget[] targetObjs = this.targetList.toArray(new SunTarget[this.targetList.size()]);
            for (int i = 0; i < targetObjs.length; ++i) {
                int state = (Integer)this.targetState.get(targetObjs[i].getName());
                if (state != 1) continue;
                com.sun.enterprise.deployment.backend.DeploymentStatus status = DeploymentClientUtils.deleteApplicationReference(dasConnection.getExistingMBeanServerConnection(), this.moduleID, targetObjs[i], this.options);
                rollbackStatus.addSubStage(status);
                if (status != null && status.getStatus() < 1) {
                    return false;
                }
                this.targetState.remove(targetObjs[i].getName());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean stopModules(ConnectionSource dasConnection, com.sun.enterprise.deployment.backend.DeploymentStatus rollbackStatus) {
        if (this.targetList == null) {
            return true;
        }
        HashMap<String, String> tmpOptions = new HashMap<String, String>();
        tmpOptions.putAll(this.options);
        tmpOptions.put("X-DeploymentMgr.Cascade", "true");
        tmpOptions.put("X-DeploymentMgr.Force", "true");
        try {
            SunTarget[] targetObjs = this.targetList.toArray(new SunTarget[this.targetList.size()]);
            for (int i = 0; i < targetObjs.length; ++i) {
                int state = (Integer)this.targetState.get(targetObjs[i].getName());
                if (state != 2) continue;
                com.sun.enterprise.deployment.backend.DeploymentStatus status = DeploymentClientUtils.stopApplication(dasConnection.getExistingMBeanServerConnection(), this.moduleID, targetObjs[i], tmpOptions);
                rollbackStatus.addSubStage(status);
                if (status != null && status.getStatus() < 1) {
                    return false;
                }
                this.targetState.put(targetObjs[i].getName(), new Integer(1));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean createAppRefs(ConnectionSource dasConnection, com.sun.enterprise.deployment.backend.DeploymentStatus rollbackStatus) {
        if (this.targetList == null) {
            return true;
        }
        try {
            SunTarget[] targetObjs = this.targetList.toArray(new SunTarget[this.targetList.size()]);
            for (int i = 0; i < targetObjs.length; ++i) {
                int state = (Integer)this.targetState.get(targetObjs[i].getName());
                if (state != 3) continue;
                com.sun.enterprise.deployment.backend.DeploymentStatus status = DeploymentClientUtils.createApplicationReference(dasConnection.getExistingMBeanServerConnection(), this.moduleID, targetObjs[i], this.options);
                rollbackStatus.addSubStage(status);
                if (status != null && status.getStatus() < 1) {
                    return false;
                }
                this.targetState.put(targetObjs[i].getName(), new Integer(4));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean startModules(ConnectionSource dasConnection, com.sun.enterprise.deployment.backend.DeploymentStatus rollbackStatus) {
        if (this.targetList == null) {
            return true;
        }
        try {
            SunTarget[] targetObjs = this.targetList.toArray(new SunTarget[this.targetList.size()]);
            for (int i = 0; i < targetObjs.length; ++i) {
                int state = (Integer)this.targetState.get(targetObjs[i].getName());
                if (state != 4) continue;
                com.sun.enterprise.deployment.backend.DeploymentStatus status = DeploymentClientUtils.startApplication(dasConnection.getExistingMBeanServerConnection(), this.moduleID, targetObjs[i], this.options);
                rollbackStatus.addSubStage(status);
                this.targetState.remove(targetObjs[i].getName());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

