/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.AuthSchemeInfo;
import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.BASE64Encoder;
import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.DefaultMapper;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocketFactory;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatClientHandlerImpl;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.Mapper;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.UnauthorizedSecurityException;
import com.sun.jdmk.internal.ClassLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public abstract class GenericHttpConnectorClient
implements RemoteMBeanServer,
HeartBeatClientHandler,
Serializable {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm", "GenericHttpConnectorClient");
    private OperationContext operationContext = null;
    transient Hashtable authSchemeInfoList = null;
    transient GenericHttpConnectorAddress httpConnAddr = null;
    transient GenericHttpSocketFactory factory = null;
    private transient boolean connected = false;
    private transient boolean supportsOperationContext = false;
    private String mbeanServerId = null;
    private transient Mapper mapper = null;
    private transient Mapper defaultMapper = null;
    private transient ClassLoader classloader = null;
    private transient Hashtable proxyHandles = new Hashtable();
    private transient Hashtable genericHandles = new Hashtable();
    private GenericHttpNotificationReceiver notificationReceiver = null;
    private ClientNotificationDispatcher notificationClientHandler = null;
    private HeartBeatClientHandlerImpl heartbeatClientHandler = null;
    private String localHost = null;

    abstract GenericHttpSocketFactory getSocketFactory();

    abstract GenericHttpNotificationReceiver getNotificationReceiver(GenericHttpConnectorClient var1, ClientNotificationDispatcher var2);

    public void setOperationContext(OperationContext c) {
        try {
            if (c != null) {
                c = (OperationContext)c.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new CommunicationException(e);
        }
        this.operationContext = c;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public GenericHttpConnectorClient() {
        if (System.getProperty("jdmk.hostname") != null) {
            this.localHost = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.localHost = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public GenericHttpConnectorClient(InetAddress addr) {
        try {
            this.localHost = addr == null ? (System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress()) : addr.getHostAddress();
        }
        catch (Exception e) {
            this.localHost = "localhost";
        }
        if (logger.finerOn()) {
            logger.finer("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    public GenericHttpConnectorClient(String addr) {
        if (addr != null) {
            this.localHost = addr;
        } else {
            try {
                this.localHost = System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                this.localHost = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("GenericHttpConnectorClient", "localHost=" + this.localHost);
        }
        this.Initialize();
    }

    private void Initialize() {
        this.factory = this.getSocketFactory();
        this.mapper = this.defaultMapper = new DefaultMapper();
        this.notificationClientHandler = new ClientNotificationDispatcher(new NotificationHandlerInternal(this));
        this.heartbeatClientHandler = new HeartBeatClientHandlerImpl(new HeartBeatInternalClientHandlerImpl(this), this.notificationClientHandler);
    }

    private String HMAC_MD5(byte[] challenge, byte[] key) {
        int i;
        int MD5_BLOCKSIZE = 64;
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            // empty catch block
        }
        if (key.length > 64) {
            key = md5.digest(key);
        }
        byte[] ipad = new byte[64];
        byte[] opad = new byte[64];
        for (i = 0; i < 64; ++i) {
            while (i < key.length) {
                ipad[i] = key[i];
                opad[i] = key[i];
                ++i;
            }
            ipad[i] = 0;
            opad[i] = 0;
        }
        i = 0;
        while (i < 64) {
            int n = i;
            ipad[n] = (byte)(ipad[n] ^ 0x36);
            int n2 = i++;
            opad[n2] = (byte)(opad[n2] ^ 0x5C);
        }
        md5.update(ipad);
        md5.update(challenge);
        byte[] digest = md5.digest();
        md5.update(opad);
        md5.update(digest);
        digest = md5.digest();
        StringBuffer digestString = new StringBuffer();
        for (i = 0; i < digest.length; ++i) {
            if ((digest[i] & 0xFF) < 16) {
                digestString.append("0" + Integer.toHexString(digest[i] & 0xFF));
                continue;
            }
            digestString.append(Integer.toHexString(digest[i] & 0xFF));
        }
        return digestString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream sendHttp(Object[] opList, boolean retry) throws Exception {
        if (this.authSchemeInfoList != null) {
            String challenge;
            AuthSchemeInfo authSchemeInfo;
            if (this.authSchemeInfoList.get(Thread.currentThread()) == null) {
                this.authSchemeInfoList.put(Thread.currentThread(), new AuthSchemeInfo("CRAM-MD5"));
            }
            if ((authSchemeInfo = (AuthSchemeInfo)this.authSchemeInfoList.get(Thread.currentThread())) != null && (challenge = authSchemeInfo.getChallenge()) != null) {
                String encoded_response = "";
                try {
                    challenge = challenge.substring((authSchemeInfo.getAuthScheme() + " ").length());
                    byte[] decoding = new BASE64Decoder().decodeBuffer(challenge);
                    String username = this.httpConnAddr.getAuthInfo().getLogin();
                    byte[] key = this.httpConnAddr.getAuthInfo().getPassword().getBytes();
                    String digest = this.HMAC_MD5(decoding, key);
                    String unencoded_response = username + " " + digest;
                    int maxBytesPerLine = 57;
                    String chunk = null;
                    int quotient = unencoded_response.length() / 57;
                    int modulus = unencoded_response.length() % 57;
                    for (int i = 0; i < quotient; ++i) {
                        chunk = unencoded_response.substring(i * 57, (i + 1) * 57);
                        encoded_response = encoded_response + new BASE64Encoder().encode(chunk.getBytes());
                    }
                    if (modulus > 0) {
                        chunk = unencoded_response.substring(quotient * 57);
                        encoded_response = encoded_response + new BASE64Encoder().encode(chunk.getBytes());
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                authSchemeInfo.setResponse(authSchemeInfo.getAuthScheme() + " " + encoded_response);
                authSchemeInfo.setChallenge(null);
            }
        }
        Socket socket = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(baos);
            if (this.operationContext != null && this.supportsOperationContext) {
                objOut.writeObject(this.operationContext);
            }
            for (int i = 0; i < opList.length; ++i) {
                objOut.writeObject(opList[i]);
            }
            try {
                socket = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
            }
            catch (SocketException se) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                socket = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
            }
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(baos.toByteArray());
            outputStream.flush();
            PushbackInputStream pushback = new PushbackInputStream(socket.getInputStream());
            int x = pushback.read();
            if (x >= 0) {
                pushback.unread(x);
            }
            PushbackInputStream pushbackInputStream = pushback;
            return pushbackInputStream;
        }
        catch (UnauthorizedSecurityException e) {
            if (this.authSchemeInfoList == null || retry) {
                throw e;
            }
            InputStream inputStream = this.sendHttp(opList, true);
            return inputStream;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                }
                finally {
                    socket = null;
                }
            }
        }
    }

    public String connect(ConnectorAddress mbeanServerAddress) {
        if (logger.finerOn()) {
            logger.finer("connect", "connect");
        }
        if (mbeanServerAddress == null) {
            throw new IllegalArgumentException("mbeanServerAddress cannot be null");
        }
        if (!(mbeanServerAddress instanceof GenericHttpConnectorAddress)) {
            throw new IllegalArgumentException("mbeanServerAddress must be an instance of GenericHttpConnectorAddress");
        }
        if (this.connected) {
            throw new CommunicationException("ConnectorClient already connected to RemoteMBeanServer");
        }
        this.httpConnAddr = (GenericHttpConnectorAddress)((GenericHttpConnectorAddress)mbeanServerAddress).clone();
        AuthInfo authInfo = this.httpConnAddr.getAuthInfo();
        if (authInfo != null) {
            if (authInfo.getLogin() == null || authInfo.getPassword() == null) {
                throw new IllegalArgumentException("Login/Password cannot be null");
            }
            this.authSchemeInfoList = new Hashtable();
        }
        this.supportsOperationContext = this.supports("OperationContext");
        String mbeanServerId2 = null;
        try {
            mbeanServerId2 = this.getMBeanServerId2();
        }
        catch (UnauthorizedSecurityException e) {
            throw e;
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e, "Connection failed");
        }
        if (this.mbeanServerId != null) {
            if (!this.mbeanServerId.equals(mbeanServerId2)) {
                throw new IllegalArgumentException("ConnectorClient trying to connect to a different RemoteMBeanServer");
            }
        } else {
            this.mbeanServerId = mbeanServerId2;
        }
        this.connected = true;
        this.heartbeatClientHandler.notifyConnectionEstablished();
        this.heartbeatClientHandler.startPinging();
        return this.mbeanServerId;
    }

    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean local) {
        if (logger.finerOn()) {
            logger.finer("disconnect", "disconnect");
        }
        if (this.connected) {
            this.notificationClientHandler.stopListening(local);
            this.heartbeatClientHandler.stopPinging(-1, local);
            this.heartbeatClientHandler.notifyConnectionTerminated();
            this.httpConnAddr = null;
            this.authSchemeInfoList = null;
            this.connected = false;
        }
    }

    public boolean isConnected() {
        if (logger.finerOn()) {
            logger.finer("isConnected", "isConnected");
        }
        return this.connected;
    }

    public ConnectorAddress getMBeanServerAddress() {
        if (logger.finerOn()) {
            logger.finer("getMBeanServerAddress", "getMBeanServerAddress");
        }
        if (!this.connected) {
            return null;
        }
        return this.httpConnAddr;
    }

    public String getMBeanServerId() {
        if (logger.finerOn()) {
            logger.finer("getMBeanServerId", "getMBeanServerId");
        }
        return this.mbeanServerId;
    }

    private String getMBeanServerId2() {
        Object[] opList = new Object[]{"getMBeanServerId"};
        return (String)this.invokeRemoteOperationNoExceptions(opList);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object[] opList = new Object[]{"createMBean", className, name};
        return this.createMBeanWithoutLoader(opList);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object[] opList = new Object[]{"createMBeanLoader", className, name, loaderName};
        return this.createMBeanWithLoader(opList);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object[] opList = new Object[]{"createMBeanParams", className, name, params, signature};
        return this.createMBeanWithoutLoader(opList);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object[] opList = new Object[]{"createMBeanLoaderParams", className, name, loaderName, params, signature};
        return this.createMBeanWithLoader(opList);
    }

    private ObjectInstance createMBeanWithoutLoader(Object[] opList) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        try {
            return (ObjectInstance)this.invokeRemoteOperation(opList);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    private ObjectInstance createMBeanWithLoader(Object[] opList) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        try {
            return (ObjectInstance)this.invokeRemoteOperation(opList);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"unregisterMBean", name};
        try {
            this.invokeRemoteOperation(opList);
            this.proxyHandles.remove(name);
            this.genericHandles.remove(name);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"queryNames", name, query};
        return (Set)this.invokeRemoteOperationNoExceptions(opList);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"queryMBeans", name, query};
        return (Set)this.invokeRemoteOperationNoExceptions(opList);
    }

    public boolean isRegistered(ObjectName name) {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"isRegistered", name};
        Boolean result = (Boolean)this.invokeRemoteOperationNoExceptions(opList);
        return result;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"getAttribute", name, attribute};
        try {
            return this.invokeRemoteOperation(opList);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"getAttributes", name, attributes};
        return (AttributeList)this.invokeRemoteOperationOnInstance(opList);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"setAttribute", name, attribute};
        try {
            this.invokeRemoteOperation(opList);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InvalidAttributeValueException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"setAttributes", name, attributes};
        return (AttributeList)this.invokeRemoteOperationOnInstance(opList);
    }

    public Object invoke(ObjectName name, String methodName, Object[] arguments, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"invoke", name, methodName, arguments, signature};
        try {
            return this.invokeRemoteOperation(opList);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"getMBeanInfo", name};
        try {
            return (MBeanInfo)this.invokeRemoteOperation(opList);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"getObjectInstance", name};
        return (ObjectInstance)this.invokeRemoteOperationOnInstance(opList);
    }

    public Integer getMBeanCount() {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"getMBeanCount"};
        return (Integer)this.invokeRemoteOperationNoExceptions(opList);
    }

    public String getDefaultDomain() {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"getDefaultDomain"};
        return (String)this.invokeRemoteOperationNoExceptions(opList);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"isInstanceOf", name, className};
        Boolean result = (Boolean)this.invokeRemoteOperationOnInstance(opList);
        return result;
    }

    public boolean supports(String feature) {
        Object[] opList = new Object[]{"supports", feature};
        try {
            Boolean result = (Boolean)this.invokeRemoteOperationNoExceptions(opList);
            return result;
        }
        catch (CommunicationException e) {
            return false;
        }
    }

    public String getClassForProxyMBean(ObjectInstance instance) throws ProxyMBeanInstantiationException {
        if (logger.finerOn()) {
            logger.finer("getClassForProxyMBean", "getClassForProxyMBean");
        }
        if (instance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        return this.mapper.getClassForProxyMBean(instance);
    }

    public void setMode(int mode) throws IllegalArgumentException {
        if (logger.finerOn()) {
            logger.finer("setMode", "setMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setMode(mode);
    }

    public int getMode() {
        if (logger.finerOn()) {
            logger.finer("getMode", "getMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getMode();
    }

    public void getNotifications() {
        if (logger.finerOn()) {
            logger.finer("getNotifications", "getNotifications");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.getNotifications();
    }

    public void setPeriod(int period) {
        if (logger.finerOn()) {
            logger.finer("setPeriod", "setPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setPeriod(period);
    }

    public int getPeriod() {
        if (logger.finerOn()) {
            logger.finer("getPeriod", "getPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getPeriod();
    }

    public void clearCache() {
        if (logger.finerOn()) {
            logger.finer("clearCache", "clearCache");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.clearCache();
    }

    public int setCacheSize(int size, boolean discardOverflow) throws JMRuntimeException {
        if (logger.finerOn()) {
            logger.finer("setCacheSize", "setCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.setCacheSize(size, discardOverflow);
    }

    public int getCacheSize() {
        if (logger.finerOn()) {
            logger.finer("getCacheSize", "getCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getCacheSize();
    }

    public void setOverflowCount(int count) {
        if (logger.finerOn()) {
            logger.finer("setOverflowCount", "setOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowCount(count);
    }

    public int getOverflowCount() {
        if (logger.finerOn()) {
            logger.finer("getOverflowCount", "getOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowCount();
    }

    public void setOverflowMode(int of) throws IllegalArgumentException {
        if (logger.finerOn()) {
            logger.finer("setOverflowMode", "setOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowMode(of);
    }

    public int getOverflowMode() {
        if (logger.finerOn()) {
            logger.finer("getOverflowMode", "getOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowMode();
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (logger.finerOn()) {
            logger.finer("addNotificationListener", "addNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (logger.finerOn()) {
            logger.finer("removeNotificationListener", "removeNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.removeNotificationListener(name, listener);
    }

    Object[] remoteRequest(int opType, Object[] params) throws Exception {
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        Object[] opList = new Object[]{"remoteRequest", new Integer(opType), params};
        try {
            return (Object[])this.invokeRemoteOperation(opList);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ListenerNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    ConnectorAddress startPush() {
        if (logger.finerOn()) {
            logger.finer("startPush", "startPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver == null) {
            try {
                if (logger.finestOn()) {
                    logger.finest("startPush", "Create new NotificationReceiver");
                }
                this.notificationReceiver = this.getNotificationReceiver(this, this.notificationClientHandler);
            }
            catch (CommunicationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CommunicationException(e);
            }
        }
        if (logger.finestOn()) {
            logger.finest("startPush", "Start receiving events");
        }
        this.notificationReceiver.startListening();
        return this.notificationReceiver.getConnectorAddress();
    }

    void stopPush() {
        if (logger.finerOn()) {
            logger.finer("stopPush", "stopPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver != null) {
            this.notificationReceiver.stopListening();
        }
    }

    public int getHeartBeatPeriod() {
        if (logger.finerOn()) {
            logger.finer("getHeartBeatPeriod", "getHeartBeatPeriod");
        }
        return this.heartbeatClientHandler.getHeartBeatPeriod();
    }

    public void setHeartBeatPeriod(int period) {
        if (logger.finerOn()) {
            logger.finer("setHeartBeatPeriod", "setHeartBeatPeriod");
        }
        this.heartbeatClientHandler.setHeartBeatPeriod(period);
    }

    public int getHeartBeatRetries() {
        if (logger.finerOn()) {
            logger.finer("getHeartBeatRetries", "getHeartBeatRetries");
        }
        return this.heartbeatClientHandler.getHeartBeatRetries();
    }

    public void setHeartBeatRetries(int nretries) {
        if (logger.finerOn()) {
            logger.finer("setHeartBeatRetries", "setHeartBeatRetries");
        }
        this.heartbeatClientHandler.setHeartBeatRetries(nretries);
    }

    public void addHeartBeatNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (logger.finerOn()) {
            logger.finer("addHeartBeatNotificationListener", "addHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.addHeartBeatNotificationListener(listener, filter, handback);
    }

    public void removeHeartBeatNotificationListener(NotificationListener listener) {
        if (logger.finerOn()) {
            logger.finer("removeHeartBeatNotificationListener", "removeHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.removeHeartBeatNotificationListener(listener);
    }

    String pingHeartBeatServer(String sessionId, int period, int nretries, Long notifSessionId) {
        Object[] opList = new Object[]{"pingHeartBeatServer", sessionId, new Integer(period), new Integer(nretries), notifSessionId};
        return (String)this.invokeRemoteOperationNoExceptions(opList);
    }

    String getHost() {
        return this.localHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteOperation(Object[] opList) throws Exception {
        if (logger.finerOn()) {
            String what = (String)opList[0];
            logger.finer("invokeRemoteOperation", what);
        }
        InputStream in = this.sendHttp(opList, false);
        try {
            Object object = this.readObjectValue(in);
            return object;
        }
        finally {
            in.close();
        }
    }

    private Object invokeRemoteOperationNoExceptions(Object[] opList) {
        try {
            return this.invokeRemoteOperationOnInstance(opList);
        }
        catch (InstanceNotFoundException e) {
            throw new CommunicationException(e);
        }
    }

    private Object invokeRemoteOperationOnInstance(Object[] opList) throws InstanceNotFoundException {
        try {
            return this.invokeRemoteOperation(opList);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    private Object readObjectValue(InputStream in) throws Exception {
        ObjectInputStream objIn = new ObjectInputStream(in);
        String typeStr = (String)objIn.readObject();
        if (logger.finestOn()) {
            logger.finest("readObjectValue", "Received object of type " + typeStr);
        }
        Object result = objIn.readObject();
        if (logger.finestOn()) {
            logger.finest("readObjectValue", "Received object [" + result + "]");
        }
        if (result instanceof Exception && typeStr.equals("Exception")) {
            if (logger.finestOn()) {
                logger.finest("readObjectValue", "Throw exception :" + result);
            }
            throw (Exception)result;
        }
        if (logger.finestOn()) {
            logger.finest("readObjectValue", "Return value : " + result);
        }
        return result;
    }

    private class HeartBeatInternalClientHandlerImpl
    implements HeartBeatInternalClientHandler {
        private GenericHttpConnectorClient connector;

        public HeartBeatInternalClientHandlerImpl(GenericHttpConnectorClient connector) {
            this.connector = connector;
        }

        public RemoteMBeanServer getRemoteMBeanServer() {
            return this.connector;
        }

        public String pingHeartBeatServer(String sessionId, int period, int nretries, Long notifSessionId) {
            return this.connector.pingHeartBeatServer(sessionId, period, nretries, notifSessionId);
        }
    }

    private class NotificationHandlerInternal
    implements ClientNotificationHandlerInternal {
        private GenericHttpConnectorClient connector;

        public NotificationHandlerInternal(GenericHttpConnectorClient connector) {
            this.connector = connector;
        }

        public Object[] remoteRequest(int opType, Object[] params) throws Exception {
            return this.connector.remoteRequest(opType, params);
        }

        public ConnectorAddress startPush() {
            return this.connector.startPush();
        }

        public void stopPush(ConnectorAddress address) {
            this.connector.stopPush();
        }
    }
}

