/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.AuthRealmConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletRequest;

public class FileUserHandler {
    public static void getUser(HandlerContext handlerCtx) {
        ExternalContext extContext = handlerCtx.getFacesContext().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        String user = request.getRemoteUser();
        handlerCtx.setOutputValue("UserId", (Object)user);
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        Map realms = sConfig.getAuthRealmConfigMap();
        StringBuffer groupList = new StringBuffer();
        AuthRealmConfig aRealm = (AuthRealmConfig)realms.get((String)handlerCtx.getInputValue("Realm"));
        String[] gl = aRealm.getUserGroupNames(user);
        for (int i = 0; i < gl.length; ++i) {
            groupList.append("," + gl[i]);
        }
        if (groupList.length() > 0) {
            groupList.deleteCharAt(0);
        }
        handlerCtx.setOutputValue("GroupList", (Object)groupList.toString());
    }

    public static void saveUser(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
            Map realms = sConfig.getAuthRealmConfigMap();
            AuthRealmConfig aRealm = (AuthRealmConfig)realms.get((String)handlerCtx.getInputValue("Realm"));
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String[] groups = GuiUtil.stringToArray(grouplist, ",");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            aRealm.updateUser(userid, password, groups);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void addUser(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
            Map realms = sConfig.getAuthRealmConfigMap();
            AuthRealmConfig aRealm = (AuthRealmConfig)realms.get((String)handlerCtx.getInputValue("Realm"));
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String[] groups = GuiUtil.stringToArray(grouplist, ",");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            aRealm.addUser(userid, password, groups);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getUserInfo(HandlerContext handlerCtx) {
        String user = (String)handlerCtx.getInputValue("User");
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        Map realms = sConfig.getAuthRealmConfigMap();
        StringBuffer groupList = new StringBuffer();
        AuthRealmConfig aRealm = (AuthRealmConfig)realms.get((String)handlerCtx.getInputValue("Realm"));
        String[] gl = aRealm.getUserGroupNames(user);
        for (int i = 0; i < gl.length; ++i) {
            groupList.append("," + gl[i]);
        }
        if (groupList.length() > 0) {
            groupList.deleteCharAt(0);
        }
        handlerCtx.setOutputValue("GroupList", (Object)groupList.toString());
    }

    public static void getFileUsers(HandlerContext handlerCtx) {
        String realm = (String)handlerCtx.getInputValue("Realm");
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ArrayList result = new ArrayList();
        try {
            Map realms = config.getSecurityServiceConfig().getAuthRealmConfigMap();
            AuthRealmConfig aRealm = (AuthRealmConfig)realms.get(realm);
            String[] users = aRealm.getUserNames();
            if (users != null) {
                HashMap<String, Object> map = null;
                for (String val : users) {
                    map = new HashMap<String, Object>();
                    map.put("users", val);
                    map.put("groups", FileUserHandler.getGroupNames(val, (String)handlerCtx.getInputValue("ConfigName"), realm));
                    map.put("selected", false);
                    result.add(map);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void removeUser(HandlerContext handlerCtx) {
        String realm = (String)handlerCtx.getInputValue("Realm");
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            List obj;
            Map realms = config.getSecurityServiceConfig().getAuthRealmConfigMap();
            AuthRealmConfig aRealm = (AuthRealmConfig)realms.get(realm);
            List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
            for (Map oneRow : selectedRows) {
                String user = (String)oneRow.get("users");
                aRealm.removeUser(user);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void hasManageUserButton(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("realmName");
        String configName = (String)handlerCtx.getInputValue("configName");
        ConfigConfig config = (ConfigConfig)AMXUtil.getDomainConfig().getConfigConfigMap().get(configName);
        AuthRealmConfig authRealm = (AuthRealmConfig)config.getSecurityServiceConfig().getAuthRealmConfigMap().get(realmName);
        String className = authRealm.getClassname();
        Class<?> realm = null;
        try {
            realm = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("!!!!! ClassNotFound Exception for " + className);
            ex.printStackTrace();
            handlerCtx.setOutputValue("result", (Object)false);
            return;
        }
        catch (Exception ex1) {
            System.out.println("!!!!! Exception for " + className);
            ex1.printStackTrace();
            handlerCtx.setOutputValue("result", (Object)false);
            return;
        }
        catch (NoClassDefFoundError err1) {
            System.out.println("!!!!! NoClassDefFoundError for " + className);
            err1.printStackTrace();
            handlerCtx.setOutputValue("result", (Object)false);
            return;
        }
        Class<?> baseClass = null;
        try {
            baseClass = Class.forName("com.sun.enterprise.security.auth.realm.file.FileRealm");
        }
        catch (ClassNotFoundException ex) {
            System.out.println("The class: \"com.sun.enterprise.security.auth.realm.IASRealm\" was not found.");
            handlerCtx.setOutputValue("result", (Object)false);
            return;
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
            handlerCtx.setOutputValue("result", (Object)false);
            return;
        }
        if (realm == null || baseClass == null) {
            handlerCtx.setOutputValue("result", (Object)false);
            return;
        }
        if (baseClass.isAssignableFrom(realm)) {
            Map props = authRealm.getProperties();
            String ja = (String)props.get("jaas-context");
            String file = (String)props.get("file");
            if (!GuiUtil.isEmpty(ja) && !GuiUtil.isEmpty(file)) {
                handlerCtx.setOutputValue("result", (Object)true);
            } else {
                handlerCtx.setOutputValue("result", (Object)false);
            }
        } else {
            System.out.println("The FileRealm classname, \"" + className + "\" does not extend \"com.sun.enterprise.security.auth.realm.file.FileRealm\".");
            handlerCtx.setOutputValue("result", (Object)false);
        }
    }

    private static String getGroupNames(String userName, String configName, String realm) {
        String[] groupList = null;
        StringBuffer groupNames = null;
        ConfigConfig config = AMXUtil.getConfig(configName);
        Map realms = config.getSecurityServiceConfig().getAuthRealmConfigMap();
        groupNames = new StringBuffer();
        AuthRealmConfig aRealm = (AuthRealmConfig)realms.get(realm);
        groupList = aRealm.getUserGroupNames(userName);
        for (int i = 0; i < groupList.length; ++i) {
            groupNames.append("," + groupList[i]);
        }
        if (groupNames.length() > 0) {
            groupNames.deleteCharAt(0);
        }
        return groupNames.toString();
    }
}

