/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.MailResourceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaMailHandlers {
    public static void getJavaMailInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
        if (!edit.booleanValue()) {
            JavaMailHandlers.getJavaMailDefaults(handlerCtx);
            handlerCtx.setOutputValue("Properties", new HashMap());
            return;
        }
        MailResourceConfig mailResource = (MailResourceConfig)AMXUtil.getDomainConfig().getMailResourceConfigMap().get(jndiName);
        if (mailResource == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchMailResource"));
            return;
        }
        if (AMXUtil.isEE()) {
            handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)mailResource, false));
        } else {
            handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isResourceEnabled((Enabled)mailResource, "server"));
        }
        handlerCtx.setOutputValue("host", (Object)mailResource.getHost());
        handlerCtx.setOutputValue("user", (Object)mailResource.getUser());
        handlerCtx.setOutputValue("from", (Object)mailResource.getFrom());
        handlerCtx.setOutputValue("description", (Object)mailResource.getDescription());
        handlerCtx.setOutputValue("storeProtocol", (Object)mailResource.getStoreProtocol());
        handlerCtx.setOutputValue("storeProtocolClass", (Object)mailResource.getStoreProtocolClass());
        handlerCtx.setOutputValue("transportProtocol", (Object)mailResource.getTransportProtocol());
        handlerCtx.setOutputValue("transportProtocolClass", (Object)mailResource.getTransportProtocolClass());
        handlerCtx.setOutputValue("debug", (Object)mailResource.getDebug());
        Map props = mailResource.getProperties();
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveJavaMail(HandlerContext handlerCtx) {
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
            if (!edit.booleanValue()) {
                JavaMailHandlers.createJavaMail(handlerCtx);
                return;
            }
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            MailResourceConfig mailResource = (MailResourceConfig)AMXUtil.getDomainConfig().getMailResourceConfigMap().get(jndiName);
            if (mailResource == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchMailResource"));
                return;
            }
            mailResource.setHost((String)handlerCtx.getInputValue("host"));
            mailResource.setUser((String)handlerCtx.getInputValue("user"));
            mailResource.setFrom((String)handlerCtx.getInputValue("from"));
            mailResource.setDescription((String)handlerCtx.getInputValue("description"));
            if (!AMXUtil.isEE()) {
                Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                TargetUtil.setResourceEnabled((Enabled)mailResource, "server", enabled);
            }
            mailResource.setStoreProtocol((String)handlerCtx.getInputValue("storeProtocol"));
            mailResource.setStoreProtocolClass((String)handlerCtx.getInputValue("storeProtocolClass"));
            mailResource.setTransportProtocol((String)handlerCtx.getInputValue("transportProtocol"));
            mailResource.setTransportProtocolClass((String)handlerCtx.getInputValue("transportProtocolClass"));
            mailResource.setDebug(((Boolean)handlerCtx.getInputValue("debug")).booleanValue());
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)mailResource);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJavaMailDefaultInfo(HandlerContext handlerCtx) {
        JavaMailHandlers.getJavaMailDefaults(handlerCtx);
    }

    private static void getJavaMailDefaults(HandlerContext handlerCtx) {
        Map attrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-MailResourceConfig");
        handlerCtx.setOutputValue("enabled", (Object)Boolean.valueOf((String)attrMap.get("enabled")));
        handlerCtx.setOutputValue("debug", (Object)Boolean.valueOf((String)attrMap.get("debug")));
        handlerCtx.setOutputValue("storeProtocol", attrMap.get("store-protocol"));
        handlerCtx.setOutputValue("storeProtocolClass", attrMap.get("store-protocol-class"));
        handlerCtx.setOutputValue("transportProtocol", attrMap.get("transport-protocol"));
        handlerCtx.setOutputValue("transportProtocolClass", attrMap.get("transport-protocol-class"));
    }

    private static void createJavaMail(HandlerContext handlerCtx) {
        try {
            Map addProps;
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            String host = (String)handlerCtx.getInputValue("host");
            String user = (String)handlerCtx.getInputValue("user");
            String from = (String)handlerCtx.getInputValue("from");
            Map<String, String> options = new HashMap<String, String>();
            JavaMailHandlers.addOption(options, handlerCtx, "StoreProtocol", "storeProtocol");
            JavaMailHandlers.addOption(options, handlerCtx, "StoreProtocolClass", "storeProtocolClass");
            JavaMailHandlers.addOption(options, handlerCtx, "TransportProtocol", "transportProtocol");
            JavaMailHandlers.addOption(options, handlerCtx, "TransportProtocolClass", "transportProtocolClass");
            Boolean debug = (Boolean)handlerCtx.getInputValue("debug");
            if (debug != null) {
                options.put("Debug", debug.toString());
            }
            if ((addProps = (Map)handlerCtx.getInputValue("AddProps")) != null) {
                options = AMXUtil.convertToPropertiesOptionMap(addProps, options);
            }
            if (options.isEmpty()) {
                options = null;
            }
            MailResourceConfig resource = AMXUtil.getDomainConfig().createMailResourceConfig(jndiName, host, user, from, options);
            resource.setDescription((String)handlerCtx.getInputValue("description"));
            JavaMailHandlers.createNewTargets(handlerCtx, jndiName);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void addOption(Map options, HandlerContext handlerCtx, String key, String param) {
        String value = (String)handlerCtx.getInputValue(param);
        if (!GuiUtil.isEmpty(value)) {
            options.put(key, value);
        }
    }

    public static void createNewTargets(HandlerContext handlerCtx, String name) {
        Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        String[] selTargets = new String[]{"server"};
        if (AMXUtil.isEE()) {
            selTargets = (String[])handlerCtx.getInputValue("targets");
        }
        List<String> targets = Arrays.asList(selTargets);
        for (String targetName : targets) {
            TargetUtil.createResourceRef(name, targetName, enabled);
        }
    }
}

