/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.ext.logging.Logging;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogHandlers {
    public static void getErrorInfoList(HandlerContext handlerCtx) {
        Map attrs;
        Integer severe;
        int i;
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        Map[] infoMap = null;
        Logging logging = LogHandlers.getLoggingBean(instanceName);
        if (logging != null) {
            infoMap = logging.getErrorInfo();
        }
        ArrayList result = new ArrayList();
        if (infoMap == null || infoMap.length <= 0) {
            handlerCtx.setOutputValue("result", result);
            handlerCtx.setOutputValue("hasResult", (Object)false);
            handlerCtx.setOutputValue("hasChart", (Object)false);
            return;
        }
        ArrayList<Map> smaller = new ArrayList<Map>();
        for (i = 0; i < 5 && i < infoMap.length; ++i) {
            smaller.add(infoMap[i]);
        }
        for (i = 5; i < infoMap.length && (severe = (Integer)(attrs = infoMap[i]).get("SevereCount")) >= 0; ++i) {
            smaller.add(infoMap[i]);
        }
        ArrayList<Integer> severeList = new ArrayList<Integer>();
        ArrayList<Integer> warningList = new ArrayList<Integer>();
        ArrayList labelList = new ArrayList();
        int size = smaller.size() - 1;
        int mod = 0;
        if (size > 50) {
            mod = 10;
        } else if (size > 20) {
            mod = 5;
        }
        int countLabel = 0;
        while (size >= 0) {
            HashMap<String, String> sMap;
            Map attrs2 = (Map)smaller.get(size);
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            Long ms = (Long)attrs2.get("TimeStamp");
            oneRow.put("timeStamp", ms);
            oneRow.put("timeStampFormatted", LogHandlers.getFormattedTime(ms.toString()));
            Integer severe2 = (Integer)attrs2.get("SevereCount");
            oneRow.put("severeString", severe2 < 0 ? GuiUtil.getMessage("common.NA") : severe2.toString());
            oneRow.put("severeCount", severe2 < 0 ? Integer.parseInt("-1") : severe2);
            Integer warning = (Integer)attrs2.get("WarningCount");
            oneRow.put("warningString", warning < 0 ? GuiUtil.getMessage("common.NA") : warning.toString());
            oneRow.put("warningCount", warning < 0 ? Integer.parseInt("-1") : warning);
            oneRow.put("selected", false);
            if (severe2 <= 0 && warning <= 0) {
                oneRow.put("disabled", true);
            } else {
                oneRow.put("disabled", false);
            }
            result.add(oneRow);
            if (severe2 < 0) {
                severe2 = new Integer(0);
            }
            if (warning < 0) {
                warning = new Integer(0);
            }
            severeList.add(severe2);
            warningList.add(warning);
            DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 3, GuiUtil.getLocale());
            DateFormat timeFormat = DateFormat.getTimeInstance(3, GuiUtil.getLocale());
            boolean putLabel = true;
            if (mod != 0) {
                putLabel = countLabel++ % mod == 0;
            }
            Date mm = new Date(ms);
            if (putLabel) {
                sMap = new HashMap<String, String>();
                sMap.put("title", dateTimeFormat.format(mm) + "(" + severe2 + ", " + warning + ")");
                sMap.put("label", timeFormat.format(mm));
                labelList.add(sMap);
            } else {
                sMap = new HashMap();
                sMap.put("label", " ");
                sMap.put("title", " ");
                labelList.add(sMap);
            }
            --size;
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("hasResult", (Object)true);
        Boolean doCharting = (Boolean)handlerCtx.getInputValue("doCharting");
        String demo = (String)handlerCtx.getInputValue("demo");
        if (!GuiUtil.isEmpty(demo)) {
            labelList = new ArrayList();
            int ct = Integer.parseInt(demo);
            int countLabel2 = 0;
            int mod2 = 0;
            if (ct > 50) {
                mod2 = 10;
            } else if (ct > 20) {
                mod2 = 5;
            }
            Random random = new Random();
            severeList = new ArrayList();
            warningList = new ArrayList();
            Date current = new Date(System.currentTimeMillis());
            DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 3, GuiUtil.getLocale());
            DateFormat timeFormat = DateFormat.getTimeInstance(3, GuiUtil.getLocale());
            for (int i2 = 0; i2 < ct; ++i2) {
                HashMap<String, String> sMap;
                Integer severe3 = new Integer(Math.abs(random.nextInt() % 30));
                severeList.add(severe3);
                Integer warning = new Integer(Math.abs(random.nextInt() % 30));
                warningList.add(warning);
                boolean putLabel = true;
                if (mod2 != 0) {
                    boolean bl = putLabel = countLabel2++ % mod2 == 0;
                }
                if (putLabel) {
                    sMap = new HashMap<String, String>();
                    sMap.put("title", dateTimeFormat.format(current) + "(" + severe3 + ", " + warning + ")");
                    sMap.put("label", timeFormat.format(current));
                    labelList.add(sMap);
                    continue;
                }
                sMap = new HashMap();
                sMap.put("label", " ");
                sMap.put("title", " ");
                labelList.add(sMap);
            }
        }
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        sMap.put("color", "red");
        sMap.put("label", GuiUtil.getMessage("logAnalyzer.chart.legend.severe"));
        sMap.put("values", severeList);
        HashMap<String, Object> wMap = new HashMap<String, Object>();
        wMap.put("color", "pink");
        wMap.put("label", GuiUtil.getMessage("logAnalyzer.chart.legend.warning"));
        wMap.put("values", warningList);
        ArrayList<HashMap<String, Object>> valueList = new ArrayList<HashMap<String, Object>>();
        valueList.add(sMap);
        valueList.add(wMap);
        Long start = (Long)((Map)result.get(0)).get("timeStamp");
        Long end = (Long)((Map)result.get(result.size() - 1)).get("timeStamp");
        String startStr = LogHandlers.getFormattedTime(start.toString());
        String endStr = LogHandlers.getFormattedTime(end.toString());
        String titleStr = GuiUtil.getMessage("logAnalyzer.chart.title", new Object[]{startStr, endStr});
        handlerCtx.setOutputValue("chartValues", valueList);
        handlerCtx.setOutputValue("chartLabels", labelList);
        handlerCtx.setOutputValue("chartTitle", (Object)titleStr);
        handlerCtx.setOutputValue("hasChart", (Object)doCharting);
    }

    public static void getErrorLoggersList(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        String ts = (String)handlerCtx.getInputValue("timeStamp");
        Long timeStamp = Long.parseLong(ts);
        Logging logging = LogHandlers.getLoggingBean(instanceName);
        ArrayList result = new ArrayList();
        if (logging == null) {
            handlerCtx.setOutputValue("result", result);
            handlerCtx.setOutputValue("hasResults", (Object)false);
            handlerCtx.setOutputValue("hasSevereChart", (Object)false);
            handlerCtx.setOutputValue("hasWarningChart", (Object)false);
            return;
        }
        HashMap<String, Integer> warningMap = logging.getErrorDistribution(timeStamp.longValue(), "" + Level.WARNING);
        HashMap<String, Integer> severeMap = logging.getErrorDistribution(timeStamp.longValue(), "" + Level.SEVERE);
        HashMap<String, Integer[]> combinedMap = new HashMap<String, Integer[]>();
        String demo = (String)handlerCtx.getInputValue("demo");
        if (GuiUtil.isEmpty(demo)) {
            Integer[] counts;
            for (String module : severeMap.keySet()) {
                counts = new Integer[]{(Integer)severeMap.get(module), Integer.parseInt("0")};
                combinedMap.put(module, counts);
            }
            for (String module : warningMap.keySet()) {
                counts = (Integer[])combinedMap.get(module);
                if (counts == null) {
                    Integer[] newCounts = new Integer[]{Integer.parseInt("0"), (Integer)warningMap.get(module)};
                    combinedMap.put(module, newCounts);
                    continue;
                }
                counts[1] = (Integer)warningMap.get(module);
            }
            for (String module : combinedMap.keySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("loggerName", module);
                Integer[] counts2 = (Integer[])combinedMap.get(module);
                oneRow.put("severe", counts2[0]);
                oneRow.put("warning", counts2[1]);
                result.add(oneRow);
            }
        } else {
            String module;
            int ct = Integer.parseInt(demo);
            module = "com.abc.demo.aa";
            Random random = new Random();
            result = new ArrayList();
            severeMap = new HashMap<String, Integer>();
            warningMap = new HashMap<String, Integer>();
            for (int i = 0; i < ct; ++i) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("loggerName", module + i);
                Integer sev = new Integer(Math.abs(random.nextInt() % 20));
                Integer war = new Integer(Math.abs(random.nextInt() % 20));
                severeMap.put(module + i, sev);
                oneRow.put("severe", sev);
                oneRow.put("warning", war);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("hasResults", (Object)(result.size() > 0 ? 1 : 0));
        Boolean doCharting = (Boolean)handlerCtx.getInputValue("doCharting");
        if (doCharting != null && !doCharting.booleanValue()) {
            handlerCtx.setOutputValue("hasSevereChart", (Object)false);
            handlerCtx.setOutputValue("hasWarningChart", (Object)false);
        }
        List[] sList = LogHandlers.createChartData(severeMap, "red");
        List[] wList = LogHandlers.createChartData(warningMap, "pink");
        if (sList == null) {
            handlerCtx.setOutputValue("hasSevereChart", (Object)false);
        } else {
            handlerCtx.setOutputValue("severeChartLabels", (Object)sList[0]);
            handlerCtx.setOutputValue("severeChartValues", (Object)sList[1]);
            handlerCtx.setOutputValue("hasSevereChart", (Object)doCharting);
        }
        if (wList == null) {
            handlerCtx.setOutputValue("hasWarningChart", (Object)false);
        } else {
            handlerCtx.setOutputValue("warningChartLabels", (Object)wList[0]);
            handlerCtx.setOutputValue("warningChartValues", (Object)wList[1]);
            handlerCtx.setOutputValue("hasWarningChart", (Object)doCharting);
        }
    }

    public static void getFormattedTime(HandlerContext handlerCtx) {
        String ms = (String)handlerCtx.getInputValue("ms");
        handlerCtx.setOutputValue("value", (Object)LogHandlers.getFormattedTime(ms));
    }

    private static List[] createChartData(Map<String, Integer> mapDist, String color) {
        ArrayList labelList = new ArrayList();
        for (String module : mapDist.keySet()) {
            if (mapDist.get(module) <= 0) continue;
            HashMap<String, Object> aMap = new HashMap<String, Object>();
            int lastIndex = module.lastIndexOf(".");
            if (lastIndex == -1) {
                aMap.put("label", module);
            } else {
                aMap.put("label", module.substring(lastIndex + 1, module.length()));
                aMap.put("title", module + " (" + mapDist.get(module) + ")");
            }
            aMap.put("compValue", mapDist.get(module));
            labelList.add(aMap);
        }
        if (labelList.size() == 0) {
            return null;
        }
        Collections.sort(labelList, new moduleCountComparator());
        if (labelList.size() > 10) {
            int cnt = 0;
            for (int i = 10; i < labelList.size(); ++i) {
                Integer tmp = (Integer)((Map)labelList.get(i)).get("compValue");
                cnt += tmp.intValue();
            }
            labelList.subList(10, labelList.size()).clear();
            HashMap<String, Object> aMap = new HashMap<String, Object>();
            aMap.put("label", GuiUtil.getMessage("logAnalyzerLoggers.chart.other"));
            aMap.put("compValue", new Integer(cnt));
            labelList.add(aMap);
        }
        ArrayList valueList = new ArrayList();
        for (int i = 0; i < labelList.size(); ++i) {
            valueList.add(((Map)labelList.get(i)).get("compValue"));
        }
        HashMap<String, Object> vMap = new HashMap<String, Object>();
        vMap.put("color", color);
        vMap.put("values", valueList);
        ArrayList<HashMap<String, Object>> vList = new ArrayList<HashMap<String, Object>>();
        vList.add(vMap);
        List[] result = new List[]{labelList, vList};
        return result;
    }

    private static String getFormattedTime(String ms) {
        Date useThis = null;
        useThis = ms == null || "".equals(ms) ? new Date(System.currentTimeMillis()) : new Date(Long.parseLong(ms));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, GuiUtil.getLocale());
        return dateFormat.format(useThis);
    }

    private static Logging getLoggingBean(String instanceName) {
        ServerRootMonitor serverRootMonitor = AMXUtil.getServerRootMonitor(instanceName);
        if (serverRootMonitor == null) {
            return null;
        }
        return serverRootMonitor.getLogging();
    }

    private static final class moduleCountComparator
    implements Comparator {
        private moduleCountComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer f1 = (Integer)((Map)o1).get("compValue");
            Integer f2 = (Integer)((Map)o2).get("compValue");
            return f2.compareTo(f1);
        }

        public boolean equals(Object other) {
            return other instanceof moduleCountComparator;
        }
    }
}

