/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;

public class MonitorHandlers {
    private boolean firstObjectSet = false;

    private boolean addOption(String objectName, ArrayList optionList, OptionGroup optionGroup, HandlerContext ctx) {
        boolean itemsAdded = false;
        try {
            Object[] stats = (Object[])JMXUtil.invoke(objectName, "getStatistics", null, null);
            if (stats == null || stats.length == 0) {
                return itemsAdded;
            }
        }
        catch (Exception ex) {
            return itemsAdded;
        }
        if (!this.firstObjectSet) {
            this.firstObjectSet = true;
            ctx.setOutputValue("ObjectName", (Object)objectName);
        }
        String name = (String)JMXUtil.invoke(objectName, "getName", null, null);
        if (optionGroup != null) {
            Option option = new Option();
            option.setLabel(name);
            option.setValue((Object)objectName);
            Option[] o = optionGroup.getOptions();
            if (o == null) {
                optionGroup.setOptions(new Option[]{option});
            } else {
                ArrayList<Option> list = new ArrayList<Option>();
                for (int i = 0; i < o.length; ++i) {
                    list.add(o[i]);
                }
                list.add(option);
                Option[] oNew = list.toArray(new Option[list.size()]);
                optionGroup.setOptions(oNew);
            }
            itemsAdded = true;
        } else {
            optionList.add(new Option((Object)objectName, name));
        }
        return itemsAdded;
    }

    private boolean fillMenuOptions(String objectName, ArrayList optionList, OptionGroup optionGroup, Stack ogStack, boolean doGrouping, HandlerContext ctx) {
        boolean itemsAdded = false;
        ObjectName[] childObjects = null;
        try {
            childObjects = (ObjectName[])JMXUtil.invoke(objectName, "getChildren", null, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (childObjects != null && childObjects.length > 0) {
            OptionGroup og = optionGroup;
            if (doGrouping) {
                String name = (String)JMXUtil.invoke(objectName, "getName", null, null);
                og = new OptionGroup();
                og.setLabel(name);
                og.setValue((Object)name);
            }
            itemsAdded = this.addOption(objectName, optionList, og, ctx);
            for (int i = 0; i < childObjects.length; ++i) {
                if (childObjects[i] == null) continue;
                itemsAdded |= this.fillMenuOptions(childObjects[i].toString(), optionList, og, ogStack, doGrouping, ctx);
            }
            if (itemsAdded && doGrouping) {
                ogStack.push(og);
                return false;
            }
        } else {
            itemsAdded = this.addOption(objectName, optionList, optionGroup, ctx);
        }
        return itemsAdded;
    }

    public void populateMonitorDropDown(HandlerContext handlerCtx) {
        ArrayList objs = (ArrayList)handlerCtx.getInputValue("MonitorObjects");
        Boolean doGrouping = (Boolean)handlerCtx.getInputValue("DoGrouping");
        ArrayList<Object> optionList = new ArrayList<Object>();
        optionList.add(new Option((Object)"", ""));
        Stack optGroupStack = new Stack();
        this.firstObjectSet = false;
        boolean itemsAdded = false;
        Option[] optionArr = new Option[]{};
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                String objectName = (String)objs.get(i);
                if (objectName == null) continue;
                itemsAdded = this.fillMenuOptions(objectName, optionList, null, optGroupStack, doGrouping, handlerCtx);
                while (!optGroupStack.empty()) {
                    optionList.add((OptionGroup)optGroupStack.pop());
                }
            }
            optionArr = optionList.toArray(new Option[optionList.size()]);
        }
        handlerCtx.setOutputValue("MonitorList", (Object)optionArr);
    }

    public void populateMonitorAppsDropDown(HandlerContext handlerCtx) {
        String appsObject = (String)handlerCtx.getInputValue("AppsObjectName");
        ObjectName[] objs = null;
        try {
            objs = (ObjectName[])JMXUtil.invoke(appsObject, "getChildren", null, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        ArrayList<Option> optionList = new ArrayList<Option>();
        optionList.add(new Option((Object)"", ""));
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                String name = null;
                try {
                    name = (String)JMXUtil.invoke(objs[i], "getName", null, null);
                }
                catch (Exception ex) {
                    continue;
                }
                optionList.add(new Option((Object)objs[i].toString(), name));
            }
        }
        handlerCtx.setOutputValue("ApplicationList", optionList);
    }

    public void getStatisticData(HandlerContext handlerCtx) {
        String obj = (String)handlerCtx.getInputValue("MonitorObject");
        ArrayList dataList = new ArrayList();
        if (!GuiUtil.isEmpty(obj)) {
            Statistic[] stats = (Statistic[])JMXUtil.invoke(obj, "getStatistics", null, null);
            Locale locale = handlerCtx.getFacesContext().getViewRoot().getLocale();
            DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
            NumberFormat nf = NumberFormat.getNumberInstance(locale);
            if (stats != null) {
                for (int i = 0; i < stats.length; ++i) {
                    BoundedRangeStatistic stat;
                    HashMap<String, String> statMap = new HashMap<String, String>();
                    if (stats[i] instanceof BoundedRangeStatistic) {
                        stat = (BoundedRangeStatistic)stats[i];
                        statMap.put("Name", stat.getName());
                        statMap.put("Value", nf.format(stat.getCurrent()) + " " + stat.getUnit());
                        statMap.put("Description", stat.getDescription());
                        statMap.put("StartTime", df.format(new Date(stat.getStartTime())));
                        statMap.put("LastSampleTime", df.format(new Date(stat.getLastSampleTime())));
                        statMap.put("Details", GuiUtil.getMessage("monitoring.HighWater") + ": " + nf.format(stat.getHighWaterMark()) + " " + stat.getUnit() + "<br/>" + GuiUtil.getMessage("monitoring.LowWater") + ": " + nf.format(stat.getLowWaterMark()) + " " + stat.getUnit() + "<br/>" + GuiUtil.getMessage("monitoring.UpperBound") + ": " + nf.format(stat.getUpperBound()) + " " + stat.getUnit() + "<br/>" + GuiUtil.getMessage("monitoring.LowerBound") + ": " + nf.format(stat.getLowerBound()) + " " + stat.getUnit() + "<br/>");
                    } else if (stats[i] instanceof BoundaryStatistic) {
                        stat = (BoundaryStatistic)stats[i];
                        statMap.put("Name", stat.getName());
                        statMap.put("Value", "");
                        statMap.put("Description", stat.getDescription());
                        statMap.put("StartTime", df.format(new Date(stat.getStartTime())));
                        statMap.put("LastSampleTime", df.format(new Date(stat.getLastSampleTime())));
                        statMap.put("Details", GuiUtil.getMessage("monitoring.UpperBound") + ": " + stat.getUpperBound() + " " + stat.getUnit() + "<br/>" + GuiUtil.getMessage("monitoring.LowerBound") + ": " + stat.getLowerBound() + " " + stat.getUnit() + "<br/>");
                    } else if (stats[i] instanceof RangeStatistic) {
                        stat = (RangeStatistic)stats[i];
                        statMap.put("Name", stat.getName());
                        statMap.put("Value", stat.getCurrent() + " " + stat.getUnit());
                        statMap.put("Description", stat.getDescription());
                        statMap.put("StartTime", df.format(new Date(stat.getStartTime())));
                        statMap.put("LastSampleTime", df.format(new Date(stat.getLastSampleTime())));
                        statMap.put("Details", GuiUtil.getMessage("monitoring.HighWater") + ": " + stat.getHighWaterMark() + " " + stat.getUnit() + "<br/>" + GuiUtil.getMessage("monitoring.LowWater") + ": " + stat.getLowWaterMark() + " " + stat.getUnit() + "<br/>");
                    } else if (stats[i] instanceof CountStatistic) {
                        stat = (CountStatistic)stats[i];
                        statMap.put("Name", stat.getName());
                        statMap.put("Value", stat.getCount() + " " + stat.getUnit());
                        statMap.put("Description", stat.getDescription());
                        statMap.put("StartTime", df.format(new Date(stat.getStartTime())));
                        statMap.put("LastSampleTime", df.format(new Date(stat.getLastSampleTime())));
                        statMap.put("Details", "");
                    } else if (stats[i] instanceof TimeStatistic) {
                        stat = (TimeStatistic)stats[i];
                        statMap.put("Name", stat.getName());
                        statMap.put("Value", stat.getCount() + " " + stat.getUnit());
                        statMap.put("Description", stat.getDescription());
                        statMap.put("StartTime", df.format(new Date(stat.getStartTime())));
                        statMap.put("LastSampleTime", df.format(new Date(stat.getLastSampleTime())));
                        statMap.put("Details", GuiUtil.getMessage("monitoring.MaxTime") + ": " + stat.getMaxTime() + " " + stat.getUnit() + "<br/>" + GuiUtil.getMessage("monitoring.MinTime") + ": " + stat.getMinTime() + " " + stat.getUnit() + "<br/>" + GuiUtil.getMessage("monitoring.TotalTime") + ": " + stat.getTotalTime() + " " + stat.getUnit() + "<br/>");
                    } else if (stats[i] instanceof StringStatistic) {
                        stat = (StringStatistic)stats[i];
                        statMap.put("Name", stat.getName());
                        statMap.put("Value", stat.getCurrent());
                        statMap.put("Description", stat.getDescription());
                        statMap.put("StartTime", df.format(new Date(stat.getStartTime())));
                        statMap.put("LastSampleTime", df.format(new Date(stat.getLastSampleTime())));
                        statMap.put("Details", "");
                    } else if (stats[i] instanceof Statistic) {
                        statMap.put("Name", stats[i].getName());
                        statMap.put("Value", stats[i].getUnit());
                        statMap.put("Description", stats[i].getDescription());
                        statMap.put("StartTime", df.format(new Date(stats[i].getStartTime())));
                        statMap.put("LastSampleTime", df.format(new Date(stats[i].getLastSampleTime())));
                        statMap.put("Details", "");
                    }
                    dataList.add(statMap);
                }
            }
        }
        handlerCtx.setOutputValue("StatisticData", dataList);
    }

    public void getTransactionData(HandlerContext handlerCtx) {
        String obj = (String)handlerCtx.getInputValue("ObjectName");
        ArrayList<Map> dataList = new ArrayList<Map>();
        if (obj != null) {
            try {
                List transList = (List)JMXUtil.invoke(obj, "listActiveTransactions", null, null);
                for (Map transMap : transList) {
                    transMap.put("Id", (String)transMap.get("TransactionId"));
                    transMap.put("State", (String)transMap.get("TransactionState"));
                    transMap.put("Time", (String)transMap.get("ElapsedTime"));
                    transMap.put("Component", (String)transMap.get("ComponentName"));
                    transMap.put("Resources", (String)transMap.get("ResourceNames"));
                    dataList.add(transMap);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        handlerCtx.setOutputValue("TransactionData", dataList);
    }

    public void setTransactionPageTitle(HandlerContext handlerCtx) {
        String state = (String)handlerCtx.getInputValue("State");
        String status = GuiUtil.getMessage("transactionId.Unknown");
        if (state != null) {
            status = state.equals("False") ? GuiUtil.getMessage("transactionId.UnFreeze") : GuiUtil.getMessage("transactionId.Freeze");
        }
        handlerCtx.setOutputValue("Status", (Object)status);
    }

    public void setTransactionState(HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("ObjectName");
        String state = (String)handlerCtx.getInputValue("State");
        String methodName = state.equals("False") ? "freeze" : "unfreeze";
        JMXUtil.invoke(objectName, methodName, null, null);
    }
}

