/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.SystemInfo;
import com.sun.appserv.management.base.UploadDownloadMgr;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.IIOPServiceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;
import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.helper.LBConfigHelper;
import com.sun.appserv.management.j2ee.J2EEDomain;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.j2ee.StateManageable;
import com.sun.appserv.management.monitor.MonitoringRoot;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXUtil {
    private static ProxyFactory amxProxyFactory = null;
    private static DomainRoot domainRoot = null;
    private static DomainConfig domainConfig = null;
    private static J2EEDomain j2eeDomain = null;
    private static MonitoringRoot monitoringRoot = null;
    private static QueryMgr queryMgr = null;
    private static UploadDownloadMgr uploadDownloadMgr = null;
    private static WebServiceMgr webServiceMgr = null;
    private static LBConfigHelper lbConfigHelper = null;
    private static final Set<String> APP_TYPES = GSetUtil.newUnmodifiableStringSet((String[])new String[]{"X-J2EEApplicationConfig", "X-WebModuleConfig", "X-EJBModuleConfig", "X-LifecycleModuleConfig", "X-RARModuleConfig", "X-AppClientModuleConfig", "X-CustomMBeanConfig"});
    private static final Map<Integer, String> stateImageMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> stateMap;

    private AMXUtil() {
    }

    public static DomainConfig getDomainConfig() {
        return domainConfig == null ? AMXUtil.getDomainRoot().getDomainConfig() : domainConfig;
    }

    public static J2EEDomain getJ2EEDomain() {
        return j2eeDomain == null ? AMXUtil.getDomainRoot().getJ2EEDomain() : j2eeDomain;
    }

    public static MonitoringRoot getMonitoringRoot() {
        return monitoringRoot == null ? AMXUtil.getDomainRoot().getMonitoringRoot() : monitoringRoot;
    }

    public static WebServiceMgr getWebServiceMgr() {
        return webServiceMgr == null ? AMXUtil.getDomainRoot().getWebServiceMgr() : webServiceMgr;
    }

    public static DomainRoot getDomainRoot() {
        return domainRoot == null ? AMXUtil.getAMXProxyFactory().getDomainRoot() : domainRoot;
    }

    public static QueryMgr getQueryMgr() {
        return queryMgr == null ? AMXUtil.getDomainRoot().getQueryMgr() : queryMgr;
    }

    public static UploadDownloadMgr getUploadDownloadMgr() {
        return uploadDownloadMgr == null ? AMXUtil.getDomainRoot().getUploadDownloadMgr() : uploadDownloadMgr;
    }

    public static ProxyFactory getAMXProxyFactory() {
        return amxProxyFactory == null ? ProxyFactory.getInstance((MBeanServer)MBeanServerFactory.getMBeanServer()) : amxProxyFactory;
    }

    public static ServerRootMonitor getServerRootMonitor(String instanceName) {
        if (GuiUtil.isEmpty(instanceName)) {
            return null;
        }
        return (ServerRootMonitor)AMXUtil.getDomainRoot().getMonitoringRoot().getServerRootMonitorMap().get(instanceName);
    }

    public static LBConfigHelper getLBConfigHelper() {
        return lbConfigHelper == null ? new LBConfigHelper(AMXUtil.getDomainRoot()) : lbConfigHelper;
    }

    public static ConfigConfig getConfig(String configName) {
        if (GuiUtil.isEmpty(configName)) {
            return null;
        }
        Map cmap = AMXUtil.getDomainConfig().getConfigConfigMap();
        ConfigConfig config = (ConfigConfig)cmap.get(configName);
        return config;
    }

    public static String getConfigName(String name) {
        ServerConfig serverConfig = (ServerConfig)AMXUtil.getDomainConfig().getServerConfigMap().get(name);
        if (serverConfig != null) {
            return serverConfig.getReferencedConfigName();
        }
        ClusterConfig clusterConfig = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(name);
        if (clusterConfig != null) {
            return clusterConfig.getReferencedConfigName();
        }
        return null;
    }

    public static ConfigConfig getConfigByInstanceOrClusterName(String instanceName) {
        boolean isEERunning = AMXUtil.isEE();
        return AMXUtil.getConfig(AMXUtil.getConfigName(instanceName));
    }

    public static HTTPListenerConfig getHTTPListenerConfig(String configName, String listenerName) {
        HTTPServiceConfig service;
        if (GuiUtil.isEmpty(configName) || GuiUtil.isEmpty(listenerName)) {
            return null;
        }
        ConfigConfig config = AMXUtil.getConfig(configName);
        HTTPServiceConfig hTTPServiceConfig = service = config == null ? null : config.getHTTPServiceConfig();
        if (service != null) {
            Map listeners = service.getHTTPListenerConfigMap();
            HTTPListenerConfig listener = (HTTPListenerConfig)listeners.get(listenerName);
            return listener;
        }
        return null;
    }

    public static IIOPListenerConfig getIIOPListenerConfig(String configName, String listenerName) {
        IIOPServiceConfig service;
        if (GuiUtil.isEmpty(configName) || GuiUtil.isEmpty(listenerName)) {
            return null;
        }
        ConfigConfig config = AMXUtil.getConfig(configName);
        IIOPServiceConfig iIOPServiceConfig = service = config == null ? null : config.getIIOPServiceConfig();
        if (service != null) {
            Map listeners = service.getIIOPListenerConfigMap();
            IIOPListenerConfig listener = (IIOPListenerConfig)listeners.get(listenerName);
            return listener;
        }
        return null;
    }

    public static boolean isEE() {
        SystemInfo systemInfo = AMXUtil.getDomainRoot().getSystemInfo();
        return systemInfo.supportsFeature("SupportsClusters");
    }

    public static boolean supportCluster() {
        SystemInfo systemInfo = AMXUtil.getDomainRoot().getSystemInfo();
        return systemInfo.supportsFeature("SupportsClusters");
    }

    public static String getPropertyValue(PropertiesAccess mbean, String propName) {
        return mbean.getPropertyValue(propName);
    }

    public static WebServiceEndpointInfo getWebServiceEndpointInfo(Object webServiceKey) {
        return AMXUtil.getWebServiceMgr().getWebServiceEndpointInfo(webServiceKey);
    }

    public static void editProperties(HandlerContext handlerCtx, PropertiesAccess config) {
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        if (removeProps != null) {
            String[] remove = removeProps.toArray(new String[removeProps.size()]);
            for (int i = 0; i < remove.length; ++i) {
                config.removeProperty(remove[i]);
            }
        }
        if (addProps != null) {
            for (String key : addProps.keySet()) {
                String value = (String)addProps.get(key);
                if (config.existsProperty(key)) {
                    config.setPropertyValue(key, value);
                    continue;
                }
                config.createProperty(key, value);
            }
        }
    }

    public static void updateProperties(PropertiesAccess config, Map<String, String> newProps, List ignore) {
        Map oldProps = config.getProperties();
        if (ignore == null) {
            ignore = new ArrayList();
        }
        for (Object key : oldProps.keySet()) {
            if (ignore.contains(key) || newProps.containsKey(key)) continue;
            config.removeProperty((String)key);
        }
        for (String propName : newProps.keySet()) {
            String val = newProps.get(propName);
            if (config.existsProperty(propName)) {
                String oldValue = config.getPropertyValue(propName);
                if (oldValue.equals(val)) continue;
                config.setPropertyValue(propName, val);
                continue;
            }
            config.createProperty(propName, val);
        }
    }

    public static Map convertToPropertiesOptionMap(Map<String, String> props, Map<String, String> convertedMap) {
        if (convertedMap == null) {
            convertedMap = new HashMap<String, String>();
        }
        if (props == null) {
            return convertedMap;
        }
        Set<String> keySet = props.keySet();
        for (String key : keySet) {
            if (GuiUtil.isEmpty(props.get(key))) continue;
            convertedMap.put("property." + key, props.get(key));
        }
        return convertedMap;
    }

    public static Map getNonSkipPropertiesMap(PropertiesAccess config, List skipList) {
        Map props = config.getProperties();
        HashMap newMap = new HashMap();
        for (String propsName : props.keySet()) {
            if (skipList.contains(propsName)) continue;
            newMap.put(propsName, props.get(propsName));
        }
        return newMap;
    }

    public static void changeProperty(PropertiesAccess config, String propName, String propValue) {
        if (config.existsProperty(propName)) {
            if (GuiUtil.isEmpty(propValue)) {
                config.removeProperty(propName);
            } else {
                config.setPropertyValue(propName, propValue);
            }
        } else if (!GuiUtil.isEmpty(propValue)) {
            config.createProperty(propName, propValue);
        }
    }

    public static String getAppType(String name) {
        Set applications = AMXUtil.getQueryMgr().queryJ2EETypesSet(APP_TYPES);
        for (AMXConfig app : applications) {
            if (!app.getName().equals(name)) continue;
            return app.getJ2EEType();
        }
        return "";
    }

    public static String getStatusForDisplay(AMX obj, boolean includeString) {
        boolean restart;
        if (!(obj instanceof StateManageable)) {
            return "";
        }
        int state = ((StateManageable)obj).getstate();
        if (obj instanceof J2EEServer && state == 1 && (restart = ((J2EEServer)obj).getRestartRequired())) {
            String image = GuiUtil.getMessage("common.restartRequiredImage");
            return includeString ? image + "&nbsp;" + GuiUtil.getMessage("common.restartRequired") : image;
        }
        if (includeString) {
            return AMXUtil.getStatusImage(state) + "&nbsp;" + AMXUtil.getStatusString(state);
        }
        return AMXUtil.getStatusImage(state);
    }

    public static String getStatusImage(int state) {
        return stateImageMap.get(state);
    }

    public static String getStatusString(int state) {
        return stateMap.get(state);
    }

    static {
        stateImageMap.put(4, GuiUtil.getMessage("common.failedImage"));
        stateImageMap.put(1, GuiUtil.getMessage("common.runningImage"));
        stateImageMap.put(0, GuiUtil.getMessage("common.startingImage"));
        stateImageMap.put(3, GuiUtil.getMessage("common.stoppedImage"));
        stateImageMap.put(2, GuiUtil.getMessage("common.stoppingImage"));
        stateMap = new HashMap<Integer, String>();
        stateMap.put(4, GuiUtil.getMessage("common.failedState"));
        stateMap.put(1, GuiUtil.getMessage("common.runningState"));
        stateMap.put(0, GuiUtil.getMessage("common.startingState"));
        stateMap.put(3, GuiUtil.getMessage("common.stoppedState"));
        stateMap.put(2, GuiUtil.getMessage("common.stoppingState"));
    }
}

