/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;

public class FileUtil {
    private static final String GUI_TEMPDIR_NAME = "admingui";

    public static boolean delete(File f) {
        boolean deleteStatus = false;
        if (f != null) {
            if (f.isDirectory()) {
                FileUtil.deleteDirContents(f);
                deleteStatus = f.delete();
            } else {
                deleteStatus = f.delete();
            }
        }
        return deleteStatus;
    }

    public static boolean delete(String file) {
        return FileUtil.delete(new File(file));
    }

    private static boolean deleteDirContents(File dir) {
        boolean deleteStatus = false;
        try {
            File dirCon = dir.getCanonicalFile();
            String[] files = dirCon.list();
            for (int i = 0; i < files.length; ++i) {
                File f = new File(dir, files[i]);
                File filePath = f.getCanonicalFile();
                deleteStatus = filePath.getParentFile().equals(dirCon) ? FileUtil.delete(filePath) : FileUtil.delete(filePath);
            }
        }
        catch (IOException ex) {
            deleteStatus = false;
            throw new SecurityException(ex);
        }
        return deleteStatus;
    }

    public static String getTempDirPath() throws Exception {
        String localTmpDir = System.getProperty("java.io.tmpDir");
        File tempFolder = new File(localTmpDir, GUI_TEMPDIR_NAME);
        if (!tempFolder.exists()) {
            boolean bl = tempFolder.mkdirs();
        }
        return tempFolder.getCanonicalPath();
    }

    public static boolean isJarFile(File file) {
        try {
            boolean result = false;
            if (file.getName().endsWith(".jar")) {
                JarFile jar = new JarFile(file);
                if (jar != null) {
                    result = jar.entries().hasMoreElements();
                }
                jar.close();
                return result;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static String getFileName(String filePath) {
        String name = new File(filePath).getName();
        int index = name.indexOf(".");
        if (index > 0) {
            return name.substring(0, index);
        }
        return filePath;
    }

    public static void main(String[] args) {
        FileUtil.delete("/export/home/TEMP/jws/glassfish/admin-gui/admin-jsf/src/docroot/");
    }
}

