/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLDocument;
import net.jxta.id.ID;

public abstract class Advertisement {
    public Advertisement clone() throws CloneNotSupportedException {
        return (Advertisement)super.clone();
    }

    public String toString() {
        XMLDocument doc = (XMLDocument)this.getDocument(MimeMediaType.XMLUTF8);
        doc.addAttribute("xml:space", "default");
        return doc.toString();
    }

    public static String getAdvertisementType() {
        throw new UnsupportedOperationException("Advertisement : sub-class failed to override getAdvertisementType. getAdvertisementType() is static and is *not* polymorphic.");
    }

    public String getAdvType() {
        try {
            Method getAdvertisementTypeMethod = this.getClass().getMethod("getAdvertisementType", null);
            String result = (String)getAdvertisementTypeMethod.invoke(null, (Object[])null);
            return result;
        }
        catch (NoSuchMethodException failed) {
            UnsupportedOperationException failure = new UnsupportedOperationException("Could not get Advertisement type.");
            failure.initCause(failed);
            throw failure;
        }
        catch (IllegalAccessException failed) {
            SecurityException failure = new SecurityException("Could not get Advertisement type.");
            failure.initCause(failed);
            throw failure;
        }
        catch (InvocationTargetException failed) {
            UndeclaredThrowableException failure = new UndeclaredThrowableException(failed, "Failed getting Advertisement type.");
            failure.initCause(failed.getCause());
            throw failure;
        }
    }

    public abstract Document getDocument(MimeMediaType var1);

    public abstract ID getID();

    public abstract String[] getIndexFields();
}

